/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ValidityDateTrustManager
implements X509TrustManager {
    @NotNull
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];

    @Override
    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        ValidityDateTrustManager.checkCertificateValidity(chain[0]);
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        ValidityDateTrustManager.checkCertificateValidity(chain[0]);
    }

    private static void checkCertificateValidity(@NotNull X509Certificate c) throws CertificateException {
        Date currentTime = new Date();
        Date notBefore = c.getNotBefore();
        Date notAfter = c.getNotAfter();
        if (currentTime.before(notBefore)) {
            throw new CertificateException(SSLMessages.ERR_VALIDITY_TOO_EARLY.get(c.getSubjectX500Principal().getName("RFC2253"), String.valueOf(notBefore)));
        }
        if (currentTime.after(c.getNotAfter())) {
            throw new CertificateException(SSLMessages.ERR_VALIDITY_TOO_LATE.get(c.getSubjectX500Principal().getName("RFC2253"), String.valueOf(notAfter)));
        }
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

