/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PassphraseEncryptedStreamHeader;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;

final class PassphraseEncryptedStreamHeaderCachedKeyIdentifier
implements Serializable {
    @NotNull
    private static final String DIGEST_ALGORITHM = "SHA-256";
    @NotNull
    private static final ThreadLocal<ByteStringBuffer> BUFFERS = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<MessageDigest> DIGESTS = new ThreadLocal();
    private static final long serialVersionUID = 103858128692088432L;
    @NotNull
    private final byte[] keyFactorySalt;
    @NotNull
    private final byte[] saltedPaspshraseDigest;
    private final int hashCode;
    private final int keyFactoryIterationCount;
    private final int keyFactoryKeyLengthBits;
    @NotNull
    private final String keyFactoryAlgorithm;

    PassphraseEncryptedStreamHeaderCachedKeyIdentifier(@NotNull String keyFactoryAlgorithm, @NotNull byte[] keyFactorySalt, int keyFactoryIterationCount, int keyFactoryKeyLengthBits, @NotNull char[] passphrase) throws GeneralSecurityException {
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.keyFactorySalt = keyFactorySalt;
        this.keyFactoryIterationCount = keyFactoryIterationCount;
        this.keyFactoryKeyLengthBits = keyFactoryKeyLengthBits;
        this.saltedPaspshraseDigest = PassphraseEncryptedStreamHeaderCachedKeyIdentifier.computeSaltedPassphraseDigest(passphrase, keyFactorySalt);
        this.hashCode = Arrays.hashCode(keyFactorySalt);
    }

    PassphraseEncryptedStreamHeaderCachedKeyIdentifier(@NotNull PassphraseEncryptedStreamHeader encryptionHeader, @NotNull char[] passphrase) throws GeneralSecurityException {
        this(encryptionHeader.getKeyFactoryAlgorithm(), encryptionHeader.getKeyFactorySalt(), encryptionHeader.getKeyFactoryIterationCount(), encryptionHeader.getKeyFactoryKeyLengthBits(), passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static byte[] computeSaltedPassphraseDigest(@NotNull char[] passphrase, @NotNull byte[] salt) throws GeneralSecurityException {
        ByteStringBuffer buffer = BUFFERS.get();
        if (buffer == null) {
            buffer = new ByteStringBuffer();
            BUFFERS.set(buffer);
        }
        try {
            buffer.append(passphrase);
            buffer.append(salt);
            MessageDigest digest = DIGESTS.get();
            if (digest == null) {
                digest = CryptoHelper.getMessageDigest(DIGEST_ALGORITHM);
                DIGESTS.set(digest);
            }
            digest.update(buffer.getBackingArray(), 0, buffer.length());
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            buffer.clear(true);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassphraseEncryptedStreamHeaderCachedKeyIdentifier)) {
            return false;
        }
        PassphraseEncryptedStreamHeaderCachedKeyIdentifier i = (PassphraseEncryptedStreamHeaderCachedKeyIdentifier)o;
        return Arrays.equals(this.saltedPaspshraseDigest, i.saltedPaspshraseDigest) && Arrays.equals(this.keyFactorySalt, i.keyFactorySalt) && this.keyFactoryIterationCount == i.keyFactoryIterationCount && this.keyFactoryKeyLengthBits == i.keyFactoryKeyLengthBits && this.keyFactoryAlgorithm.equals(i.keyFactoryAlgorithm);
    }
}

