/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinedEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinResultControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String JOIN_RESULT_OID = "1.3.6.1.4.1.30221.2.5.9";
    private static final byte TYPE_REFERRAL_URLS = -93;
    private static final byte TYPE_JOIN_RESULTS = -92;
    @NotNull
    private static final String JSON_FIELD_DIAGNOSTIC_MESSAGE = "diagnostic-message";
    @NotNull
    private static final String JSON_FIELD_ENTRY_DN = "_dn";
    @NotNull
    private static final String JSON_FIELD_JOINED_ENTRIES = "joined-entries";
    @NotNull
    private static final String JSON_FIELD_MATCHED_DN = "matched-dn";
    @NotNull
    private static final String JSON_FIELD_NESTED_JOIN_RESULTS = "_nested-join-results";
    @NotNull
    private static final String JSON_FIELD_REFERRAL_URLS = "referral-urls";
    @NotNull
    private static final String JSON_FIELD_RESULT_CODE = "result-code";
    private static final long serialVersionUID = 681831114773253358L;
    @NotNull
    private final List<JoinedEntry> joinResults;
    @NotNull
    private final List<String> referralURLs;
    @NotNull
    private final ResultCode resultCode;
    @Nullable
    private final String diagnosticMessage;
    @Nullable
    private final String matchedDN;

    JoinResultControl() {
        this.resultCode = null;
        this.diagnosticMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
        this.joinResults = null;
    }

    public JoinResultControl(@Nullable List<JoinedEntry> joinResults) {
        this(ResultCode.SUCCESS, null, null, null, joinResults);
    }

    public JoinResultControl(@NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable List<String> referralURLs, @Nullable List<JoinedEntry> joinResults) {
        super(JOIN_RESULT_OID, false, JoinResultControl.encodeValue(resultCode, diagnosticMessage, matchedDN, referralURLs, joinResults));
        this.resultCode = resultCode;
        this.diagnosticMessage = diagnosticMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs == null ? Collections.emptyList() : Collections.unmodifiableList(referralURLs);
        this.joinResults = joinResults == null ? Collections.emptyList() : Collections.unmodifiableList(joinResults);
    }

    public JoinResultControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.resultCode = ResultCode.valueOf(ASN1Enumerated.decodeAsEnumerated(elements[0]).intValue());
            String matchedDNStr = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            this.matchedDN = matchedDNStr.isEmpty() ? null : matchedDNStr;
            String diagnosticMessageStr = ASN1OctetString.decodeAsOctetString(elements[2]).stringValue();
            this.diagnosticMessage = diagnosticMessageStr.isEmpty() ? null : diagnosticMessageStr;
            ArrayList<String> refs = new ArrayList<String>(5);
            ArrayList<JoinedEntry> entries = new ArrayList<JoinedEntry>(20);
            block6: for (int i = 3; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -93: {
                        ASN1Element[] refElements;
                        for (ASN1Element e : refElements = ASN1Sequence.decodeAsSequence(elements[i]).elements()) {
                            refs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        continue block6;
                    }
                    case -92: {
                        ASN1Element[] entryElements;
                        for (ASN1Element e : entryElements = ASN1Sequence.decodeAsSequence(elements[i]).elements()) {
                            entries.add(JoinedEntry.decode(e));
                        }
                        continue block6;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.referralURLs = Collections.unmodifiableList(refs);
            this.joinResults = Collections.unmodifiableList(entries);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable List<String> referralURLs, @Nullable List<JoinedEntry> joinResults) {
        Validator.ensureNotNull(resultCode);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
        elements.add(new ASN1Enumerated(resultCode.intValue()));
        if (matchedDN == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(matchedDN));
        }
        if (diagnosticMessage == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(diagnosticMessage));
        }
        if (referralURLs != null && !referralURLs.isEmpty()) {
            ArrayList<ASN1OctetString> refElements = new ArrayList<ASN1OctetString>(referralURLs.size());
            for (String s : referralURLs) {
                refElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-93, refElements));
        }
        if (joinResults == null || joinResults.isEmpty()) {
            elements.add(new ASN1Sequence(-92));
        } else {
            ArrayList<ASN1Element> entryElements = new ArrayList<ASN1Element>(joinResults.size());
            for (JoinedEntry e : joinResults) {
                entryElements.add(e.encode());
            }
            elements.add(new ASN1Sequence(-92, entryElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Nullable
    public String getMatchedDN() {
        return this.matchedDN;
    }

    @NotNull
    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @NotNull
    public List<JoinedEntry> getJoinResults() {
        return this.joinResults;
    }

    @Override
    @NotNull
    public JoinResultControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new JoinResultControl(oid, isCritical, value);
    }

    @Nullable
    public static JoinResultControl get(@NotNull SearchResultEntry entry) throws LDAPException {
        Control c = entry.getControl(JOIN_RESULT_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof JoinResultControl) {
            return (JoinResultControl)c;
        }
        return new JoinResultControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_JOIN_RESULT.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_RESULT_CODE, new JSONNumber(this.resultCode.intValue()));
        if (this.matchedDN != null) {
            valueFields.put(JSON_FIELD_MATCHED_DN, new JSONString(this.matchedDN));
        }
        if (this.diagnosticMessage != null) {
            valueFields.put(JSON_FIELD_DIAGNOSTIC_MESSAGE, new JSONString(this.diagnosticMessage));
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            ArrayList<JSONString> referralValues = new ArrayList<JSONString>(this.referralURLs.size());
            for (String referralURL : this.referralURLs) {
                referralValues.add(new JSONString(referralURL));
            }
            valueFields.put(JSON_FIELD_REFERRAL_URLS, new JSONArray(referralValues));
        }
        ArrayList<JSONObject> entryValues = new ArrayList<JSONObject>(this.joinResults.size());
        for (JoinedEntry entry : this.joinResults) {
            entryValues.add(JoinResultControl.encodeEntryJSON(entry));
        }
        valueFields.put(JSON_FIELD_JOINED_ENTRIES, new JSONArray(entryValues));
        return new JSONObject(new JSONField("oid", JOIN_RESULT_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_JOIN_RESULT.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    private static JSONObject encodeEntryJSON(@NotNull JoinedEntry entry) {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>();
        fields.put(JSON_FIELD_ENTRY_DN, new JSONString(entry.getDN()));
        for (Attribute a : entry.getAttributes()) {
            ArrayList<JSONString> attrValueValues = new ArrayList<JSONString>(a.size());
            for (String value : a.getValues()) {
                attrValueValues.add(new JSONString(value));
            }
            fields.put(a.getName(), new JSONArray(attrValueValues));
        }
        List<JoinedEntry> nestedEntries = entry.getNestedJoinResults();
        if (!nestedEntries.isEmpty()) {
            ArrayList<JSONObject> nestedEntryValues = new ArrayList<JSONObject>(nestedEntries.size());
            for (JoinedEntry nestedEntry : nestedEntries) {
                nestedEntryValues.add(JoinResultControl.encodeEntryJSON(nestedEntry));
            }
            fields.put(JSON_FIELD_NESTED_JOIN_RESULTS, new JSONArray(nestedEntryValues));
        }
        return new JSONObject(fields);
    }

    @NotNull
    public static JoinResultControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ArrayList<String> referralURLs;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new JoinResultControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Integer resultCodeValue = valueObject.getFieldAsInteger(JSON_FIELD_RESULT_CODE);
        if (resultCodeValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_MISSING_VALUE_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_RESULT_CODE));
        }
        ResultCode resultCode = ResultCode.valueOf(resultCodeValue);
        String matchedDN = valueObject.getFieldAsString(JSON_FIELD_MATCHED_DN);
        String diagnosticMessage = valueObject.getFieldAsString(JSON_FIELD_DIAGNOSTIC_MESSAGE);
        List<JSONValue> referralURLValues = valueObject.getFieldAsArray(JSON_FIELD_REFERRAL_URLS);
        if (referralURLValues == null) {
            referralURLs = null;
        } else {
            referralURLs = new ArrayList<String>(referralURLValues.size());
            for (JSONValue referralURLValue : referralURLValues) {
                if (referralURLValue instanceof JSONString) {
                    referralURLs.add(((JSONString)referralURLValue).stringValue());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_REFERRAL_URL_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_REFERRAL_URLS));
            }
        }
        List<JSONValue> joinedEntryValues = valueObject.getFieldAsArray(JSON_FIELD_JOINED_ENTRIES);
        if (joinedEntryValues == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_MISSING_VALUE_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_JOINED_ENTRIES));
        }
        ArrayList<JoinedEntry> joinedEntries = new ArrayList<JoinedEntry>(joinedEntryValues.size());
        for (JSONValue joinedEntryValue : joinedEntryValues) {
            if (joinedEntryValue instanceof JSONObject) {
                joinedEntries.add(JoinResultControl.decodeEntryJSON(controlObject, (JSONObject)joinedEntryValue));
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_ENTRY_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_JOINED_ENTRIES));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_RESULT_CODE, JSON_FIELD_MATCHED_DN, JSON_FIELD_DIAGNOSTIC_MESSAGE, JSON_FIELD_REFERRAL_URLS, JSON_FIELD_JOINED_ENTRIES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new JoinResultControl(resultCode, diagnosticMessage, matchedDN, referralURLs, joinedEntries);
    }

    @NotNull
    private static JoinedEntry decodeEntryJSON(@NotNull JSONObject controlObject, @NotNull JSONObject entryObject) throws LDAPException {
        String entryDN = null;
        ArrayList<JoinedEntry> nestedResults = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(entryObject.getFields().size());
        for (Map.Entry<String, JSONValue> e : entryObject.getFields().entrySet()) {
            String fieldName = e.getKey();
            JSONValue fieldValue = e.getValue();
            if (fieldName.equals(JSON_FIELD_ENTRY_DN)) {
                if (fieldValue instanceof JSONString) {
                    entryDN = ((JSONString)fieldValue).stringValue();
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_ENTRY_DN_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_ENTRY_DN));
            }
            if (fieldName.equals(JSON_FIELD_NESTED_JOIN_RESULTS)) {
                if (fieldValue instanceof JSONArray) {
                    List<JSONValue> nestedEntryValues = ((JSONArray)fieldValue).getValues();
                    nestedResults = new ArrayList<JoinedEntry>(nestedEntryValues.size());
                    for (JSONValue nestedEntryValue : nestedEntryValues) {
                        if (nestedEntryValue instanceof JSONObject) {
                            nestedResults.add(JoinResultControl.decodeEntryJSON(controlObject, (JSONObject)nestedEntryValue));
                            continue;
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JON_RESULT_JSON_ENTRY_NESTED_ENTRY_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_NESTED_JOIN_RESULTS));
                    }
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_ENTRY_NESTED_ENTRIES_NOT_ARRAY.get(controlObject.toSingleLineString(), JSON_FIELD_NESTED_JOIN_RESULTS));
            }
            if (fieldValue instanceof JSONArray) {
                List<JSONValue> attrValueValues = ((JSONArray)fieldValue).getValues();
                ArrayList<String> attributeValues = new ArrayList<String>(attrValueValues.size());
                for (JSONValue v : attrValueValues) {
                    if (v instanceof JSONString) {
                        attributeValues.add(((JSONString)v).stringValue());
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_ENTRY_ATTR_VALUE_NOT_STRING.get(controlObject.toSingleLineString(), fieldName));
                }
                attributes.add(new Attribute(fieldName, attributeValues));
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_JSON_ENTRY_ATTR_VALUES_NOT_ARRAY.get(controlObject.toSingleLineString(), fieldName));
        }
        if (entryDN == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JON_RESULT_JSON_ENTRY_MISSING_DN.get(controlObject.toSingleLineString(), JSON_FIELD_ENTRY_DN));
        }
        return new JoinedEntry(entryDN, attributes, nestedResults);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("JoinResultControl(resultCode='");
        buffer.append(this.resultCode.getName());
        buffer.append("', diagnosticMessage='");
        if (this.diagnosticMessage != null) {
            buffer.append(this.diagnosticMessage);
        }
        buffer.append("', matchedDN='");
        if (this.matchedDN != null) {
            buffer.append(this.matchedDN);
        }
        buffer.append("', referralURLs={");
        Iterator<String> refIterator = this.referralURLs.iterator();
        while (refIterator.hasNext()) {
            buffer.append(refIterator.next());
            if (!refIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, joinResults={");
        Iterator<JoinedEntry> entryIterator = this.joinResults.iterator();
        while (entryIterator.hasNext()) {
            entryIterator.next().toString(buffer);
            if (!entryIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

