/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.ByteString;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ByteStringBuffer
implements Serializable,
Appendable {
    private static final int DEFAULT_INITIAL_CAPACITY = 20;
    private static final byte[] FALSE_VALUE_BYTES = StaticUtils.getBytes("false");
    private static final byte[] TRUE_VALUE_BYTES = StaticUtils.getBytes("true");
    private static final ThreadLocal<byte[]> TEMP_NUMBER_BUFFER = new ThreadLocal();
    private static final long serialVersionUID = 2899392249591230998L;
    private byte[] array;
    private int capacity;
    private int endPos;

    public ByteStringBuffer() {
        this(20);
    }

    public ByteStringBuffer(int initialCapacity) {
        this.array = new byte[initialCapacity];
        this.capacity = initialCapacity;
        this.endPos = 0;
    }

    public ByteStringBuffer append(boolean b) {
        if (b) {
            return this.append(TRUE_VALUE_BYTES, 0, 4);
        }
        return this.append(FALSE_VALUE_BYTES, 0, 5);
    }

    public ByteStringBuffer append(byte b) {
        this.ensureCapacity(this.endPos + 1);
        this.array[this.endPos++] = b;
        return this;
    }

    public ByteStringBuffer append(byte[] b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.append(b, 0, b.length);
    }

    public ByteStringBuffer append(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, b.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (len > 0) {
            this.ensureCapacity(this.endPos + len);
            System.arraycopy(b, off, this.array, this.endPos, len);
            this.endPos += len;
        }
        return this;
    }

    public ByteStringBuffer append(ByteString b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        b.appendValueTo(this);
        return this;
    }

    public ByteStringBuffer append(ByteStringBuffer buffer) throws NullPointerException {
        if (buffer == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.append(buffer.array, 0, buffer.endPos);
    }

    @Override
    public ByteStringBuffer append(char c) {
        byte b = (byte)(c & 0x7F);
        if (b == c) {
            this.ensureCapacity(this.endPos + 1);
            this.array[this.endPos++] = b;
        } else {
            this.append(String.valueOf(c));
        }
        return this;
    }

    public ByteStringBuffer append(char[] c) throws NullPointerException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.append(c, 0, c.length);
    }

    public ByteStringBuffer append(char[] c, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > c.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, c.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (len > 0) {
            this.ensureCapacity(this.endPos + len);
            int pos = off;
            int i = 0;
            while (i < len) {
                byte b = (byte)(c[pos] & 0x7F);
                if (b != c[pos]) {
                    String remainingString = String.valueOf(c, pos, off + len - pos);
                    byte[] remainingBytes = StaticUtils.getBytes(remainingString);
                    return this.append(remainingBytes);
                }
                this.array[this.endPos++] = b;
                ++i;
                ++pos;
            }
        }
        return this;
    }

    @Override
    public ByteStringBuffer append(CharSequence s) throws NullPointerException {
        return this.append(s, 0, s.length());
    }

    @Override
    public ByteStringBuffer append(CharSequence s, int start, int end) throws NullPointerException, IndexOutOfBoundsException {
        if (s == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        char[] chars = s instanceof String ? ((String)s).toCharArray() : s.toString().toCharArray();
        return this.append(chars, start, end);
    }

    public ByteStringBuffer append(int i) {
        int length = ByteStringBuffer.getBytes(i);
        return this.append(TEMP_NUMBER_BUFFER.get(), 0, length);
    }

    public ByteStringBuffer append(long l) {
        int length = ByteStringBuffer.getBytes(l);
        return this.append(TEMP_NUMBER_BUFFER.get(), 0, length);
    }

    public ByteStringBuffer insert(int pos, boolean b) throws IndexOutOfBoundsException {
        if (b) {
            return this.insert(pos, TRUE_VALUE_BYTES, 0, 4);
        }
        return this.insert(pos, FALSE_VALUE_BYTES, 0, 5);
    }

    public ByteStringBuffer insert(int pos, byte b) throws IndexOutOfBoundsException {
        if (pos < 0 || pos > this.endPos) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos);
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos == this.endPos) {
            return this.append(b);
        }
        this.ensureCapacity(this.endPos + 1);
        System.arraycopy(this.array, pos, this.array, pos + 1, this.endPos - pos);
        this.array[pos] = b;
        ++this.endPos;
        return this;
    }

    public ByteStringBuffer insert(int pos, byte[] b) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, b, 0, b.length);
    }

    public ByteStringBuffer insert(int pos, byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos < 0 || pos > this.endPos || off < 0 || len < 0 || off + len > b.length) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : (pos > this.endPos ? UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos) : (off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, b.length))));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (len == 0) {
            return this;
        }
        if (pos == this.endPos) {
            return this.append(b, off, len);
        }
        this.ensureCapacity(this.endPos + len);
        System.arraycopy(this.array, pos, this.array, pos + len, this.endPos - pos);
        System.arraycopy(b, off, this.array, pos, len);
        this.endPos += len;
        return this;
    }

    public ByteStringBuffer insert(int pos, ByteString b) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, b.getValue());
    }

    public ByteStringBuffer insert(int pos, ByteStringBuffer buffer) throws NullPointerException, IndexOutOfBoundsException {
        if (buffer == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, buffer.array, 0, buffer.endPos);
    }

    public ByteStringBuffer insert(int pos, char c) throws IndexOutOfBoundsException {
        if (pos < 0 || pos > this.endPos) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos);
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos == this.endPos) {
            return this.append(c);
        }
        byte b = (byte)(c & 0x7F);
        if (b == c) {
            this.ensureCapacity(this.endPos + 1);
            System.arraycopy(this.array, pos, this.array, pos + 1, this.endPos - pos);
            this.array[pos] = b;
            ++this.endPos;
        } else {
            this.insert(pos, String.valueOf(c));
        }
        return this;
    }

    public ByteStringBuffer insert(int pos, char[] c) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, new String(c, 0, c.length));
    }

    public ByteStringBuffer insert(int pos, char[] c, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, new String(c, off, len));
    }

    public ByteStringBuffer insert(int pos, CharSequence s) throws NullPointerException, IndexOutOfBoundsException {
        if (s == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos < 0 || pos > this.endPos) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos);
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos == this.endPos) {
            return this.append(s);
        }
        return this.insert(pos, StaticUtils.getBytes(s.toString()));
    }

    public ByteStringBuffer insert(int pos, int i) throws IndexOutOfBoundsException {
        int length = ByteStringBuffer.getBytes(i);
        return this.insert(pos, TEMP_NUMBER_BUFFER.get(), 0, length);
    }

    public ByteStringBuffer insert(int pos, long l) throws IndexOutOfBoundsException {
        int length = ByteStringBuffer.getBytes(l);
        return this.insert(pos, TEMP_NUMBER_BUFFER.get(), 0, length);
    }

    public ByteStringBuffer delete(int len) throws IndexOutOfBoundsException {
        return this.delete(0, len);
    }

    public ByteStringBuffer delete(int off, int len) throws IndexOutOfBoundsException {
        if (off < 0) {
            throw new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off));
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len));
        }
        if (off + len > this.endPos) {
            throw new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, this.endPos));
        }
        if (len == 0) {
            return this;
        }
        if (off == 0) {
            if (len == this.endPos) {
                this.endPos = 0;
                return this;
            }
            int newEndPos = this.endPos - len;
            System.arraycopy(this.array, len, this.array, 0, newEndPos);
            this.endPos = newEndPos;
            return this;
        }
        if (off + len == this.endPos) {
            this.endPos = off;
            return this;
        }
        int bytesToCopy = this.endPos - (off + len);
        System.arraycopy(this.array, off + len, this.array, off, bytesToCopy);
        this.endPos -= len;
        return this;
    }

    public ByteStringBuffer set(boolean b) {
        if (b) {
            return this.set(TRUE_VALUE_BYTES, 0, 4);
        }
        return this.set(FALSE_VALUE_BYTES, 0, 5);
    }

    public ByteStringBuffer set(byte b) {
        this.endPos = 0;
        return this.append(b);
    }

    public ByteStringBuffer set(byte[] b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(b, 0, b.length);
    }

    public ByteStringBuffer set(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, b.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(b, off, len);
    }

    public ByteStringBuffer set(ByteString b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        b.appendValueTo(this);
        return this;
    }

    public ByteStringBuffer set(ByteStringBuffer buffer) throws NullPointerException {
        if (buffer == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(buffer.array, 0, buffer.endPos);
    }

    public ByteStringBuffer set(char c) {
        this.endPos = 0;
        return this.append(c);
    }

    public ByteStringBuffer set(char[] c) throws NullPointerException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(c, 0, c.length);
    }

    public ByteStringBuffer set(char[] c, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > c.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, c.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(c, off, len);
    }

    public ByteStringBuffer set(CharSequence s) throws NullPointerException {
        if (s == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(s);
    }

    public ByteStringBuffer set(int i) {
        int length = ByteStringBuffer.getBytes(i);
        return this.set(TEMP_NUMBER_BUFFER.get(), 0, length);
    }

    public ByteStringBuffer set(long l) {
        int length = ByteStringBuffer.getBytes(l);
        return this.set(TEMP_NUMBER_BUFFER.get(), 0, length);
    }

    public ByteStringBuffer clear() {
        this.endPos = 0;
        return this;
    }

    public ByteStringBuffer clear(boolean zero) {
        this.endPos = 0;
        if (zero) {
            Arrays.fill(this.array, (byte)0);
        }
        return this;
    }

    public byte[] getBackingArray() {
        return this.array;
    }

    public boolean isEmpty() {
        return this.endPos == 0;
    }

    public int length() {
        return this.endPos;
    }

    public void setLength(int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(length));
            Debug.debugCodingError(e);
            throw e;
        }
        if (length > this.endPos) {
            this.ensureCapacity(length);
            Arrays.fill(this.array, this.endPos, length, (byte)0);
            this.endPos = length;
        } else {
            this.endPos = length;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.capacity < minimumCapacity) {
            int newCapacity = Math.max(minimumCapacity, 2 * this.capacity + 2);
            byte[] newArray = new byte[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.capacity);
            this.array = newArray;
            this.capacity = newCapacity;
        }
    }

    public void setCapacity(int capacity) throws IndexOutOfBoundsException {
        if (capacity < 0) {
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_CAPACITY_NEGATIVE.get(capacity));
            Debug.debugCodingError(e);
            throw e;
        }
        if (this.capacity == capacity) {
            return;
        }
        if (this.capacity < capacity) {
            byte[] newArray = new byte[capacity];
            System.arraycopy(this.array, 0, newArray, 0, this.capacity);
            this.array = newArray;
            this.capacity = capacity;
        } else {
            byte[] newArray = new byte[capacity];
            System.arraycopy(this.array, 0, newArray, 0, capacity);
            this.array = newArray;
            this.endPos = Math.min(this.endPos, capacity);
            this.capacity = capacity;
        }
    }

    public ByteStringBuffer trimToSize() {
        if (this.endPos != this.capacity) {
            byte[] newArray = new byte[this.endPos];
            System.arraycopy(this.array, 0, newArray, 0, this.endPos);
            this.array = newArray;
            this.capacity = this.endPos;
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] newArray = new byte[this.endPos];
        System.arraycopy(this.array, 0, newArray, 0, this.endPos);
        return newArray;
    }

    public ByteString toByteString() {
        return new ASN1OctetString(this.toByteArray());
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.array, 0, this.endPos);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.array, 0, this.endPos);
    }

    private static int getBytes(long l) {
        byte[] b = TEMP_NUMBER_BUFFER.get();
        if (b == null) {
            b = new byte[20];
            TEMP_NUMBER_BUFFER.set(b);
        }
        if (l == Long.MIN_VALUE) {
            b[0] = 45;
            b[1] = 57;
            b[2] = 50;
            b[3] = 50;
            b[4] = 51;
            b[5] = 51;
            b[6] = 55;
            b[7] = 50;
            b[8] = 48;
            b[9] = 51;
            b[10] = 54;
            b[11] = 56;
            b[12] = 53;
            b[13] = 52;
            b[14] = 55;
            b[15] = 55;
            b[16] = 53;
            b[17] = 56;
            b[18] = 48;
            b[19] = 56;
            return 20;
        }
        if (l == 0L) {
            b[0] = 48;
            return 1;
        }
        int pos = 0;
        long v = l;
        if (l < 0L) {
            b[0] = 45;
            pos = 1;
            v = Math.abs(l);
        }
        long divisor = v <= 9L ? 1L : (v <= 99L ? 10L : (v <= 999L ? 100L : (v <= 9999L ? 1000L : (v <= 99999L ? 10000L : (v <= 999999L ? 100000L : (v <= 9999999L ? 1000000L : (v <= 99999999L ? 10000000L : (v <= 999999999L ? 100000000L : (v <= 9999999999L ? 1000000000L : (v <= 99999999999L ? 10000000000L : (v <= 999999999999L ? 100000000000L : (v <= 9999999999999L ? 1000000000000L : (v <= 99999999999999L ? 10000000000000L : (v <= 999999999999999L ? 100000000000000L : (v <= 9999999999999999L ? 1000000000000000L : (v <= 99999999999999999L ? 10000000000000000L : (v <= 999999999999999999L ? 100000000000000000L : 1000000000000000000L)))))))))))))))));
        while (true) {
            long digit = v / divisor;
            switch ((int)digit) {
                case 0: {
                    b[pos++] = 48;
                    break;
                }
                case 1: {
                    b[pos++] = 49;
                    break;
                }
                case 2: {
                    b[pos++] = 50;
                    break;
                }
                case 3: {
                    b[pos++] = 51;
                    break;
                }
                case 4: {
                    b[pos++] = 52;
                    break;
                }
                case 5: {
                    b[pos++] = 53;
                    break;
                }
                case 6: {
                    b[pos++] = 54;
                    break;
                }
                case 7: {
                    b[pos++] = 55;
                    break;
                }
                case 8: {
                    b[pos++] = 56;
                    break;
                }
                case 9: {
                    b[pos++] = 57;
                }
            }
            if (divisor == 1L) break;
            if ((v -= divisor * digit) == 0L) {
                while (divisor > 1L) {
                    b[pos++] = 48;
                    divisor /= 10L;
                }
                break;
            }
            divisor /= 10L;
        }
        return pos;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.endPos; ++i) {
            hashCode += this.array[i];
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteStringBuffer)) {
            return false;
        }
        ByteStringBuffer b = (ByteStringBuffer)o;
        if (this.endPos != b.endPos) {
            return false;
        }
        for (int i = 0; i < this.endPos; ++i) {
            if (this.array[i] == b.array[i]) continue;
            return false;
        }
        return true;
    }

    public ByteStringBuffer duplicate() {
        ByteStringBuffer newBuffer = new ByteStringBuffer(this.endPos);
        return newBuffer.append(this);
    }

    public String toString() {
        return StaticUtils.toUTF8String(this.array, 0, this.endPos);
    }
}

