/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Extensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.List;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class InMemoryPasswordEncoder {
    private final byte[] prefixBytes;
    private final PasswordEncoderOutputFormatter outputFormatter;
    private final String prefix;

    protected InMemoryPasswordEncoder(String prefix, PasswordEncoderOutputFormatter outputFormatter) {
        Validator.ensureTrue(prefix != null && prefix.length() > 0, "The password encoder prefix must not be null or empty.");
        this.prefix = prefix;
        this.outputFormatter = outputFormatter;
        this.prefixBytes = StaticUtils.getBytes(prefix);
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final PasswordEncoderOutputFormatter getOutputFormatter() {
        return this.outputFormatter;
    }

    public final ASN1OctetString encodePassword(ASN1OctetString clearPassword, ReadOnlyEntry userEntry, List<Modification> modifications) throws LDAPException {
        if (clearPassword.getValueLength() == 0) {
            throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_ENCODER_ENCODE_PASSWORD_EMPTY.get());
        }
        byte[] clearPasswordBytes = clearPassword.getValue();
        byte[] encodedPasswordBytes = this.encodePassword(clearPasswordBytes, userEntry, modifications);
        byte[] formattedEncodedPasswordBytes = this.outputFormatter == null ? encodedPasswordBytes : this.outputFormatter.format(encodedPasswordBytes);
        byte[] formattedPasswordBytesWithPrefix = new byte[formattedEncodedPasswordBytes.length + this.prefixBytes.length];
        System.arraycopy(this.prefixBytes, 0, formattedPasswordBytesWithPrefix, 0, this.prefixBytes.length);
        System.arraycopy(formattedEncodedPasswordBytes, 0, formattedPasswordBytesWithPrefix, this.prefixBytes.length, formattedEncodedPasswordBytes.length);
        return new ASN1OctetString(formattedPasswordBytesWithPrefix);
    }

    protected abstract byte[] encodePassword(byte[] var1, ReadOnlyEntry var2, List<Modification> var3) throws LDAPException;

    public final void ensurePreEncodedPasswordAppearsValid(ASN1OctetString prefixedFormattedEncodedPassword, ReadOnlyEntry userEntry, List<Modification> modifications) throws LDAPException {
        byte[] prefixedFormattedEncodedPasswordBytes = prefixedFormattedEncodedPassword.getValue();
        if (!this.passwordStartsWithPrefix(prefixedFormattedEncodedPasswordBytes)) {
            throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_ENCODER_VALIDATE_ENCODED_PW_MISSING_PREFIX.get(this.getClass().getName(), this.prefix));
        }
        byte[] unPrefixedFormattedEncodedPasswordBytes = new byte[prefixedFormattedEncodedPasswordBytes.length - this.prefixBytes.length];
        System.arraycopy(prefixedFormattedEncodedPasswordBytes, this.prefixBytes.length, unPrefixedFormattedEncodedPasswordBytes, 0, unPrefixedFormattedEncodedPasswordBytes.length);
        byte[] unPrefixedUnFormattedEncodedPasswordBytes = this.outputFormatter == null ? unPrefixedFormattedEncodedPasswordBytes : this.outputFormatter.unFormat(unPrefixedFormattedEncodedPasswordBytes);
        this.ensurePreEncodedPasswordAppearsValid(unPrefixedUnFormattedEncodedPasswordBytes, userEntry, modifications);
    }

    protected abstract void ensurePreEncodedPasswordAppearsValid(byte[] var1, ReadOnlyEntry var2, List<Modification> var3) throws LDAPException;

    public final boolean clearPasswordMatchesEncodedPassword(ASN1OctetString clearPassword, ASN1OctetString prefixedFormattedEncodedPassword, ReadOnlyEntry userEntry) throws LDAPException {
        byte[] clearPasswordBytes = clearPassword.getValue();
        if (clearPasswordBytes.length == 0) {
            return false;
        }
        byte[] prefixedFormattedEncodedPasswordBytes = prefixedFormattedEncodedPassword.getValue();
        if (!this.passwordStartsWithPrefix(prefixedFormattedEncodedPasswordBytes)) {
            return false;
        }
        byte[] unPrefixedFormattedEncodedPasswordBytes = new byte[prefixedFormattedEncodedPasswordBytes.length - this.prefixBytes.length];
        System.arraycopy(prefixedFormattedEncodedPasswordBytes, this.prefixBytes.length, unPrefixedFormattedEncodedPasswordBytes, 0, unPrefixedFormattedEncodedPasswordBytes.length);
        byte[] unPrefixedUnFormattedEncodedPasswordBytes = this.outputFormatter == null ? unPrefixedFormattedEncodedPasswordBytes : this.outputFormatter.unFormat(unPrefixedFormattedEncodedPasswordBytes);
        if (unPrefixedUnFormattedEncodedPasswordBytes.length == 0) {
            return false;
        }
        return this.passwordMatches(clearPasswordBytes, unPrefixedUnFormattedEncodedPasswordBytes, userEntry);
    }

    protected abstract boolean passwordMatches(byte[] var1, byte[] var2, ReadOnlyEntry var3) throws LDAPException;

    public final ASN1OctetString extractClearPasswordFromEncodedPassword(ASN1OctetString prefixedFormattedEncodedPassword, ReadOnlyEntry userEntry) throws LDAPException {
        byte[] prefixedFormattedEncodedPasswordBytes = prefixedFormattedEncodedPassword.getValue();
        if (!this.passwordStartsWithPrefix(prefixedFormattedEncodedPasswordBytes)) {
            throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_ENCODER_PW_MATCHES_ENCODED_PW_MISSING_PREFIX.get(this.getClass().getName(), this.prefix));
        }
        byte[] unPrefixedFormattedEncodedPasswordBytes = new byte[prefixedFormattedEncodedPasswordBytes.length - this.prefixBytes.length];
        System.arraycopy(prefixedFormattedEncodedPasswordBytes, this.prefixBytes.length, unPrefixedFormattedEncodedPasswordBytes, 0, unPrefixedFormattedEncodedPasswordBytes.length);
        byte[] unPrefixedUnFormattedEncodedPasswordBytes = this.outputFormatter == null ? unPrefixedFormattedEncodedPasswordBytes : this.outputFormatter.unFormat(unPrefixedFormattedEncodedPasswordBytes);
        byte[] clearPasswordBytes = this.extractClearPassword(unPrefixedUnFormattedEncodedPasswordBytes, userEntry);
        return new ASN1OctetString(clearPasswordBytes);
    }

    protected abstract byte[] extractClearPassword(byte[] var1, ReadOnlyEntry var2) throws LDAPException;

    public final boolean passwordStartsWithPrefix(ASN1OctetString password) {
        return this.passwordStartsWithPrefix(password.getValue());
    }

    private boolean passwordStartsWithPrefix(byte[] b) {
        if (b.length < this.prefixBytes.length) {
            return false;
        }
        for (int i = 0; i < this.prefixBytes.length; ++i) {
            if (b[i] == this.prefixBytes[i]) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);
}

