/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.FastestConnectThread;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FastestConnectServerSet
extends ServerSet {
    private final int[] ports;
    private final LDAPConnectionOptions connectionOptions;
    private final SocketFactory socketFactory;
    private final String[] addresses;

    public FastestConnectServerSet(String[] addresses, int[] ports) {
        this(addresses, ports, null, null);
    }

    public FastestConnectServerSet(String[] addresses, int[] ports, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, null, connectionOptions);
    }

    public FastestConnectServerSet(String[] addresses, int[] ports, SocketFactory socketFactory) {
        this(addresses, ports, socketFactory, null);
    }

    public FastestConnectServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        Validator.ensureNotNull(addresses, ports);
        Validator.ensureTrue(addresses.length > 0, "RoundRobinServerSet.addresses must not be empty.");
        Validator.ensureTrue(addresses.length == ports.length, "RoundRobinServerSet addresses and ports arrays must be the same size.");
        this.addresses = addresses;
        this.ports = ports;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        if (!this.connectionOptions.allowConcurrentSocketFactoryUse()) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_FASTEST_CONNECT_SET_OPTIONS_NOT_PARALLEL.get());
        }
        ArrayBlockingQueue<Object> resultQueue = new ArrayBlockingQueue<Object>(this.addresses.length, false);
        AtomicBoolean connectionSelected = new AtomicBoolean(false);
        FastestConnectThread[] connectThreads = new FastestConnectThread[this.addresses.length];
        for (int i = 0; i < connectThreads.length; ++i) {
            connectThreads[i] = new FastestConnectThread(this.addresses[i], this.ports[i], this.socketFactory, this.connectionOptions, healthCheck, resultQueue, connectionSelected);
        }
        for (FastestConnectThread t : connectThreads) {
            t.start();
        }
        try {
            long connectTimeout = this.connectionOptions.getConnectTimeoutMillis();
            long effectiveConnectTimeout = connectTimeout > 0L && connectTimeout < Integer.MAX_VALUE ? connectTimeout : Integer.MAX_VALUE;
            int connectFailures = 0;
            long stopWaitingTime = System.currentTimeMillis() + effectiveConnectTimeout;
            do {
                long waitTime;
                Object o;
                if ((o = (waitTime = stopWaitingTime - System.currentTimeMillis()) > 0L ? resultQueue.poll(waitTime, TimeUnit.MILLISECONDS) : resultQueue.poll()) == null) {
                    throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_FASTEST_CONNECT_SET_CONNECT_TIMEOUT.get(effectiveConnectTimeout));
                }
                if (!(o instanceof LDAPConnection)) continue;
                return (LDAPConnection)o;
            } while (++connectFailures < this.addresses.length);
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_FASTEST_CONNECT_SET_ALL_FAILED.get());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_FASTEST_CONNECT_SET_CONNECT_EXCEPTION.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public void toString(StringBuilder buffer) {
        buffer.append("FastestConnectServerSet(servers={");
        for (int i = 0; i < this.addresses.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.addresses[i]);
            buffer.append(':');
            buffer.append(this.ports[i]);
        }
        buffer.append("})");
    }
}

