/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CompareRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -562642367801440060L;
    private final ASN1OctetString assertionValue;
    private final String attributeName;
    private final String dn;

    public CompareRequestProtocolOp(String dn, String attributeName, ASN1OctetString assertionValue) {
        this.dn = dn;
        this.attributeName = attributeName;
        this.assertionValue = assertionValue;
    }

    CompareRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.dn = reader.readString();
            reader.beginSequence();
            this.attributeName = reader.readString();
            this.assertionValue = new ASN1OctetString(reader.readBytes());
            Validator.ensureNotNull(this.dn, this.attributeName, this.assertionValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_COMPARE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public ASN1OctetString getAssertionValue() {
        return this.assertionValue;
    }

    public byte getProtocolOpType() {
        return 110;
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)110);
        buffer.addOctetString(this.dn);
        ASN1BufferSequence avaSequence = buffer.beginSequence();
        buffer.addOctetString(this.attributeName);
        buffer.addElement(this.assertionValue);
        avaSequence.end();
        opSequence.end();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("CompareRequestProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("', attributeName='");
        buffer.append(this.attributeName);
        buffer.append("', assertionValue='");
        buffer.append(this.assertionValue.stringValue());
        buffer.append("')");
    }
}

