/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

import com.twelvemonkeys.imageio.metadata.AbstractEntry;
import com.twelvemonkeys.imageio.metadata.exif.TIFF;

final class EXIFEntry
extends AbstractEntry {
    private final short type;

    EXIFEntry(int n, Object object, short s) {
        super(n, object);
        if (s < 1 || s > TIFF.TYPE_NAMES.length) {
            throw new IllegalArgumentException(String.format("Illegal EXIF type: %s", s));
        }
        this.type = s;
    }

    public short getType() {
        return this.type;
    }

    public String getFieldName() {
        switch ((Integer)this.getIdentifier()) {
            case 34665: {
                return "EXIF";
            }
            case 40965: {
                return "Interoperability";
            }
            case 34853: {
                return "GPS";
            }
            case 700: {
                return "XMP";
            }
            case 33723: {
                return "IPTC";
            }
            case 34377: {
                return "Adobe";
            }
            case 34675: {
                return "ICCProfile";
            }
            case 256: {
                return "ImageWidth";
            }
            case 257: {
                return "ImageHeight";
            }
            case 258: {
                return "BitsPerSample";
            }
            case 259: {
                return "Compression";
            }
            case 262: {
                return "PhotometricInterpretation";
            }
            case 270: {
                return "ImageDescription";
            }
            case 273: {
                return "StripOffsets";
            }
            case 274: {
                return "Orientation";
            }
            case 277: {
                return "SamplesPerPixels";
            }
            case 278: {
                return "RowsPerStrip";
            }
            case 279: {
                return "StripByteCounts";
            }
            case 282: {
                return "XResolution";
            }
            case 283: {
                return "YResolution";
            }
            case 284: {
                return "PlanarConfiguration";
            }
            case 296: {
                return "ResolutionUnit";
            }
            case 513: {
                return "JPEGInterchangeFormat";
            }
            case 514: {
                return "JPEGInterchangeFormatLength";
            }
            case 271: {
                return "Make";
            }
            case 272: {
                return "Model";
            }
            case 305: {
                return "Software";
            }
            case 306: {
                return "DateTime";
            }
            case 315: {
                return "Artist";
            }
            case 316: {
                return "HostComputer";
            }
            case 33432: {
                return "Copyright";
            }
            case 530: {
                return "YCbCrSubSampling";
            }
            case 531: {
                return "YCbCrPositioning";
            }
            case 320: {
                return "ColorMap";
            }
            case 338: {
                return "ExtraSamples";
            }
            case 33434: {
                return "ExposureTime";
            }
            case 33437: {
                return "FNUmber";
            }
            case 34850: {
                return "ExposureProgram";
            }
            case 34855: {
                return "ISOSpeedRatings";
            }
            case 37377: {
                return "ShutterSpeedValue";
            }
            case 37378: {
                return "ApertureValue";
            }
            case 37379: {
                return "BrightnessValue";
            }
            case 37380: {
                return "ExposureBiasValue";
            }
            case 37381: {
                return "MaxApertureValue";
            }
            case 37382: {
                return "SubjectDistance";
            }
            case 37383: {
                return "MeteringMode";
            }
            case 37384: {
                return "LightSource";
            }
            case 37385: {
                return "Flash";
            }
            case 37386: {
                return "FocalLength";
            }
            case 41728: {
                return "FileSource";
            }
            case 41729: {
                return "SceneType";
            }
            case 41730: {
                return "CFAPattern";
            }
            case 41985: {
                return "CustomRendered";
            }
            case 41986: {
                return "ExposureMode";
            }
            case 41987: {
                return "WhiteBalance";
            }
            case 41988: {
                return "DigitalZoomRation";
            }
            case 41989: {
                return "FocalLengthIn35mmFilm";
            }
            case 41990: {
                return "SceneCaptureType";
            }
            case 41991: {
                return "GainControl";
            }
            case 41992: {
                return "Contrast";
            }
            case 41993: {
                return "Saturation";
            }
            case 41994: {
                return "Sharpness";
            }
            case 40960: {
                return "FlashpixVersion";
            }
            case 36864: {
                return "ExifVersion";
            }
            case 36867: {
                return "DateTimeOriginal";
            }
            case 36868: {
                return "DateTimeDigitized";
            }
            case 37393: {
                return "ImageNumber";
            }
            case 37510: {
                return "UserComment";
            }
            case 37121: {
                return "ComponentsConfiguration";
            }
            case 37122: {
                return "CompressedBitsPerPixel";
            }
            case 40961: {
                return "ColorSpace";
            }
            case 40962: {
                return "PixelXDimension";
            }
            case 40963: {
                return "PixelYDimension";
            }
        }
        return null;
    }

    public String getTypeName() {
        return TIFF.TYPE_NAMES[this.type - 1];
    }
}

