/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.iterator.OLazyWrapperIterator;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;

public class OrientEdgeIterator
extends OLazyWrapperIterator<OrientEdge> {
    private final OrientVertex vertex;
    private final OPair<Direction, String> connection;
    private final String[] labels;

    public OrientEdgeIterator(OrientVertex iVertex, Iterator<?> iterator, OPair<Direction, String> connection, String[] iLabels, int iSize) {
        super(iterator, iSize);
        this.vertex = iVertex;
        this.connection = connection;
        this.labels = iLabels;
    }

    public OrientEdge createWrapper(Object iObject) {
        OrientEdge edge;
        if (iObject instanceof OrientEdge) {
            return (OrientEdge)iObject;
        }
        OIdentifiable rec = (OIdentifiable)iObject;
        ODocument value = (ODocument)rec.getRecord();
        if (value == null || value.getSchemaClass() == null) {
            return null;
        }
        if (value.getSchemaClass().isSubClassOf("V")) {
            edge = this.connection.getKey() == Direction.OUT ? new OrientEdge(this.vertex.graph, (OIdentifiable)this.vertex.getIdentity(), (OIdentifiable)rec.getIdentity(), (String)this.connection.getValue()) : new OrientEdge(this.vertex.graph, (OIdentifiable)rec.getIdentity(), (OIdentifiable)this.vertex.getIdentity(), (String)this.connection.getValue());
        } else if (value.getSchemaClass().isSubClassOf("E")) {
            edge = new OrientEdge(this.vertex.graph, (OIdentifiable)rec.getIdentity());
        } else {
            throw new IllegalStateException("Invalid content found between connections:" + value);
        }
        if (this.vertex.graph.isUseVertexFieldsForEdgeLabels() || edge.isLabeled(this.labels)) {
            return edge;
        }
        return null;
    }

    public boolean filter(OrientEdge iObject) {
        return this.vertex.graph.isUseVertexFieldsForEdgeLabels() || iObject.isLabeled(this.labels);
    }
}

