/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OrientEdge
extends OrientElement
implements Edge {
    private static final long serialVersionUID = 1L;
    public static final String CLASS_NAME = "E";
    protected OIdentifiable vOut;
    protected OIdentifiable vIn;
    protected String label;

    public OrientEdge(OrientBaseGraph rawGraph, OIdentifiable rawEdge) {
        super(rawGraph, rawEdge);
    }

    public OrientEdge(OrientBaseGraph rawGraph, String iLabel, Object ... fields) {
        super(rawGraph, null);
        this.rawElement = this.createDocument(iLabel);
        this.setProperties(fields);
    }

    public OrientEdge(OrientBaseGraph rawGraph, OIdentifiable out, OIdentifiable in) {
        this(rawGraph, out, in, null);
    }

    public OrientEdge(OrientBaseGraph rawGraph, OIdentifiable out, OIdentifiable in, String iLabel) {
        super(rawGraph, null);
        this.vOut = out;
        this.vIn = in;
        this.label = iLabel;
    }

    public OrientVertex getVertex(Direction direction) {
        this.graph.setCurrentGraphInThreadLocal();
        if (direction.equals((Object)Direction.OUT)) {
            return new OrientVertex(this.graph, this.getOutVertex());
        }
        if (direction.equals((Object)Direction.IN)) {
            return new OrientVertex(this.graph, this.getInVertex());
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public OIdentifiable getOutVertex() {
        if (this.vOut != null) {
            return this.vOut;
        }
        this.graph.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        if (doc == null) {
            return null;
        }
        if (this.graph.isKeepInMemoryReferences()) {
            return (OIdentifiable)doc.rawField("out");
        }
        return (OIdentifiable)doc.field("out");
    }

    public OIdentifiable getInVertex() {
        if (this.vIn != null) {
            return this.vIn;
        }
        this.graph.setCurrentGraphInThreadLocal();
        ODocument doc = this.getRecord();
        if (doc == null) {
            return null;
        }
        if (this.graph.isKeepInMemoryReferences()) {
            return (OIdentifiable)doc.rawField("in");
        }
        return (OIdentifiable)doc.field("in");
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.rawElement != null) {
            String clsName;
            if (this.graph.isUseClassForEdgeLabel() && !CLASS_NAME.equals(clsName = this.getRecord().getClassName()) && !"OGraphEdge".equals(clsName)) {
                return OrientBaseGraph.decodeClassName(clsName);
            }
            this.graph.setCurrentGraphInThreadLocal();
            ODocument doc = (ODocument)this.rawElement.getRecord();
            if (doc == null) {
                return null;
            }
            String label = (String)doc.field("label");
            if (label != null) {
                return OrientBaseGraph.decodeClassName(label);
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this.rawElement == null && object instanceof OrientEdge) {
            OrientEdge other = (OrientEdge)object;
            return this.vOut.equals(other.vOut) && this.vIn.equals(other.vIn) && (this.label == null && other.label == null || this.label.equals(other.label));
        }
        return super.equals(object);
    }

    @Override
    public Object getId() {
        if (this.rawElement == null) {
            return this.vOut.getIdentity() + "->" + this.vIn.getIdentity();
        }
        this.graph.setCurrentGraphInThreadLocal();
        return super.getId();
    }

    @Override
    public <T> T getProperty(String key) {
        this.graph.setCurrentGraphInThreadLocal();
        if (this.rawElement == null) {
            return null;
        }
        return super.getProperty(key);
    }

    public Set<String> getPropertyKeys() {
        if (this.rawElement == null) {
            return Collections.emptySet();
        }
        this.graph.setCurrentGraphInThreadLocal();
        HashSet<String> result = new HashSet<String>();
        for (String field : this.getRecord().fieldNames()) {
            if (field.equals("out") || field.equals("in") || !this.graph.isUseClassForEdgeLabel() && field.equals("label")) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.graph.setCurrentGraphInThreadLocal();
        if (this.rawElement == null) {
            this.convertToDocument();
        }
        super.setProperty(key, value);
    }

    @Override
    public <T> T removeProperty(String key) {
        this.graph.setCurrentGraphInThreadLocal();
        if (this.rawElement != null) {
            return super.removeProperty(key);
        }
        return null;
    }

    @Override
    public void remove() {
        this.checkClass();
        this.graph.autoStartTransaction();
        for (Index index : this.graph.getManualIndices()) {
            if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
            OrientIndex idx = (OrientIndex)index;
            idx.removeElement(this);
        }
        OIdentifiable inVertexEdge = this.vIn != null ? this.vIn : this.rawElement;
        ODocument oDocument = (ODocument)this.getOutVertex().getRecord();
        String edgeClassName = OrientBaseGraph.encodeClassName(this.getLabel());
        boolean useVertexFieldsForEdgeLabels = this.graph.isUseVertexFieldsForEdgeLabels();
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, edgeClassName, useVertexFieldsForEdgeLabels);
        this.dropEdgeFromVertex(inVertexEdge, oDocument, outFieldName, oDocument.field(outFieldName));
        OIdentifiable outVertexEdge = this.vOut != null ? this.vOut : this.rawElement;
        ODocument inVertex = (ODocument)this.getInVertex().getRecord();
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, edgeClassName, useVertexFieldsForEdgeLabels);
        this.dropEdgeFromVertex(outVertexEdge, inVertex, inFieldName, inVertex.field(inFieldName));
        oDocument.save();
        inVertex.save();
        if (this.rawElement != null) {
            super.remove();
        }
    }

    @Override
    public final String getBaseClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getElementType() {
        return "Edge";
    }

    public String toString() {
        this.graph.setCurrentGraphInThreadLocal();
        if (this.getLabel() == null) {
            return "e[" + this.getId() + "]" + "[" + this.getVertex(Direction.OUT).getId() + "->" + this.getVertex(Direction.IN).getId() + "]";
        }
        return StringFactory.edgeString((Edge)this);
    }

    public static OIdentifiable getConnection(ODocument iEdgeRecord, Direction iDirection) {
        return (OIdentifiable)iEdgeRecord.rawField(iDirection == Direction.OUT ? "out" : "in");
    }

    protected boolean isLabeled(String[] iLabels) {
        return OrientEdge.isLabeled(this.getLabel(), iLabels);
    }

    public static boolean isLabeled(String iEdgeLabel, String[] iLabels) {
        if (iLabels != null && iLabels.length > 0) {
            if (iEdgeLabel != null) {
                for (String l : iLabels) {
                    if (!l.equals(iEdgeLabel)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public ODocument getRecord() {
        if (this.rawElement == null) {
            ODocument tmp = new ODocument(this.getClassName(this.label)).setTrackingChanges(false);
            tmp.field("in", (Object)this.vIn);
            tmp.field("out", (Object)this.vOut);
            if (this.label != null && !this.graph.isUseClassForEdgeLabel()) {
                tmp.field("label", (Object)this.label);
            }
            return tmp;
        }
        return super.getRecord();
    }

    public static String getRecordLabel(OIdentifiable iEdge) {
        if (iEdge == null) {
            return null;
        }
        ODocument edge = (ODocument)iEdge.getRecord();
        if (edge == null) {
            return null;
        }
        return (String)edge.field("label");
    }

    public void convertToDocument() {
        if (this.rawElement != null) {
            return;
        }
        this.graph.autoStartTransaction();
        ODocument vOutRecord = (ODocument)this.vOut.getRecord();
        ODocument vInRecord = (ODocument)this.vIn.getRecord();
        ODocument doc = this.createDocument(this.label);
        doc.field("out", this.graph.isKeepInMemoryReferences() ? vOutRecord.getIdentity() : vOutRecord);
        doc.field("in", this.graph.isKeepInMemoryReferences() ? vInRecord.getIdentity() : vInRecord);
        this.rawElement = doc;
        boolean useVertexFieldsForEdgeLabels = this.graph.isUseVertexFieldsForEdgeLabels();
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, this.label, useVertexFieldsForEdgeLabels);
        OrientVertex.removeEdges(vOutRecord, outFieldName, (OIdentifiable)vInRecord, false, useVertexFieldsForEdgeLabels);
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, this.label, useVertexFieldsForEdgeLabels);
        OrientVertex.removeEdges(vInRecord, inFieldName, (OIdentifiable)vOutRecord, false, useVertexFieldsForEdgeLabels);
        OrientVertex.createLink(vOutRecord, (OIdentifiable)doc, outFieldName);
        OrientVertex.createLink(vInRecord, (OIdentifiable)doc, inFieldName);
        doc.save();
        vOutRecord.save();
        vInRecord.save();
        this.vOut = null;
        this.vIn = null;
        this.label = null;
    }

    protected ODocument createDocument(String iLabel) {
        String className = this.getClassName(iLabel);
        ODocument doc = new ODocument(className);
        if (iLabel != null && !this.graph.isUseClassForEdgeLabel()) {
            doc.field("label", (Object)iLabel);
        }
        return doc;
    }

    public String getClassName(String iLabel) {
        if (iLabel != null && this.graph.isUseClassForEdgeLabel()) {
            return this.checkForClassInSchema(iLabel);
        }
        return CLASS_NAME;
    }

    protected void dropEdgeFromVertex(OIdentifiable iEdge, ODocument iVertex, String iFieldName, Object iFieldValue) {
        if (iFieldValue == null) {
            OLogManager.instance().debug((Object)this, "Edge not found in vertex's property %s.%s while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
        } else if (iFieldValue instanceof OIdentifiable) {
            if (iFieldValue.equals(iEdge)) {
                iVertex.removeField(iFieldName);
            } else {
                OLogManager.instance().warn((Object)this, "Edge not found in vertex's property %s.%s link while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            }
        } else if (iFieldValue instanceof OMVRBTreeRIDSet) {
            if (!((OMVRBTreeRIDSet)iFieldValue).remove((Object)iEdge)) {
                OLogManager.instance().warn((Object)this, "Edge not found in vertex's property %s.%s set while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            }
            if (((OMVRBTreeRIDSet)iFieldValue).size() == 1) {
                iVertex.field(iFieldName, ((OMVRBTreeRIDSet)iFieldValue).iterator().next());
            } else if (((OMVRBTreeRIDSet)iFieldValue).size() == 0) {
                iVertex.removeField(iFieldName);
            }
        } else if (iFieldValue instanceof Collection) {
            OMVRBTreeRIDSet out = new OMVRBTreeRIDSet((ORecord)iVertex, (Collection)iFieldValue);
            if (!out.remove((Object)iEdge)) {
                OLogManager.instance().warn((Object)this, "Edge not found in vertex's property %s.%s collection while removing the edge %s", new Object[]{iVertex.getIdentity(), iFieldName, iEdge.getIdentity()});
            } else {
                iVertex.field(iFieldName, (Object)out);
            }
        } else {
            throw new IllegalStateException("Wrong type found in the field '" + iFieldName + "': " + iFieldValue.getClass());
        }
    }
}

