/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

class OrientDynaElementIterator
implements Iterator<Object> {
    private final Iterator<?> itty;
    private final OrientBaseGraph graph;

    public OrientDynaElementIterator(OrientBaseGraph graph, Iterator<?> itty) {
        this.itty = itty;
        this.graph = graph;
    }

    @Override
    public boolean hasNext() {
        return this.itty.hasNext();
    }

    @Override
    public Object next() {
        OrientElement currentElement = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object current = this.itty.next();
        if (null == current) {
            throw new NoSuchElementException();
        }
        if (current instanceof OIdentifiable) {
            current = ((OIdentifiable)current).getRecord();
        }
        if (current instanceof ODocument) {
            ODocument currentDocument = (ODocument)current;
            if (currentDocument.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                currentDocument.load();
            }
            if (currentDocument.getSchemaClass() == null) {
                return currentDocument;
            }
            if (currentDocument.getSchemaClass().isSubClassOf(this.graph.getVertexBaseType())) {
                currentElement = new OrientVertex(this.graph, (OIdentifiable)currentDocument);
            } else if (currentDocument.getSchemaClass().isSubClassOf(this.graph.getEdgeBaseType())) {
                currentElement = new OrientEdge(this.graph, (OIdentifiable)currentDocument);
            } else {
                return currentDocument;
            }
        }
        return currentElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

