/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.protocol.soap.server;

import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.encoding.internal.InternalEncoder;
import com.sun.xml.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.handler.LogicalMessageImpl;
import com.sun.xml.ws.handler.SOAPHandlerContext;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.protocol.soap.server.SOAPMessageDispatcher;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.provider.ProviderPeptTie;
import com.sun.xml.ws.util.FastInfosetUtil;
import com.sun.xml.ws.util.MessageInfoUtil;
import com.sun.xml.ws.util.SOAPUtil;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;

public class ProviderSOAPMD
extends SOAPMessageDispatcher {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void toMessageInfo(MessageInfo messageInfo, SOAPHandlerContext context) {
        Object[] data = new Object[1];
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        Class providerClass = endpointInfo.getImplementorClass();
        boolean isSource = ProviderSOAPMD.isSource(providerClass);
        boolean isSoapMessage = ProviderSOAPMD.isSoapMessage(providerClass);
        if (!isSource && !isSoapMessage) {
            throw new UnsupportedOperationException("Endpoint should implement Provider<Source> or Provider<SOAPMessage>");
        }
        if (ProviderSOAPMD.getServiceMode(providerClass) == Service.Mode.PAYLOAD) {
            if (!isSource) throw new UnsupportedOperationException("Illeagal combination Mode.PAYLOAD and Provider<SOAPMessage>");
            data[0] = new LogicalMessageImpl(context).getPayload();
        } else {
            InternalMessage internalMessage = context.getInternalMessage();
            SOAPMessage soapMessage = context.getSOAPMessage();
            try {
                if (internalMessage != null) {
                    SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                    SOAPEncoder encoder = eptf.getSOAPEncoder();
                    soapMessage = encoder.toSOAPMessage(internalMessage, soapMessage);
                }
                data[0] = isSource ? soapMessage.getSOAPPart().getContent() : soapMessage;
            }
            catch (Exception e) {
                messageInfo.setResponseType(2);
                messageInfo.setResponse(e);
            }
        }
        messageInfo.setData(data);
        messageInfo.setMethod(ProviderPeptTie.invoke_Method);
    }

    protected void setResponseInContext(MessageInfo messageInfo, SOAPHandlerContext context) {
        Object obj = messageInfo.getResponse();
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        Class providerClass = endpointInfo.getImplementorClass();
        if (messageInfo.getResponseType() == 0 && ProviderSOAPMD.getServiceMode(providerClass) == Service.Mode.MESSAGE) {
            SOAPMessage soapMessage = null;
            if (obj instanceof SOAPMessage) {
                soapMessage = (SOAPMessage)obj;
            } else {
                try {
                    Source source = (Source)obj;
                    String bindingId = ((BindingImpl)endpointInfo.getBinding()).getBindingId();
                    soapMessage = SOAPUtil.createMessage(bindingId);
                    soapMessage.getSOAPPart().setContent(source);
                }
                catch (SOAPException e) {
                    throw new ServerRtException("soapencoder.err", new Object[]{e});
                }
            }
            FastInfosetUtil.ensureCorrectEncoding(messageInfo, soapMessage);
            context.setSOAPMessage(soapMessage);
            context.setInternalMessage(null);
        } else {
            SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            InternalEncoder ine = eptf.getInternalEncoder();
            InternalMessage internalMessage = (InternalMessage)ine.toInternalMessage(messageInfo);
            context.setInternalMessage(internalMessage);
            context.setSOAPMessage(null);
        }
    }

    protected void invokeEndpoint(MessageInfo messageInfo, SOAPHandlerContext hc) {
        super.invokeEndpoint(messageInfo, hc);
        if (ProviderSOAPMD.isOneway(messageInfo)) {
            this.sendResponseOneway(messageInfo);
        }
    }

    private static Service.Mode getServiceMode(Class c) {
        ServiceMode mode = c.getAnnotation(ServiceMode.class);
        if (mode == null) {
            return Service.Mode.PAYLOAD;
        }
        return mode.value();
    }

    private static boolean isSource(Class c) {
        try {
            c.getMethod("invoke", Source.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static boolean isSoapMessage(Class c) {
        try {
            c.getMethod("invoke", SOAPMessage.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

