/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.handler.HandlerException;
import com.sun.xml.ws.handler.SOAPHandlerContext;
import com.sun.xml.ws.handler.SOAPMessageContextImpl;
import com.sun.xml.ws.handler.XMLHandlerContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainCaller {
    public static final String HANDLER_CHAIN_CALLER = "handler_chain_caller";
    public static final String IGNORE_FAULT_PROPERTY = "ignore fault in message";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.handler");
    private Set<QName> understoodHeaders;
    private List<Handler> handlers;
    private List<LogicalHandler> logicalHandlers;
    private List<SOAPHandler> soapHandlers;
    private Set<String> roles;

    public HandlerChainCaller(List<Handler> chain) {
        if (chain == null) {
            chain = new ArrayList<Handler>();
        }
        this.handlers = chain;
        this.logicalHandlers = new ArrayList<LogicalHandler>();
        this.soapHandlers = new ArrayList<SOAPHandler>();
        this.understoodHeaders = new HashSet<QName>();
        this.sortHandlers();
    }

    public List<Handler> getHandlerChain() {
        return this.handlers;
    }

    public boolean hasHandlers() {
        return this.handlers.size() != 0;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<QName> getUnderstoodHeaders() {
        return this.understoodHeaders;
    }

    private void sortHandlers() {
        for (Handler handler : this.handlers) {
            if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                this.logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                this.soapHandlers.add((SOAPHandler)handler);
                Set headers = ((SOAPHandler)handler).getHeaders();
                if (headers == null) continue;
                this.understoodHeaders.addAll(headers);
                continue;
            }
            if (Handler.class.isAssignableFrom(handler.getClass())) {
                throw new HandlerException("cannot.extend.handler.directly", handler.getClass().toString());
            }
            throw new HandlerException("handler.not.valid.type", handler.getClass().toString());
        }
        this.handlers.clear();
        this.handlers.addAll(this.logicalHandlers);
        this.handlers.addAll(this.soapHandlers);
    }

    private void insertFaultMessage(ContextHolder holder, ProtocolException exception) {
        try {
            SOAPMessageContext context = holder.getSMC();
            if (context == null) {
                LogicalMessage msg = holder.getLMC().getMessage();
                if (msg != null) {
                    msg.setPayload(null);
                }
                return;
            }
            SOAPMessage message = context.getMessage();
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            SOAPBody body = envelope.getBody();
            if (body.hasFault()) {
                return;
            }
            if (envelope.getHeader() != null) {
                envelope.getHeader().detachNode();
            }
            body.removeContents();
            SOAPFault fault = body.addFault();
            String envelopeNamespace = envelope.getNamespaceURI();
            if (exception instanceof SOAPFaultException) {
                SOAPFaultException sfe = (SOAPFaultException)exception;
                SOAPFault userFault = sfe.getFault();
                QName faultCode = userFault.getFaultCodeAsQName();
                if (faultCode == null) {
                    faultCode = this.determineFaultCode(context);
                }
                fault.setFaultCode(faultCode);
                String faultString = userFault.getFaultString();
                if (faultString == null) {
                    faultString = sfe.getMessage() != null ? sfe.getMessage() : sfe.toString();
                }
                fault.setFaultString(faultString);
                String faultActor = userFault.getFaultActor();
                if (faultActor == null) {
                    faultActor = "";
                }
                fault.setFaultActor(faultActor);
                if (userFault.getDetail() != null) {
                    fault.addChildElement((SOAPElement)userFault.getDetail());
                }
            } else {
                fault.setFaultCode(this.determineFaultCode(context));
                if (exception.getMessage() != null) {
                    fault.setFaultString(exception.getMessage());
                } else {
                    fault.setFaultString(exception.toString());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception while creating fault message in handler chain", e);
            throw new RuntimeException(e);
        }
    }

    private void addIgnoreFaultProperty(ContextHolder holder) {
        LogicalMessageContext context = holder.getLMC();
        context.put((Object)IGNORE_FAULT_PROPERTY, (Object)Boolean.TRUE);
    }

    private QName determineFaultCode(SOAPMessageContext context) throws SOAPException {
        SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
        String uri = envelope.getNamespaceURI();
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            if (uri.equals("http://www.w3.org/2003/05/soap-envelope")) {
                return SOAP12Constants.FAULT_CODE_CLIENT;
            }
            return SOAPConstants.FAULT_CODE_CLIENT;
        }
        if (uri.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return SOAP12Constants.FAULT_CODE_SERVER;
        }
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    public boolean callHandlers(Direction direction, RequestOrResponse messageType, SOAPHandlerContext context, boolean responseExpected) {
        return this.internalCallHandlers(direction, messageType, new ContextHolder(context), responseExpected);
    }

    public boolean callHandlers(Direction direction, RequestOrResponse messageType, XMLHandlerContext context, boolean responseExpected) {
        return this.internalCallHandlers(direction, messageType, new ContextHolder(context), responseExpected);
    }

    private boolean internalCallHandlers(Direction direction, RequestOrResponse messageType, ContextHolder ch, boolean responseExpected) {
        ch.getLMC().put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction == Direction.OUTBOUND ? 1 : 0));
        if (ch.getSMC() != null) {
            ((SOAPMessageContextImpl)ch.getSMC()).setRoles(this.getRoles());
        }
        if (direction == Direction.OUTBOUND) {
            if (!this.callLogicalHandlers(ch, direction, messageType, responseExpected)) {
                return false;
            }
            if (!this.callProtocolHandlers(ch, direction, messageType, responseExpected)) {
                return false;
            }
        } else {
            if (!this.callProtocolHandlers(ch, direction, messageType, responseExpected)) {
                return false;
            }
            if (!this.callLogicalHandlers(ch, direction, messageType, responseExpected)) {
                return false;
            }
        }
        if (!responseExpected) {
            this.closeHandlers(ch);
        }
        return true;
    }

    public boolean callHandleFault(SOAPHandlerContext context) {
        ContextHolder ch = new ContextHolder(context);
        ch.getSMC().put((Object)"javax.xml.ws.handler.message.outbound", (Object)true);
        ((SOAPMessageContextImpl)ch.getSMC()).setRoles(this.getRoles());
        int j = 0;
        try {
            for (int i = 0; i < this.logicalHandlers.size(); ++i) {
                if (this.logicalHandlers.get(i).handleFault((MessageContext)ch.getLMC())) continue;
                boolean bl = false;
                return bl;
            }
            while (j < this.soapHandlers.size()) {
                if (!this.soapHandlers.get(j).handleFault((MessageContext)ch.getSMC())) {
                    boolean bl = false;
                    return bl;
                }
                ++j;
            }
        }
        catch (RuntimeException re) {
            logger.log(Level.FINER, "exception in handler chain", re);
            throw re;
        }
        finally {
            this.closeHandlers(ch);
        }
        return true;
    }

    private boolean callLogicalHandlers(ContextHolder holder, Direction direction, RequestOrResponse type, boolean responseExpected) {
        int i;
        if (direction == Direction.OUTBOUND) {
            int i2;
            try {
                for (i2 = 0; i2 < this.logicalHandlers.size(); ++i2) {
                    if (this.logicalHandlers.get(i2).handleMessage((MessageContext)holder.getLMC())) continue;
                    if (responseExpected) {
                        this.callLogicalHandleMessage(holder, i2 - 1, 0);
                    }
                    if (type == RequestOrResponse.RESPONSE) {
                        this.closeHandlers(holder);
                    } else {
                        this.closeLogicalHandlers(holder, i2, 0);
                    }
                    return false;
                }
            }
            catch (RuntimeException re2) {
                Throwable re2;
                logger.log(Level.FINER, "exception in handler chain", re2);
                if (responseExpected && re2 instanceof ProtocolException) {
                    this.insertFaultMessage(holder, (ProtocolException)((Object)re2));
                    if (i2 > 0) {
                        try {
                            this.callLogicalHandleFault(holder, i2 - 1, 0);
                        }
                        catch (ProtocolException re1) {
                            this.addIgnoreFaultProperty(holder);
                            re2 = re1;
                        }
                        catch (RuntimeException re22) {
                            re2 = re22;
                        }
                    }
                }
                if (type == RequestOrResponse.RESPONSE) {
                    this.closeHandlers(holder);
                } else {
                    this.closeLogicalHandlers(holder, i2, 0);
                }
                throw re2;
            }
        }
        try {
            for (i = this.logicalHandlers.size() - 1; i >= 0; --i) {
                if (this.logicalHandlers.get(i).handleMessage((MessageContext)holder.getLMC())) continue;
                if (responseExpected) {
                    this.callLogicalHandleMessage(holder, i + 1, this.logicalHandlers.size() - 1);
                    this.callProtocolHandleMessage(holder, 0, this.soapHandlers.size() - 1);
                }
                if (type == RequestOrResponse.RESPONSE) {
                    this.closeHandlers(holder);
                } else {
                    this.closeProtocolHandlers(holder, this.soapHandlers.size() - 1, 0);
                    this.closeLogicalHandlers(holder, this.logicalHandlers.size() - 1, i);
                }
                return false;
            }
        }
        catch (RuntimeException re3) {
            Throwable re3;
            logger.log(Level.FINER, "exception in handler chain", re3);
            if (responseExpected && re3 instanceof ProtocolException) {
                this.insertFaultMessage(holder, (ProtocolException)((Object)re3));
                try {
                    if (i == this.logicalHandlers.size() - 1 || this.callLogicalHandleFault(holder, i + 1, this.logicalHandlers.size() - 1)) {
                        this.callProtocolHandleFault(holder, 0, this.soapHandlers.size() - 1);
                    }
                }
                catch (ProtocolException re1) {
                    this.addIgnoreFaultProperty(holder);
                    re3 = re1;
                }
                catch (RuntimeException re2) {
                    re3 = re2;
                }
            }
            if (type == RequestOrResponse.RESPONSE) {
                this.closeHandlers(holder);
            } else {
                this.closeProtocolHandlers(holder, this.soapHandlers.size() - 1, 0);
                this.closeLogicalHandlers(holder, this.logicalHandlers.size() - 1, i);
            }
            throw re3;
        }
        return true;
    }

    private boolean callProtocolHandlers(ContextHolder holder, Direction direction, RequestOrResponse type, boolean responseExpected) {
        int i;
        if (direction == Direction.OUTBOUND) {
            int i2;
            try {
                for (i2 = 0; i2 < this.soapHandlers.size(); ++i2) {
                    if (this.soapHandlers.get(i2).handleMessage((MessageContext)holder.getSMC())) continue;
                    if (responseExpected) {
                        if (i2 > 0) {
                            this.callProtocolHandleMessage(holder, i2 - 1, 0);
                        }
                        this.callLogicalHandleMessage(holder, this.logicalHandlers.size() - 1, 0);
                    }
                    if (type == RequestOrResponse.RESPONSE) {
                        this.closeHandlers(holder);
                    } else {
                        this.closeProtocolHandlers(holder, i2, 0);
                        this.closeLogicalHandlers(holder, this.logicalHandlers.size() - 1, 0);
                    }
                    return false;
                }
            }
            catch (RuntimeException re2) {
                Throwable re2;
                logger.log(Level.FINER, "exception in handler chain", re2);
                if (responseExpected && re2 instanceof ProtocolException) {
                    this.insertFaultMessage(holder, (ProtocolException)((Object)re2));
                    try {
                        if (i2 == 0 || this.callProtocolHandleFault(holder, i2 - 1, 0)) {
                            this.callLogicalHandleFault(holder, this.logicalHandlers.size() - 1, 0);
                        }
                    }
                    catch (ProtocolException re1) {
                        this.addIgnoreFaultProperty(holder);
                        re2 = re1;
                    }
                    catch (RuntimeException re22) {
                        re2 = re22;
                    }
                }
                if (type == RequestOrResponse.RESPONSE) {
                    this.closeHandlers(holder);
                } else {
                    this.closeProtocolHandlers(holder, i2, 0);
                    this.closeLogicalHandlers(holder, this.logicalHandlers.size() - 1, 0);
                }
                throw re2;
            }
        }
        try {
            for (i = this.soapHandlers.size() - 1; i >= 0; --i) {
                if (this.soapHandlers.get(i).handleMessage((MessageContext)holder.getSMC())) continue;
                if (responseExpected && i != this.soapHandlers.size() - 1) {
                    this.callProtocolHandleMessage(holder, i + 1, this.soapHandlers.size() - 1);
                }
                if (type == RequestOrResponse.RESPONSE) {
                    this.closeHandlers(holder);
                } else {
                    this.closeProtocolHandlers(holder, this.soapHandlers.size() - 1, i);
                }
                return false;
            }
        }
        catch (RuntimeException re3) {
            Throwable re3;
            logger.log(Level.FINER, "exception in handler chain", re3);
            if (responseExpected && re3 instanceof ProtocolException) {
                this.insertFaultMessage(holder, (ProtocolException)((Object)re3));
                try {
                    if (i < this.soapHandlers.size() - 1) {
                        this.callProtocolHandleFault(holder, i + 1, this.soapHandlers.size() - 1);
                    }
                }
                catch (ProtocolException re1) {
                    this.addIgnoreFaultProperty(holder);
                    re3 = re1;
                }
                catch (RuntimeException re2) {
                    re3 = re2;
                }
            }
            if (type == RequestOrResponse.RESPONSE) {
                this.closeHandlers(holder);
            } else {
                this.closeProtocolHandlers(holder, this.soapHandlers.size() - 1, i);
            }
            throw re3;
        }
        return true;
    }

    private void callLogicalHandleMessage(ContextHolder holder, int start, int end) {
        if (this.logicalHandlers.isEmpty() || start == -1 || start == this.logicalHandlers.size()) {
            return;
        }
        if (start > end) {
            for (int i = start; i >= end; --i) {
                this.abstractHandle((Handler)this.logicalHandlers.get(i), (MessageContext)holder.getLMC());
            }
        } else {
            for (int i = start; i <= end; ++i) {
                this.abstractHandle((Handler)this.logicalHandlers.get(i), (MessageContext)holder.getLMC());
            }
        }
    }

    private void callProtocolHandleMessage(ContextHolder holder, int start, int end) {
        if (this.soapHandlers.isEmpty()) {
            return;
        }
        if (start > end) {
            for (int i = start; i >= end; --i) {
                this.abstractHandle((Handler)this.soapHandlers.get(i), (MessageContext)holder.getSMC());
            }
        } else {
            for (int i = start; i <= end; ++i) {
                this.abstractHandle((Handler)this.soapHandlers.get(i), (MessageContext)holder.getSMC());
            }
        }
    }

    private void abstractHandle(Handler h, MessageContext c) {
        try {
            h.handleMessage(c);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception ignored during handleMessage", e);
        }
    }

    private boolean callLogicalHandleFault(ContextHolder holder, int start, int end) {
        return this.callGenericHandleFault(this.logicalHandlers, (MessageContext)holder.getLMC(), start, end);
    }

    private boolean callProtocolHandleFault(ContextHolder holder, int start, int end) {
        return this.callGenericHandleFault(this.soapHandlers, (MessageContext)holder.getSMC(), start, end);
    }

    private boolean callGenericHandleFault(List<? extends Handler> handlerList, MessageContext context, int start, int end) {
        int i;
        if (handlerList.isEmpty()) {
            return true;
        }
        if (start > end) {
            try {
                for (i = start; i >= end; --i) {
                    if (handlerList.get(i).handleFault(context)) continue;
                    return false;
                }
            }
            catch (RuntimeException re) {
                logger.log(Level.FINER, "exception in handler chain", re);
                throw re;
            }
        }
        try {
            while (i <= end) {
                if (!handlerList.get(i).handleFault(context)) {
                    return false;
                }
                ++i;
            }
        }
        catch (RuntimeException re) {
            logger.log(Level.FINER, "exception in handler chain", re);
            throw re;
        }
        return true;
    }

    private void closeHandlers(ContextHolder holder) {
        this.closeProtocolHandlers(holder, this.soapHandlers.size() - 1, 0);
        this.closeLogicalHandlers(holder, this.logicalHandlers.size() - 1, 0);
    }

    public void forceCloseHandlers(SOAPHandlerContext context) {
        ContextHolder ch = new ContextHolder(context);
        ch.getSMC().put((Object)"javax.xml.ws.handler.message.outbound", (Object)false);
        ((SOAPMessageContextImpl)ch.getSMC()).setRoles(this.getRoles());
        this.closeHandlers(ch);
    }

    public void forceCloseHandlers(XMLHandlerContext context) {
        ContextHolder ch = new ContextHolder(context);
        ch.getLMC().put((Object)"javax.xml.ws.handler.message.outbound", (Object)false);
        this.closeHandlers(ch);
    }

    private void closeProtocolHandlers(ContextHolder holder, int start, int end) {
        this.closeGenericHandlers(this.soapHandlers, (MessageContext)holder.getSMC(), start, end);
    }

    private void closeLogicalHandlers(ContextHolder holder, int start, int end) {
        this.closeGenericHandlers(this.logicalHandlers, (MessageContext)holder.getLMC(), start, end);
    }

    private void closeGenericHandlers(List<? extends Handler> handlerList, MessageContext context, int start, int end) {
        if (handlerList.isEmpty()) {
            return;
        }
        if (start > end) {
            for (int i = start; i >= end; --i) {
                try {
                    handlerList.get(i).close(context);
                    continue;
                }
                catch (RuntimeException re) {
                    logger.log(Level.INFO, "Exception ignored during close", re);
                }
            }
        } else {
            for (int i = start; i <= end; ++i) {
                try {
                    handlerList.get(i).close(context);
                    continue;
                }
                catch (RuntimeException re) {
                    logger.log(Level.INFO, "Exception ignored during close", re);
                }
            }
        }
    }

    static class ContextHolder {
        boolean logicalOnly;
        SOAPHandlerContext context;
        XMLHandlerContext xmlContext;

        ContextHolder(SOAPHandlerContext context) {
            this.context = context;
            this.logicalOnly = false;
        }

        ContextHolder(XMLHandlerContext xmlContext) {
            this.xmlContext = xmlContext;
            this.logicalOnly = true;
        }

        LogicalMessageContext getLMC() {
            return this.logicalOnly ? this.xmlContext.getLogicalMessageContext() : this.context.getLogicalMessageContext();
        }

        SOAPMessageContext getSMC() {
            return this.logicalOnly ? null : this.context.getSOAPMessageContext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        OUTBOUND,
        INBOUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestOrResponse {
        REQUEST,
        RESPONSE;

    }
}

