/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap.message;

import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.message.FaultCodeEnum;
import com.sun.xml.ws.encoding.soap.message.FaultSubcode;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultCode {
    private FaultCodeEnum value;
    private FaultSubcode subcode;

    public FaultCode(FaultCodeEnum value, FaultSubcode subcode) {
        this.value = value;
        this.subcode = subcode;
    }

    public FaultCode(FaultCodeEnum value, Iterator<QName> subcodes) {
        this.value = value;
        if (subcodes.hasNext()) {
            this.subcode = new FaultSubcode(subcodes.next(), subcodes);
        }
    }

    public FaultCodeEnum getValue() {
        return this.value;
    }

    public FaultSubcode getSubcode() {
        return this.subcode;
    }

    void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_CODE.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
        writer.writeStartElement("soapenv", SOAP12Constants.QNAME_FAULT_VALUE.getLocalPart(), "http://www.w3.org/2003/05/soap-envelope");
        writer.writeCharacters(this.value.getPrefix() + ":" + this.value.getLocalPart());
        writer.writeEndElement();
        if (this.subcode != null) {
            this.subcode.write(writer);
        }
        writer.writeEndElement();
    }
}

