/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch.impl.encoding;

import com.sun.xml.ws.client.dispatch.impl.encoding.DispatchUtil;
import com.sun.xml.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.encoding.soap.SerializationException;
import com.sun.xml.ws.streaming.Attributes;
import com.sun.xml.ws.streaming.SourceReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public final class DispatchSerializer {
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch").toString());
    private final QName bodyTagName;
    public static final DispatchSerializer SOAP_1_0 = new DispatchSerializer(SOAPConstants.QNAME_SOAP_BODY);
    public static final DispatchSerializer SOAP_1_2 = new DispatchSerializer(SOAP12Constants.QNAME_SOAP_BODY);

    private DispatchSerializer(QName soapBodyTagName) {
        this.bodyTagName = soapBodyTagName;
    }

    public void serialize(Object obj, XMLStreamWriter writer, JAXBContext context) {
        if (obj instanceof Source) {
            this.serializeSource(obj, writer);
        } else if (obj instanceof JAXBBeanInfo) {
            ((JAXBBeanInfo)obj).writeTo(writer);
        } else {
            throw new WebServiceException("Unable to serialize object type " + obj.getClass().getName());
        }
    }

    private static String convertNull(String s) {
        return s != null ? s : "";
    }

    public Source deserializeSource(XMLStreamReader reader, DispatchUtil dispatchUtil) {
        ByteArrayBuffer baos = new ByteArrayBuffer();
        XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter(baos);
        dispatchUtil.populatePrefixes(writer);
        try {
            while (reader.hasNext()) {
                int state = reader.getEventType();
                switch (state) {
                    case 1: {
                        String uri = reader.getNamespaceURI();
                        String rprefix = reader.getPrefix();
                        String nlocal = reader.getLocalName();
                        this.setWriterPrefixes(rprefix, uri, writer);
                        String prefix = null;
                        String wprefix = writer.getNamespaceContext().getPrefix(uri);
                        if (wprefix != null && !"".equals(wprefix) && wprefix.length() > 0) {
                            prefix = wprefix;
                        } else if (rprefix != null && !"".equals(rprefix) && uri != null && !"null".equals(uri)) {
                            prefix = this.setWriterPrefixes(reader, uri, writer);
                        } else {
                            prefix = DispatchSerializer.convertNull(prefix);
                            uri = DispatchSerializer.convertNull(uri);
                        }
                        writer.writeStartElement(prefix, nlocal, uri);
                        writer.writeNamespace(prefix, uri);
                        Attributes atts = XMLStreamReaderUtil.getAttributes(reader);
                        writer.flush();
                        this.writeAttributes(atts, writer, prefix, uri);
                        break;
                    }
                    case 2: {
                        writer.writeEndElement();
                        break;
                    }
                    case 4: {
                        writer.writeCharacters(reader.getText());
                    }
                }
                state = XMLStreamReaderUtil.next(reader);
                if (reader.getEventType() != 2 || !reader.getName().equals(this.bodyTagName)) continue;
                break;
            }
            writer.flush();
            writer.close();
            reader.close();
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
        }
        return new StreamSource(baos.newInputStream());
    }

    private void writeAttributes(Attributes atts, XMLStreamWriter writer, String prefix, String uri) throws XMLStreamException {
        for (int i = 0; i < atts.getLength(); ++i) {
            String value = atts.getValue(i);
            String localName = atts.getName(i).getLocalPart();
            String aprefix = atts.getPrefix(i);
            String auri = atts.getURI(i);
            this.setWriterPrefix(localName, value, aprefix, writer);
            if (atts.isNamespaceDeclaration(i)) {
                this.writeAttrNamespace(aprefix, auri, writer, localName, prefix, uri, value);
                continue;
            }
            this.writeAttribute(atts, i, writer);
        }
    }

    private void setWriterPrefix(String localName, String value, String aprefix, XMLStreamWriter writer) throws XMLStreamException {
        if (localName.equals("xsi") && value.equals("http://www.w3.org/2001/XMLSchema-instance") && aprefix.equals("xmlns")) {
            writer.setPrefix(localName, value);
        }
    }

    private String setWriterPrefixes(XMLStreamReader reader, String nuri, XMLStreamWriter writer) {
        String prefix = reader.getNamespaceContext().getPrefix(nuri);
        if (prefix == null) {
            prefix = DispatchSerializer.convertNull(prefix);
        }
        if (prefix != null && prefix.length() > 0 && nuri != null && !prefix.equals("xmlns")) {
            try {
                writer.setPrefix(prefix, nuri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return prefix;
    }

    private void setWriterPrefixes(String npre, String nuri, XMLStreamWriter writer) throws XMLStreamException {
        if (npre != null && npre.length() > 0 && nuri.length() > 0 && nuri != null && (npre.equals("null") || nuri.equals("null"))) {
            writer.setPrefix(npre, nuri);
        }
    }

    private void writeAttrNamespace(String aprefix, String auri, XMLStreamWriter writer, String localName, String prefix, String nuri, String value) throws XMLStreamException {
        if (aprefix == null || !aprefix.equals("") || aprefix.equals("xmlns")) {
            String temp = aprefix;
            if (auri != null) {
                String wprefix = writer.getNamespaceContext().getPrefix(auri);
                if (aprefix.equals("xmlns") && !localName.equals("xsi")) {
                    aprefix = prefix;
                    auri = nuri;
                } else if (!wprefix.equals("xmlns")) {
                    aprefix = wprefix;
                }
                if (aprefix == null) {
                    DispatchSerializer.convertNull(aprefix);
                }
            }
            this.writeNamespace(aprefix, prefix, auri, nuri, writer);
            this.writeXSINamspece(localName, value, temp, writer, aprefix, auri);
        }
    }

    private void writeNamespace(String aprefix, String prefix, String auri, String nuri, XMLStreamWriter writer) throws XMLStreamException {
        if (!(aprefix.equals(prefix) && auri.equals(nuri) || aprefix.equals("xmlns"))) {
            writer.writeNamespace(aprefix, auri);
        }
    }

    private void writeXSINamspece(String localName, String value, String temp, XMLStreamWriter writer, String aprefix, String auri) throws XMLStreamException {
        if (localName.equals("xsi") && value.equals("http://www.w3.org/2001/XMLSchema-instance") && temp.equals("xmlns")) {
            writer.setPrefix(localName, value);
            writer.writeAttribute(aprefix, auri, localName, value);
        }
    }

    private void writeAttribute(Attributes atts, int i, XMLStreamWriter writer) throws XMLStreamException {
        if (atts.getURI(i) == null && atts.getPrefix(i) != null) {
            String ns = writer.getNamespaceContext().getNamespaceURI(atts.getURI(i));
            writer.writeAttribute(atts.getPrefix(i), ns, atts.getLocalName(i), atts.getValue(i));
        }
        writer.writeAttribute(atts.getPrefix(i), atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
    }

    void serializeSource(Object source, XMLStreamWriter writer) {
        try {
            int state;
            XMLStreamReader reader = SourceReaderFactory.createSourceReader((Source)source, true);
            block7: do {
                state = XMLStreamReaderUtil.next(reader);
                switch (state) {
                    case 1: {
                        QName elementName = reader.getName();
                        String localPart = elementName.getLocalPart();
                        String namespaceURI = elementName.getNamespaceURI();
                        String prefix = elementName.getPrefix();
                        writer.writeStartElement(prefix, localPart, namespaceURI);
                        Attributes atts = XMLStreamReaderUtil.getAttributes(reader);
                        writer.flush();
                        for (int i = 0; i < atts.getLength(); ++i) {
                            if (atts.isNamespaceDeclaration(i)) {
                                String value = atts.getValue(i);
                                String localName = atts.getName(i).getLocalPart();
                                writer.setPrefix(localName, value);
                                writer.writeNamespace(localName, value);
                                continue;
                            }
                            writer.writeAttribute(atts.getPrefix(i), atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                        }
                        continue block7;
                    }
                    case 2: {
                        writer.writeEndElement();
                        break;
                    }
                    case 4: {
                        writer.writeCharacters(reader.getText());
                    }
                }
            } while (state != 8);
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

