/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.codemodel.JJavaName;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.xjc.reader.xmlschema.ErrorReporter;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.visitor.XSTermVisitor;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;

public abstract class ParticleBinder {
    protected final BGMBuilder builder = Ring.get(BGMBuilder.class);

    protected ParticleBinder() {
        Ring.add(ParticleBinder.class, this);
    }

    public final void build(XSParticle p) {
        this.build(p, Collections.emptySet());
    }

    public abstract void build(XSParticle var1, Collection<XSParticle> var2);

    public abstract boolean checkFallback(XSParticle var1);

    protected final CClassInfo getCurrentBean() {
        return this.getClassSelector().getCurrentBean();
    }

    protected final BIProperty getLocalPropCustomization(XSParticle p) {
        return this.getLocalCustomization(p, BIProperty.class);
    }

    protected final <T extends BIDeclaration> T getLocalCustomization(XSParticle p, Class<T> type) {
        T cust = this.builder.getBindInfo(p).get(type);
        if (cust != null) {
            return cust;
        }
        cust = this.builder.getBindInfo(p.getTerm()).get(type);
        if (cust != null) {
            return cust;
        }
        return null;
    }

    protected final String computeLabel(XSParticle p) {
        BIProperty cust = this.getLocalPropCustomization(p);
        if (cust != null && cust.getPropertyName(false) != null) {
            return cust.getPropertyName(false);
        }
        XSTerm t = p.getTerm();
        if (t.isElementDecl()) {
            return this.makeJavaName(p, t.asElementDecl().getName());
        }
        if (t.isModelGroupDecl()) {
            return this.makeJavaName(p, t.asModelGroupDecl().getName());
        }
        if (t.isWildcard()) {
            return this.makeJavaName(p, "Any");
        }
        if (t.isModelGroup()) {
            try {
                return this.getSpecDefaultName(t.asModelGroup(), p.isRepeated());
            }
            catch (ParseException e) {
                this.getErrorReporter().error(t.getLocator(), "DefaultParticleBinder.UnableToGenerateNameFromModelGroup", new Object[0]);
                return "undefined";
            }
        }
        throw new AssertionError();
    }

    protected final String makeJavaName(boolean isRepeated, String xmlName) {
        String name = this.builder.getNameConverter().toPropertyName(xmlName);
        if (this.builder.getGlobalBinding().isSimpleMode() && isRepeated) {
            name = JJavaName.getPluralForm(name);
        }
        return name;
    }

    protected final String makeJavaName(XSParticle p, String xmlName) {
        return this.makeJavaName(p.isRepeated(), xmlName);
    }

    protected final String getSpecDefaultName(XSModelGroup mg, final boolean repeated) throws ParseException {
        final StringBuilder name = new StringBuilder();
        mg.visit(new XSTermVisitor(){
            private int count = 0;
            private boolean rep = repeated;

            @Override
            public void wildcard(XSWildcard wc) {
                this.append("any");
            }

            @Override
            public void modelGroupDecl(XSModelGroupDecl mgd) {
                this.modelGroup(mgd.getModelGroup());
            }

            @Override
            public void modelGroup(XSModelGroup mg) {
                String operator = mg.getCompositor() == XSModelGroup.CHOICE ? "Or" : "And";
                int size = mg.getSize();
                for (int i = 0; i < size; ++i) {
                    XSParticle p = mg.getChild(i);
                    boolean oldRep = this.rep;
                    this.rep |= p.isRepeated();
                    p.getTerm().visit(this);
                    this.rep = oldRep;
                    if (this.count == 3) {
                        return;
                    }
                    if (i == size - 1) continue;
                    name.append(operator);
                }
            }

            @Override
            public void elementDecl(XSElementDecl ed) {
                this.append(ed.getName());
            }

            private void append(String token) {
                if (this.count < 3) {
                    name.append(ParticleBinder.this.makeJavaName(this.rep, token));
                    ++this.count;
                }
            }
        });
        if (name.length() == 0) {
            throw new ParseException("no element", -1);
        }
        return name.toString();
    }

    protected final ErrorReporter getErrorReporter() {
        return Ring.get(ErrorReporter.class);
    }

    protected final ClassSelector getClassSelector() {
        return Ring.get(ClassSelector.class);
    }
}

