/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.frametypes;

import com.sun.grizzly.websockets.BaseFrameType;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.frametypes.BinaryFrameType;
import com.sun.grizzly.websockets.frametypes.TextFrameType;

public class ContinuationFrameType
extends BaseFrameType {
    private boolean text;
    private FrameType wrappedType;

    public ContinuationFrameType(boolean text) {
        this.text = text;
        this.wrappedType = text ? new TextFrameType() : new BinaryFrameType();
    }

    public void respond(WebSocket socket, DataFrame frame) {
        if (this.text) {
            socket.onFragment(frame.isLast(), frame.getTextPayload());
        } else {
            socket.onFragment(frame.isLast(), frame.getBytes());
        }
    }

    public void setPayload(DataFrame frame, byte[] data) {
        this.wrappedType.setPayload(frame, data);
    }

    public byte[] getBytes(DataFrame dataFrame) {
        return this.wrappedType.getBytes(dataFrame);
    }
}

