/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.draft76;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.frametypes.Utf8DecodingError;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Draft76FrameType implements FrameType
{
    TEXT{

        public void setPayload(DataFrame frame, byte[] data) {
            try {
                frame.setPayload(new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Utf8DecodingError(e.getMessage(), e);
            }
        }

        public byte[] getBytes(DataFrame frame) {
            byte[] data = frame.getBytes();
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 2);
            out.write(0);
            out.write(data, 0, data.length);
            out.write(-1);
            return out.toByteArray();
        }

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onMessage(frame.getTextPayload());
        }
    }
    ,
    CLOSING{

        public void setPayload(DataFrame frame, byte[] data) {
            frame.setPayload(data);
        }

        public byte[] getBytes(DataFrame frame) {
            return new byte[]{-1, 0};
        }

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onClose(frame);
            socket.close();
        }
    };


    @Override
    public DataFrame create(boolean fin, byte[] data) {
        return new DataFrame((FrameType)this, data);
    }
}

