/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.draft06;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.HandShake;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.draft06.SecKey;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandShake06
extends HandShake {
    private final SecKey secKey;
    private List<String> enabledExtensions;
    private List<String> enabledProtocols;

    public HandShake06(URL url) {
        super(url);
        this.secKey = new SecKey();
    }

    public HandShake06(Request request) {
        super(request);
        MimeHeaders mimeHeaders = request.getMimeHeaders();
        this.setExtensions(this.split(mimeHeaders.getHeader("Sec-WebSocket-Extensions")));
        this.secKey = SecKey.generateServerKey(new SecKey(mimeHeaders.getHeader("Sec-WebSocket-Key")));
    }

    @Override
    public void setHeaders(Response response) {
        response.setMessage("Switching Protocols");
        response.setHeader("Sec-WebSocket-Accept", this.secKey.getSecKey());
        if (this.getEnabledExtensions() != null) {
            response.setHeader("Sec-WebSocket-Extensions", this.join(this.getSubProtocol()));
        }
    }

    @Override
    public void initiate(NetworkHandler handler) {
        super.initiate(handler);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s: %s\r\n", "Sec-WebSocket-Key", this.secKey));
        builder.append(String.format("%s: %s\r\n", "Sec-WebSocket-Origin", this.getOrigin()));
        builder.append(String.format("%s: %s\r\n", "Sec-WebSocket-Version", this.getVersion()));
        if (!this.getExtensions().isEmpty()) {
            builder.append(String.format("%s: %s\r\n", "Sec-WebSocket-Extensions", this.join(this.getExtensions())));
        }
        builder.append("\r\n");
        handler.write(builder.toString().getBytes());
    }

    protected int getVersion() {
        return 6;
    }

    @Override
    public void validateServerResponse(Map<String, String> headers) throws HandshakeException {
        super.validateServerResponse(headers);
        this.secKey.validateServerKey(headers.get("Sec-WebSocket-Accept"));
    }

    public List<String> getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }
}

