/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocketEngine;
import com.sun.grizzly.websockets.WebSocketException;
import com.sun.grizzly.websockets.draft76.Draft76Handler;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

public class WebSocketSelectionKeyAttachment
extends SelectedKeyAttachmentLogic
implements Runnable {
    private final ProtocolHandler handler;
    private final ServerNetworkHandler networkHandler;
    private final ProcessorTask processorTask;
    private final AsyncProcessorTask asyncProcessorTask;
    private SelectionKey key;

    public WebSocketSelectionKeyAttachment(ProtocolHandler snh, ServerNetworkHandler nh, ProcessorTask task, AsyncProcessorTask asyncTask) {
        this.handler = snh;
        this.networkHandler = nh;
        this.processorTask = task;
        this.asyncProcessorTask = asyncTask;
    }

    public boolean timedOut(SelectionKey key) {
        return false;
    }

    public AsyncProcessorTask getAsyncProcessorTask() {
        return this.asyncProcessorTask;
    }

    public boolean handleSelectedKey(SelectionKey key) {
        if (key.isReadable()) {
            this.key = key;
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
            this.asyncProcessorTask.getThreadPool().execute(this);
        }
        return false;
    }

    public void run() {
        try {
            this.networkHandler.read();
            this.handler.readFrame();
            this.enableRead();
        }
        catch (WebSocketException e) {
            if (this.handler.maskData || this.handler instanceof Draft76Handler) {
                this.handler.getWebSocket().onClose(null);
            } else {
                try {
                    this.handler.close(1011, e.getMessage());
                }
                catch (Exception ee) {
                    this.handler.getWebSocket().onClose(null);
                }
            }
            this.networkHandler.close();
            WebSocketEngine.logger.log(Level.FINEST, e.getMessage(), e);
        }
    }

    public final void enableRead() {
        this.processorTask.getSelectorHandler().register(this.getSelectionKey(), 1);
    }

    public SelectionKey getSelectionKey() {
        return this.asyncProcessorTask.getAsyncExecutor().getProcessorTask().getSelectionKey();
    }

    public ProtocolHandler getHandler() {
        return this.handler;
    }
}

