/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketAdapter;
import com.sun.grizzly.websockets.WebSocketListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSocketApplication
extends WebSocketAdapter {
    private final ConcurrentHashMap<WebSocket, Boolean> sockets = new ConcurrentHashMap();

    public WebSocket createWebSocket(ProtocolHandler protocolHandler, WebSocketListener ... listeners) {
        return new DefaultWebSocket(protocolHandler, listeners);
    }

    protected Set<WebSocket> getWebSockets() {
        return this.sockets.keySet();
    }

    protected boolean add(WebSocket socket) {
        return this.sockets.put(socket, Boolean.TRUE) == null;
    }

    public boolean remove(WebSocket socket) {
        return this.sockets.remove(socket) != null;
    }

    @Override
    public void onClose(WebSocket socket, DataFrame frame) {
        this.remove(socket);
        socket.close();
    }

    @Override
    public void onConnect(WebSocket socket) {
        this.add(socket);
    }

    public abstract boolean isApplicationRequest(Request var1);

    public List<String> getSupportedExtensions() {
        return Collections.emptyList();
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        return Collections.emptyList();
    }

    void shutdown() {
        for (WebSocket webSocket : this.sockets.keySet()) {
            if (!webSocket.isConnected()) continue;
            webSocket.onClose(null);
        }
        this.sockets.clear();
    }
}

