/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import com.sun.grizzly.websockets.frametypes.PingFrameType;
import com.sun.grizzly.websockets.frametypes.PongFrameType;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebSocket
implements WebSocket {
    private final Collection<WebSocketListener> listeners = new ConcurrentLinkedQueue<WebSocketListener>();
    protected final ProtocolHandler protocolHandler;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);

    public DefaultWebSocket(ProtocolHandler protocolHandler, WebSocketListener ... listeners) {
        this.protocolHandler = protocolHandler;
        NetworkHandler handler = protocolHandler.getNetworkHandler();
        if (handler instanceof ServerNetworkHandler) {
            ServerNetworkHandler networkHandler = (ServerNetworkHandler)handler;
            try {
                this.request = networkHandler.getRequest();
                this.response = networkHandler.getResponse();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
        protocolHandler.setWebSocket(this);
    }

    public NetworkHandler getNetworkHandler() {
        return this.protocolHandler.getNetworkHandler();
    }

    public void setNetworkHandler(NetworkHandler handler) {
        this.protocolHandler.setNetworkHandler(handler);
    }

    public Collection<WebSocketListener> getListeners() {
        return this.listeners;
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    @Override
    public void setClosed() {
        this.state.set(State.CLOSED);
    }

    @Override
    public void onClose(DataFrame frame) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING) || this.state.get() == State.CLOSING) {
            if (frame != null) {
                this.protocolHandler.close(frame);
            }
            Iterator<WebSocketListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                WebSocketListener listener = it.next();
                it.remove();
                listener.onClose(this, frame);
            }
            this.state.set(State.CLOSED);
        }
    }

    @Override
    public void onConnect() {
        this.state.set(State.CONNECTED);
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
    }

    @Override
    public void onFragment(boolean last, byte[] fragment) {
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onFragment(boolean last, String fragment) {
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment((WebSocket)this, fragment, last);
        }
    }

    @Override
    public void onMessage(byte[] data) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, data);
        }
    }

    @Override
    public void onMessage(String text) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, text);
        }
    }

    @Override
    public void onPing(DataFrame frame) {
        this.send(new DataFrame((FrameType)new PongFrameType(), frame.getBytes()));
        for (WebSocketListener listener : this.listeners) {
            listener.onPing(this, frame.getBytes());
        }
    }

    @Override
    public void onPong(DataFrame frame) {
        for (WebSocketListener listener : this.listeners) {
            listener.onPong(this, frame.getBytes());
        }
    }

    @Override
    public void close() {
        this.close(-1, null);
    }

    @Override
    public void close(int code) {
        this.close(code, null);
    }

    @Override
    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(code, reason);
        }
    }

    @Override
    public void send(byte[] data) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.protocolHandler.send(data);
    }

    @Override
    public void send(String data) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.protocolHandler.send(data);
    }

    @Override
    public void sendPing(byte[] data) {
        this.send(new DataFrame((FrameType)new PingFrameType(), data));
    }

    @Override
    public void sendPong(byte[] data) {
        this.send(new DataFrame((FrameType)new PongFrameType(), data));
    }

    private void send(DataFrame frame) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.protocolHandler.send(frame);
    }

    @Override
    public void stream(boolean last, String fragment) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.protocolHandler.stream(last, fragment);
    }

    @Override
    public void stream(boolean last, byte[] bytes, int off, int len) {
        if (this.state.get() != State.CONNECTED) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.protocolHandler.stream(last, bytes, off, len);
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

