/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase00clean;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN, requiresOnline=true)
public class NdkCleanMojo
extends AbstractMojo {
    @Parameter(property="android.nativeBuildLibsOutputDirectory", defaultValue="${project.basedir}/libs")
    File ndkBuildLibsOutputDirectory;
    @Parameter(property="android.nativeBuildObjOutputDirectory", defaultValue="${project.basedir}/obj")
    File ndkBuildObjOutputDirectory;
    @Parameter(property="android.nativeBuildSkipClean", defaultValue="false")
    boolean skipClean = false;
    @Parameter(property="android.nativeBuildSkipCleanLibsOutputDirectory", defaultValue="true")
    boolean skipBuildLibsOutputDirectory = true;
    @Parameter(property="android.nativeBuildSkipCleanLibsOutputDirectory", defaultValue="false")
    boolean skipBuildObjsOutputDirectory = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.ndkBuildLibsOutputDirectory.exists() && !this.skipBuildLibsOutputDirectory) {
            this.getLog().debug((CharSequence)("Cleaning out native library code directory : " + this.ndkBuildLibsOutputDirectory.getAbsolutePath()));
            try {
                FileUtils.deleteDirectory((File)this.ndkBuildLibsOutputDirectory);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error deleting directory: " + e.getMessage()), (Throwable)e);
            }
        }
        if (this.ndkBuildObjOutputDirectory.exists() && !this.skipBuildObjsOutputDirectory) {
            this.getLog().debug((CharSequence)("Cleaning out native object code directory: " + this.ndkBuildObjOutputDirectory.getAbsolutePath()));
            try {
                FileUtils.deleteDirectory((File)this.ndkBuildObjOutputDirectory);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error deleting directory: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

