/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.common;

import com.simpligility.maven.plugins.android.common.DependencyCollector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.logging.Logger;

public final class DependencyResolver {
    private final Logger log;
    private final DependencyGraphBuilder dependencyGraphBuilder;

    public DependencyResolver(Logger log, DependencyGraphBuilder dependencyGraphBuilder) {
        this.log = log;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
    }

    public Set<Artifact> getProjectDependenciesFor(MavenProject project, MavenSession session) throws DependencyGraphBuilderException {
        DependencyNode node = this.dependencyGraphBuilder.buildDependencyGraph(project, null, (Collection)session.getProjects());
        DependencyCollector collector = new DependencyCollector(this.log, project.getArtifact());
        collector.visit(node, false);
        return collector.getDependencies();
    }

    public Set<Artifact> getLibraryDependenciesFor(MavenSession session, RepositorySystem repositorySystem, Artifact artifact) throws MojoExecutionException {
        ArtifactFilter filter = new ArtifactFilter(){

            public boolean include(Artifact found) {
                String type = found.getType();
                return type.equals("apklib") || type.equals("aar") || type.equals("apk");
            }
        };
        this.log.debug("MavenSession = " + session + "  repositorySystem = " + repositorySystem);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveRoot(false);
        request.setResolveTransitively(true);
        request.setServers(session.getRequest().getServers());
        request.setMirrors(session.getRequest().getMirrors());
        request.setProxies(session.getRequest().getProxies());
        request.setLocalRepository(session.getLocalRepository());
        request.setRemoteRepositories(session.getCurrentProject().getRemoteArtifactRepositories());
        ArtifactResolutionResult result = repositorySystem.resolve(request);
        HashSet<Artifact> libraryDeps = new HashSet<Artifact>();
        for (Artifact depArtifact : result.getArtifacts()) {
            if (!filter.include(depArtifact)) continue;
            libraryDeps.add(depArtifact);
        }
        return libraryDeps;
    }
}

