/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonkeyTestRunner {
    private IDevice mRemoteDevice;
    private int mMaxTimeToOutputResponse = 0;
    private String mRunName = null;
    private List<Map.Entry<String, String>> mArgList;
    private MonkeyResultParser mParser;
    private final int eventCount;
    private boolean ignoreCrashes;
    private boolean debugNoEvents;
    private boolean hprof;
    private boolean ignoreTimeouts;
    private boolean ignoreSecurityExceptions;
    private boolean killProcessAfterError;
    private boolean monitorNativeCrashes;
    private static final String LOG_TAG = "RemoteAndroidTest";
    private static final String SEED_ARG_NAME = "-s";
    private static final String THROTTLE_ARG_NAME = "--throttle";
    private static final String PERCENT_TOUCH_ARG_NAME = "--pct-touch";
    private static final String PERCENT_MOTION_ARG_NAME = "--pct-motion";
    private static final String PERCENT_TRACKBALL_ARG_NAME = "--pct-trackball";
    private static final String PERCENT_NAV_ARG_NAME = "--pct-nav";
    private static final String PERCENT_MAJORNAV_ARG_NAME = "--pct-majornav";
    private static final String PERCENT_SYSKEYS_ARG_NAME = "--pct-syskeys";
    private static final String PERCENT_APPSWITCH_ARG_NAME = "--pct-appswitch";
    private static final String PERCENT_ANYEVENT_ARG_NAME = "--pct-anyevent";
    private static final String PACKAGE_ARG_NAME = "-p";
    private static final String CATEGORY_ARG_NAME = "-c";

    public MonkeyTestRunner(int eventCount, IDevice remoteDevice) {
        this.eventCount = eventCount;
        this.mRemoteDevice = remoteDevice;
        this.mArgList = new ArrayList<Map.Entry<String, String>>();
    }

    public void addArg(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name or value arguments cannot be null");
        }
        this.mArgList.add(new AbstractMap.SimpleImmutableEntry<String, String>(name, value));
    }

    public void addBooleanArg(String name, boolean value) {
        this.addArg(name, Boolean.toString(value));
    }

    public void addLongArg(String name, long value) {
        this.addArg(name, Long.toString(value));
    }

    public void setSeed(long seed) {
        this.addLongArg(SEED_ARG_NAME, seed);
    }

    public void setThrottle(long throttle) {
        this.addLongArg(THROTTLE_ARG_NAME, throttle);
    }

    public void setPercentTouch(long percent) {
        this.addLongArg(PERCENT_TOUCH_ARG_NAME, percent);
    }

    public void setPercentMotion(long percent) {
        this.addLongArg(PERCENT_MOTION_ARG_NAME, percent);
    }

    public void setPercentTrackball(long percent) {
        this.addLongArg(PERCENT_TRACKBALL_ARG_NAME, percent);
    }

    public void setPercentNav(long percent) {
        this.addLongArg(PERCENT_NAV_ARG_NAME, percent);
    }

    public void setPercentMajorNav(long percent) {
        this.addLongArg(PERCENT_MAJORNAV_ARG_NAME, percent);
    }

    public void setPercentSyskeys(long percent) {
        this.addLongArg(PERCENT_SYSKEYS_ARG_NAME, percent);
    }

    public void setPercentAppswitch(long percent) {
        this.addLongArg(PERCENT_APPSWITCH_ARG_NAME, percent);
    }

    public void setPercentAnyEvent(int percent) {
        this.addLongArg(PERCENT_ANYEVENT_ARG_NAME, percent);
    }

    public void setPackages(String[] packages) {
        for (String packageName : packages) {
            this.addArg(PACKAGE_ARG_NAME, packageName);
        }
    }

    public void setCategories(String[] categories) {
        for (String category : categories) {
            this.addArg(CATEGORY_ARG_NAME, category);
        }
    }

    public void setDebugNoEvents(boolean debugNoEvents) {
        this.debugNoEvents = debugNoEvents;
    }

    public void setHprof(boolean hprof) {
        this.hprof = hprof;
    }

    public void setIgnoreCrashes(boolean ignoreCrashes) {
        this.ignoreCrashes = ignoreCrashes;
    }

    public void setIgnoreTimeouts(boolean ignoreTimeouts) {
        this.ignoreTimeouts = ignoreTimeouts;
    }

    public void setIgnoreSecurityExceptions(boolean ignoreSecurityExceptions) {
        this.ignoreSecurityExceptions = ignoreSecurityExceptions;
    }

    public void setKillProcessAfterError(boolean killProcessAfterError) {
        this.killProcessAfterError = killProcessAfterError;
    }

    public void setMonitorNativeCrash(boolean monitorNativeCrashes) {
        this.monitorNativeCrashes = monitorNativeCrashes;
    }

    public void setMaxtimeToOutputResponse(int maxTimeToOutputResponse) {
        this.mMaxTimeToOutputResponse = maxTimeToOutputResponse;
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    public void run(ITestRunListener ... listeners) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.run(Arrays.asList(listeners));
    }

    public void run(Collection<ITestRunListener> listeners) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String runCaseCommandStr = String.format("monkey -v -v -v %1$s %2$s", this.buildArgsCommand(), Long.toString(this.eventCount));
        Log.i((String)LOG_TAG, (String)String.format("Running %1$s on %2$s", runCaseCommandStr, this.mRemoteDevice.getSerialNumber()));
        this.mParser = new MonkeyResultParser(this.mRunName, listeners);
        try {
            this.mRemoteDevice.executeShellCommand(runCaseCommandStr, (IShellOutputReceiver)this.mParser, this.mMaxTimeToOutputResponse);
        }
        catch (IOException e) {
            Log.w((String)LOG_TAG, (String)String.format("IOException %1$s when running monkey tests on %3$s", e.toString(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.w((String)LOG_TAG, (String)String.format("ShellCommandUnresponsiveException %1$s when running monkey tests on %3$s", e.toString(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(String.format("Failed to receive adb shell test output within %1$d ms. Test may have timed out, or adb connection to device became unresponsive", this.mMaxTimeToOutputResponse));
            throw e;
        }
        catch (TimeoutException e) {
            Log.w((String)LOG_TAG, (String)String.format("TimeoutException when running monkey tests on %2$s", this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
        catch (AdbCommandRejectedException e) {
            Log.w((String)LOG_TAG, (String)String.format("AdbCommandRejectedException %1$s when running monkey tests %2$s on %3$s", e.toString(), this.mRemoteDevice.getSerialNumber()));
            this.mParser.handleTestRunFailed(e.toString());
            throw e;
        }
    }

    public void cancel() {
        if (this.mParser != null) {
            this.mParser.cancel();
        }
    }

    private String buildArgsCommand() {
        StringBuilder commandBuilder = new StringBuilder();
        for (Map.Entry<String, String> argPair : this.mArgList) {
            String argCmd = String.format(" %1$s %2$s", argPair.getKey(), argPair.getValue());
            commandBuilder.append(argCmd);
        }
        if (this.debugNoEvents) {
            commandBuilder.append(" --dbg-no-events");
        }
        if (this.hprof) {
            commandBuilder.append(" --hprof");
        }
        if (this.ignoreCrashes) {
            commandBuilder.append(" --ignore-crashes");
        }
        if (this.ignoreTimeouts) {
            commandBuilder.append(" --ignore-timeouts");
        }
        if (this.ignoreSecurityExceptions) {
            commandBuilder.append(" --ignore-security-exceptions");
        }
        if (this.killProcessAfterError) {
            commandBuilder.append(" --kill-process-after-error");
        }
        if (this.monitorNativeCrashes) {
            commandBuilder.append(" --monitor-native-crashes");
        }
        return commandBuilder.toString();
    }

    private class MonkeyResultParser
    extends MultiLineReceiver {
        private static final String CRASH_KEY = "// CRASH:";
        private static final String SHORT_MESSAGE_KEY = "// Short Msg:";
        private static final String LONG_MESSAGE_KEY = "// Long Msg:";
        private static final String BUILD_LABEL_KEY = "// Build Label:";
        private static final String BUILD_CHANGELIST_KEY = "// Build Changelist:";
        private static final String BUILD_TIME_KEY = "// Build Time:";
        private static final String EMPTY_KEY = "//";
        private static final String SENDING_KEY = ":Sending";
        private static final String SWITCHING_KEY = ":Switch";
        private static final String MONKEY_KEY = ":Monkey:";
        private final Collection<ITestRunListener> mTestListeners;
        private String runName;
        private boolean canceled;
        private TestIdentifier mCurrentTestIndentifier;
        private long elapsedTime;
        private HashMap<String, String> runMetrics = new HashMap();

        private MonkeyResultParser(String runName, Collection<ITestRunListener> listeners) {
            this.runName = runName;
            this.mTestListeners = new ArrayList<ITestRunListener>(listeners);
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isCancelled() {
            return this.canceled;
        }

        public void done() {
            this.handleTestEnd();
            this.handleTestRunEnded();
            super.done();
        }

        public void processNewLines(String[] lines) {
            for (int indexLine = 0; indexLine < lines.length; ++indexLine) {
                String line = lines[indexLine];
                Log.v((String)("monkey receiver:" + this.runName), (String)line);
                if (line.startsWith(MONKEY_KEY)) {
                    this.handleTestRunStarted();
                }
                if (line.startsWith(SHORT_MESSAGE_KEY)) {
                    this.runMetrics.put("ShortMsg", line.substring(SHORT_MESSAGE_KEY.length() - 1));
                }
                if (line.startsWith(LONG_MESSAGE_KEY)) {
                    this.runMetrics.put("LongMsg", line.substring(LONG_MESSAGE_KEY.length() - 1));
                }
                if (line.startsWith(BUILD_LABEL_KEY)) {
                    this.runMetrics.put("BuildLabel", line.substring(BUILD_LABEL_KEY.length() - 1));
                }
                if (line.startsWith(BUILD_CHANGELIST_KEY)) {
                    this.runMetrics.put("BuildChangeList", line.substring(BUILD_CHANGELIST_KEY.length() - 1));
                }
                if (line.startsWith(BUILD_TIME_KEY)) {
                    this.runMetrics.put("BuildTime", line.substring(BUILD_TIME_KEY.length() - 1));
                }
                if (line.startsWith(SENDING_KEY) || line.startsWith(SWITCHING_KEY)) {
                    this.handleTestEnd();
                    this.handleTestStarted(line);
                }
                if (!line.startsWith(CRASH_KEY)) continue;
                Log.d((String)"monkey received crash:", (String)line);
                indexLine = this.handleCrash(lines, indexLine);
                this.handleTestEnd();
            }
        }

        private void handleTestRunStarted() {
            this.elapsedTime = System.currentTimeMillis();
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testRunStarted(MonkeyTestRunner.this.mRunName, MonkeyTestRunner.this.eventCount);
            }
        }

        public void handleTestRunFailed(String error) {
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testRunFailed(error);
            }
        }

        private void handleTestRunEnded() {
            this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testRunEnded(this.elapsedTime, this.runMetrics);
            }
        }

        private void handleTestStarted(String line) {
            this.mCurrentTestIndentifier = new TestIdentifier("MonkeyTest", line);
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testStarted(this.mCurrentTestIndentifier);
            }
        }

        private void handleTestEnd() {
            if (this.mCurrentTestIndentifier != null) {
                for (ITestRunListener listener : this.mTestListeners) {
                    listener.testEnded(this.mCurrentTestIndentifier, new HashMap());
                }
                this.mCurrentTestIndentifier = null;
            }
        }

        private int handleCrash(String[] lines, int indexLine) {
            StringBuilder errorBuilder = new StringBuilder();
            boolean errorEnd = false;
            boolean errorStart = false;
            do {
                String line;
                if ((line = lines[indexLine]).startsWith(BUILD_TIME_KEY)) {
                    errorStart = true;
                }
                ++indexLine;
            } while (!errorStart);
            int firstLine = indexLine;
            do {
                String line;
                if ((line = lines[indexLine]).equals(EMPTY_KEY)) {
                    errorEnd = true;
                } else {
                    String stackTraceLine = lines[indexLine];
                    stackTraceLine = stackTraceLine.substring(indexLine == firstLine ? 3 : 4);
                    errorBuilder.append(stackTraceLine).append("\n");
                }
                ++indexLine;
            } while (!errorEnd);
            String trace = errorBuilder.toString();
            for (ITestRunListener listener : this.mTestListeners) {
                listener.testFailed(this.mCurrentTestIndentifier, trace);
            }
            this.mCurrentTestIndentifier = null;
            return indexLine;
        }
    }
}

