/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.common.ArtifactResolverHelper;
import com.jayway.maven.plugins.android.common.JarHelper;
import com.jayway.maven.plugins.android.common.NativeHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class MakefileHelper {
    public static final String MAKEFILE_CAPTURE_FILE = "ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE";
    private final Log log;
    private final ArtifactResolverHelper artifactResolverHelper;
    private final ArtifactHandler harArtifactHandler;
    private final File unpackedApkLibsDirectory;

    public MakefileHelper(Log log, ArtifactResolverHelper artifactResolverHelper, ArtifactHandler harHandler, File unpackedApkLibsDirectory) {
        this.log = log;
        this.artifactResolverHelper = artifactResolverHelper;
        this.harArtifactHandler = harHandler;
        this.unpackedApkLibsDirectory = unpackedApkLibsDirectory;
    }

    public static void cleanupAfterBuild(MakefileHolder makefileHolder) {
        if (makefileHolder.getIncludeDirectories() != null) {
            for (File file : makefileHolder.getIncludeDirectories()) {
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public MakefileHolder createMakefileFromArtifacts(Set<Artifact> artifacts, String ndkArchitecture, String defaultNDKArchitecture, boolean useHeaderArchives) throws IOException, MojoExecutionException {
        StringBuilder makeFile = new StringBuilder("# Generated by Android Maven Plugin\n");
        ArrayList<File> includeDirectories = new ArrayList<File>();
        makeFile.append("$(shell echo \"LOCAL_C_INCLUDES=$(LOCAL_C_INCLUDES)\" > $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_PATH=$(LOCAL_PATH)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_MODULE_FILENAME=$(LOCAL_MODULE_FILENAME)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_MODULE=$(LOCAL_MODULE)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_CFLAGS=$(LOCAL_CFLAGS)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        if (!artifacts.isEmpty()) {
            for (Artifact artifact : artifacts) {
                String architecture = NativeHelper.extractArchitectureFromArtifact(artifact, defaultNDKArchitecture);
                makeFile.append('\n');
                makeFile.append("ifeq ($(TARGET_ARCH_ABI),").append(architecture).append(")\n");
                makeFile.append("#\n");
                makeFile.append("# Group ID: ");
                makeFile.append(artifact.getGroupId());
                makeFile.append('\n');
                makeFile.append("# Artifact ID: ");
                makeFile.append(artifact.getArtifactId());
                makeFile.append('\n');
                makeFile.append("# Artifact Type: ");
                makeFile.append(artifact.getType());
                makeFile.append('\n');
                makeFile.append("# Version: ");
                makeFile.append(artifact.getVersion());
                makeFile.append('\n');
                makeFile.append("include $(CLEAR_VARS)");
                makeFile.append('\n');
                makeFile.append("LOCAL_MODULE    := ");
                makeFile.append(artifact.getArtifactId());
                makeFile.append('\n');
                boolean apklibStatic = this.addLibraryDetails(makeFile, artifact, ndkArchitecture);
                if (useHeaderArchives) {
                    try {
                        String classifier = artifact.getClassifier();
                        if ("apklib".equals(artifact.getType())) {
                            classifier = ndkArchitecture;
                            if (artifact.getClassifier() != null) {
                                classifier = classifier + "-" + artifact.getClassifier();
                            }
                        }
                        DefaultArtifact harArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), "har", classifier, this.harArtifactHandler);
                        File resolvedHarArtifactFile = this.artifactResolverHelper.resolveArtifactToFile((Artifact)harArtifact);
                        this.log.debug((CharSequence)("Resolved har artifact file : " + resolvedHarArtifactFile));
                        File includeDir = new File(System.getProperty("java.io.tmpdir"), "android_maven_plugin_native_includes" + System.currentTimeMillis() + "_" + harArtifact.getArtifactId());
                        includeDir.deleteOnExit();
                        includeDirectories.add(includeDir);
                        JarHelper.unjar(new JarFile(resolvedHarArtifactFile), includeDir, new JarHelper.UnjarListener(){

                            @Override
                            public boolean include(JarEntry jarEntry) {
                                return !jarEntry.getName().startsWith("META-INF");
                            }
                        });
                        makeFile.append("LOCAL_EXPORT_C_INCLUDES := ");
                        makeFile.append(includeDir.getAbsolutePath());
                        makeFile.append('\n');
                        if (this.log.isDebugEnabled()) {
                            Collection includes = FileUtils.listFiles((File)includeDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                            this.log.debug((CharSequence)("Listing LOCAL_EXPORT_C_INCLUDES for " + artifact.getId() + ": " + includes));
                        }
                    }
                    catch (RuntimeException e) {
                        throw new MojoExecutionException("Error while resolving header archive file for: " + artifact.getArtifactId(), (Exception)e);
                    }
                }
                if ("a".equals(artifact.getType()) || apklibStatic) {
                    makeFile.append("include $(PREBUILT_STATIC_LIBRARY)\n");
                } else {
                    makeFile.append("include $(PREBUILT_SHARED_LIBRARY)\n");
                }
                makeFile.append("endif #").append(artifact.getClassifier()).append('\n');
                makeFile.append('\n');
            }
        }
        return new MakefileHolder(includeDirectories, makeFile.toString());
    }

    private boolean addLibraryDetails(StringBuilder makeFile, Artifact artifact, String ndkArchitecture) throws IOException {
        boolean apklibStatic = false;
        if ("apklib".equals(artifact.getType())) {
            String classifier = artifact.getClassifier();
            String architecture = classifier != null ? classifier : ndkArchitecture;
            File[] staticLibs = NativeHelper.listNativeFiles(artifact, this.unpackedApkLibsDirectory, architecture, true);
            if (staticLibs != null && staticLibs.length > 0) {
                int libIdx = this.findApklibNativeLibrary(staticLibs, artifact.getArtifactId());
                apklibStatic = true;
                this.addLibraryDetails(makeFile, staticLibs[libIdx], "");
            } else {
                File[] sharedLibs = NativeHelper.listNativeFiles(artifact, this.unpackedApkLibsDirectory, architecture, false);
                if (sharedLibs == null) {
                    throw new IOException("Failed to find any library file in APKLIB");
                }
                int libIdx = this.findApklibNativeLibrary(sharedLibs, artifact.getArtifactId());
                this.addLibraryDetails(makeFile, sharedLibs[libIdx], "");
            }
        } else {
            this.addLibraryDetails(makeFile, artifact.getFile(), artifact.getArtifactId());
        }
        return apklibStatic;
    }

    private void addLibraryDetails(StringBuilder makeFile, File libFile, String outputName) throws IOException {
        makeFile.append("LOCAL_PATH := ");
        makeFile.append(libFile.getParentFile().getAbsolutePath());
        makeFile.append('\n');
        makeFile.append("LOCAL_SRC_FILES := ");
        makeFile.append(libFile.getName());
        makeFile.append('\n');
        makeFile.append("LOCAL_MODULE_FILENAME := ");
        if ("".equals(outputName)) {
            makeFile.append(FilenameUtils.removeExtension((String)libFile.getName()));
        } else {
            makeFile.append(outputName);
        }
        makeFile.append('\n');
    }

    private int findApklibNativeLibrary(File[] libs, String artifactName) throws IOException {
        int libIdx = -1;
        if (libs.length == 1) {
            libIdx = 0;
        } else {
            this.log.info((CharSequence)"Found multiple library files, looking for name match with artifact");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < libs.length; ++i) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(libs[i].getName());
                if (!libs[i].getName().startsWith("lib" + artifactName)) continue;
                if (libIdx != -1) {
                    throw new IOException("Found multiple libraries matching artifact name " + artifactName + ". Please use unique artifact/library names.");
                }
                libIdx = i;
            }
            if (libIdx < 0) {
                throw new IOException("Unable to determine main library from " + sb.toString() + " APKLIB should contain only 1 library or a library matching the artifact name");
            }
        }
        return libIdx;
    }

    public String createLibraryList(Set<Artifact> resolvedLibraryList, String ndkArchitecture, boolean staticLibrary) {
        LinkedHashSet<String> libraryNames = new LinkedHashSet<String>();
        for (Artifact a : resolvedLibraryList) {
            File[] libFiles;
            if (staticLibrary && "a".equals(a.getType())) {
                libraryNames.add(a.getArtifactId());
            }
            if (!staticLibrary && "so".equals(a.getType())) {
                libraryNames.add(a.getArtifactId());
            }
            if (!"apklib".equals(a.getType()) && !"aar".equals(a.getType()) || (libFiles = NativeHelper.listNativeFiles(a, this.unpackedApkLibsDirectory, ndkArchitecture, staticLibrary)) == null || libFiles.length <= 0) continue;
            libraryNames.add(a.getArtifactId());
        }
        StringBuilder sb = new StringBuilder();
        Iterator iter = libraryNames.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static class MakefileHolder {
        String makeFile;
        List<File> includeDirectories;

        public MakefileHolder(List<File> includeDirectories, String makeFile) {
            this.includeDirectories = includeDirectories;
            this.makeFile = makeFile;
        }

        public List<File> getIncludeDirectories() {
            return this.includeDirectories;
        }

        public String getMakeFile() {
            return this.makeFile;
        }
    }
}

