/**
 * Sencha GXT 3.1.1 - Sencha for GWT
 * Copyright(c) 2007-2014, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://www.sencha.com/products/gxt/license/
 */
package com.sencha.gxt.chart.client.draw;

/**
 * Abstract color representing hue and saturation values.
 */
public abstract class Hue extends Color {

  private double hue = 0;
  private double saturation = 0;

  /**
   * Returns the hue value.
   * 
   * @return the hue value
   */
  public double getHue() {
    return hue;
  }

  /**
   * Returns the saturation value.
   * 
   * @return the saturation value
   */
  public double getSaturation() {
    return saturation;
  }

  /**
   * Sets the hue value, a value in degrees. The value passed in will be adjusted to the range [0.0, 360.0).
   * 
   * @param hue the hue value
   */
  public void setHue(double hue) {
    double tmp = hue % 360.0;

    this.hue = tmp >= 0 ? tmp : (tmp + 360.0);
    color = null;
  }

  /**
   * Sets the saturation value, a double value between 0.0 and 1.0.
   * 
   * @param saturation the saturation value
   */
  public void setSaturation(double saturation) {
    this.saturation = Math.min(1.0, Math.max(0.0, saturation));
    color = null;
  }

}
