/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.id.macro.impl;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IllegalFormatFlagsException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.plugins.id.macro.AbstractMacro;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class SqlLoop
extends AbstractMacro {
    private static final Pattern paramPattern = Pattern.compile("\\:sqlToyLoopAsKey_\\d+A(\\.[a-zA-Z\u4e00-\u9fa5][0-9a-zA-Z\u4e00-\u9fa5_]*)*\\W");
    public static final Pattern COMPARE_PATTERN = Pattern.compile("(!=|<>|\\^=|=|>=|<=|>|<)\\s*$");
    public static final String BLANK = " ";
    private boolean skipBlank = true;

    public SqlLoop() {
    }

    public SqlLoop(boolean skipBlank) {
        this.skipBlank = skipBlank;
    }

    @Override
    public String execute(String[] params, Map<String, Object> keyValues, Object paramValues, String preSql) {
        String key;
        if (params == null || params.length < 2 || keyValues == null || keyValues.size() == 0) {
            return BLANK;
        }
        for (int i = 0; i < params.length; ++i) {
            String varStr = params[i].trim();
            if (varStr.startsWith("'") && varStr.endsWith("'") || varStr.startsWith("\"") && varStr.endsWith("\"") || varStr.startsWith("{") && varStr.endsWith("}")) {
                varStr = varStr.substring(1, varStr.length() - 1);
            }
            params[i] = varStr;
        }
        String loopParam = params[0].trim();
        if (loopParam.startsWith(":")) {
            loopParam = loopParam.substring(1).trim();
        }
        String loopContent = params[1];
        String linkSign = params.length > 2 ? params[2] : BLANK;
        Object[] loopValues = CollectionUtil.convertArray(keyValues.get(loopParam));
        if (loopValues == null || loopValues.length == 0) {
            return " @blank(:" + loopParam + ") ";
        }
        int start = 0;
        int end = loopValues.length;
        if (params.length > 3) {
            start = Integer.parseInt(params[3].trim());
        }
        if (start > loopValues.length - 1) {
            return " @blank(:" + loopParam + ") ";
        }
        if (params.length > 4) {
            end = Integer.parseInt(params[4].trim());
        }
        if (end >= loopValues.length) {
            end = loopValues.length;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object[]> regParamValues = new ArrayList<Object[]>();
        String lowContent = loopContent.toLowerCase();
        Iterator<String> keyEnums = keyValues.keySet().iterator();
        int index = 0;
        while (keyEnums.hasNext()) {
            key = keyEnums.next().toLowerCase();
            if (!lowContent.contains(":" + key + "[i]") && !lowContent.contains(":" + key + "[index]")) continue;
            keys.add(key);
            loopContent = loopContent.replaceAll("(?i)\\:" + key + "\\[index\\]", ":sqlToyLoopAsKey_" + index + "A");
            loopContent = loopContent.replaceAll("(?i)\\:" + key + "\\[i\\]", ":sqlToyLoopAsKey_" + index + "A");
            regParamValues.add(CollectionUtil.convertArray(keyValues.get(key)));
            ++index;
        }
        boolean hasNullFilter = lowContent.indexOf("#[") > 0;
        StringBuilder result = new StringBuilder();
        result.append(" @blank(:" + loopParam + ") ");
        index = 0;
        Map<String, String[]> loopParamNamesMap = SqlLoop.parseParams(loopContent);
        HashMap<String, Object> loopKeyValueMap = new HashMap<String, Object>();
        IgnoreKeyCaseMap<String, Object> allKeyValueMap = new IgnoreKeyCaseMap<String, Object>();
        for (int i = start; i < end; ++i) {
            Object loopVar = loopValues[i];
            if (this.skipBlank && !StringUtil.isNotBlank(loopVar)) continue;
            String loopStr = loopContent;
            if (index > 0) {
                result.append(BLANK);
                result.append(linkSign);
            }
            result.append(BLANK);
            loopKeyValueMap.clear();
            for (int j = 0; j < keys.size(); ++j) {
                key = ":sqlToyLoopAsKey_" + j + "A";
                String[] loopParamNames = loopParamNamesMap.get(key);
                if (loopParamNames.length == 0) {
                    loopKeyValueMap.put(key, ((Object[])regParamValues.get(j))[i]);
                    continue;
                }
                Object[] loopParamValues = BeanUtil.reflectBeanToAry(((Object[])regParamValues.get(j))[i], loopParamNames);
                for (int k = 0; k < loopParamNames.length; ++k) {
                    loopKeyValueMap.put(key.concat(".").concat(loopParamNames[k]), loopParamValues[k]);
                }
            }
            if (hasNullFilter) {
                allKeyValueMap.clear();
                allKeyValueMap.putAll(keyValues);
                allKeyValueMap.putAll(loopKeyValueMap);
                loopStr = this.processNullConditions(loopStr, allKeyValueMap);
            }
            loopStr = this.replaceAllArgs(loopStr, loopKeyValueMap, preSql);
            result.append(loopStr);
            ++index;
        }
        result.append(BLANK);
        return result.toString();
    }

    private String processNullConditions(String queryStr, IgnoreKeyCaseMap<String, Object> loopParamNamesMap) {
        int pseudoMarkStart = queryStr.indexOf("#[");
        if (pseudoMarkStart == -1) {
            return queryStr;
        }
        boolean hasNull = false;
        while (pseudoMarkStart != -1) {
            int beginMarkIndex = queryStr.lastIndexOf("#[");
            int endMarkIndex = StringUtil.getSymMarkIndex("[", "]", queryStr, beginMarkIndex);
            if (endMarkIndex == -1) {
                throw new IllegalFormatFlagsException("sql\u8bed\u53e5\u4e2d\u7f3a\u4e4f\"#[\" \u76f8\u5bf9\u79f0\u7684\"]\"\u7b26\u53f7,\u8bf7\u68c0\u67e5sql\u683c\u5f0f!");
            }
            String preSql = queryStr.substring(0, beginMarkIndex).concat(BLANK);
            String markContentSql = queryStr.substring(beginMarkIndex + SqlConfigParseUtils.SQL_PSEUDO_START_MARK_LENGTH, endMarkIndex);
            String tailSql = queryStr.substring(endMarkIndex + SqlConfigParseUtils.SQL_PSEUDO_END_MARK_LENGTH);
            String[] fullParamNames = SqlConfigParseUtils.getSqlParamsName(markContentSql, true);
            if (fullParamNames == null) {
                queryStr = preSql.concat(BLANK).concat(tailSql);
            } else {
                hasNull = false;
                for (String key : fullParamNames) {
                    Object tmp = loopParamNamesMap.get(":".concat(key));
                    if (tmp == null) {
                        tmp = loopParamNamesMap.get(key);
                    }
                    if (!StringUtil.isBlank(tmp)) continue;
                    hasNull = true;
                    break;
                }
                queryStr = hasNull ? preSql.concat(BLANK).concat(tailSql) : preSql.concat(BLANK).concat(markContentSql).concat(BLANK).concat(tailSql);
            }
            pseudoMarkStart = queryStr.indexOf("#[");
        }
        return queryStr;
    }

    private String replaceAllArgs(String queryStr, Map<String, Object> loopParamNamesMap, String fullPreSql) {
        String matchStr = BLANK.concat(queryStr);
        Matcher m = SqlToyConstants.SQL_NAMED_PATTERN.matcher(matchStr);
        StringBuilder lastSql = new StringBuilder();
        int start = 0;
        boolean hasCompare = false;
        int meter = 0;
        boolean updateSet = false;
        while (m.find()) {
            String group = m.group();
            String paramName = group.substring(2).trim();
            String preSql = matchStr.substring(start, m.start() + 1);
            if (meter == 0) {
                updateSet = StringUtil.matches(fullPreSql.concat(BLANK).concat(preSql), SqlConfigParseUtils.UPDATE_EQUAL_PATTERN);
            }
            hasCompare = StringUtil.matches(preSql, COMPARE_PATTERN);
            String key = ":".concat(paramName);
            Object paramValue = loopParamNamesMap.get(key);
            preSql = !loopParamNamesMap.containsKey(key) ? preSql.concat(":").concat(paramName) : (paramValue == null ? this.compareNull(preSql, updateSet) : preSql.concat(SqlLoop.toString(paramValue, hasCompare)));
            if (StringUtil.matches(group, SqlToyConstants.BLANK_END)) {
                preSql = preSql.concat(BLANK);
            }
            lastSql.append(preSql);
            start = m.end();
            ++meter;
        }
        if (start == 0) {
            return queryStr;
        }
        lastSql.append(matchStr.substring(start));
        return lastSql.toString().substring(1);
    }

    private String compareNull(String preSql, boolean updateSet) {
        String sqlPart = " is not ";
        int compareIndex = StringUtil.matchIndex(preSql, SqlConfigParseUtils.NOT_EQUAL_PATTERN);
        if (compareIndex == -1) {
            compareIndex = StringUtil.matchIndex(preSql, SqlConfigParseUtils.EQUAL_PATTERN);
            if (compareIndex != -1 && updateSet) {
                compareIndex = -1;
            }
            if (compareIndex != -1) {
                ++compareIndex;
            }
            sqlPart = " is ";
        }
        if (compareIndex != -1) {
            return preSql.substring(0, compareIndex).concat(sqlPart).concat("null");
        }
        return preSql.concat("null");
    }

    private static String toString(Object paramValue, boolean hasCompare) {
        String sign;
        if (paramValue == null) {
            return "null";
        }
        String string = sign = hasCompare ? "'" : "";
        String valueStr = paramValue instanceof CharSequence ? sign + paramValue + sign : (paramValue instanceof Timestamp ? sign + DateUtil.formatDate(paramValue, "yyyy-MM-dd HH:mm:ss.SSS") + sign : (paramValue instanceof Date || paramValue instanceof LocalDateTime ? sign + DateUtil.formatDate(paramValue, "yyyy-MM-dd HH:mm:ss") + sign : (paramValue instanceof LocalDate ? sign + DateUtil.formatDate(paramValue, "yyyy-MM-dd") + sign : (paramValue instanceof LocalTime ? sign + DateUtil.formatDate(paramValue, "HH:mm:ss") + sign : (paramValue instanceof Object[] ? SqlLoop.combineArray((Object[])paramValue) : (paramValue instanceof Collection ? SqlLoop.combineArray(((Collection)paramValue).toArray()) : "" + paramValue))))));
        return valueStr;
    }

    private static String combineArray(Object[] array) {
        if (array == null || array.length == 0) {
            return " null ";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            Object value;
            if (i > 0) {
                result.append(",");
            }
            if ((value = array[i]) instanceof CharSequence) {
                result.append("'" + value + "'");
                continue;
            }
            if (value instanceof Timestamp) {
                result.append("'" + DateUtil.formatDate(value, "yyyy-MM-dd HH:mm:ss.SSS") + "'");
                continue;
            }
            if (value instanceof Date || value instanceof LocalDateTime) {
                result.append("'" + DateUtil.formatDate(value, "yyyy-MM-dd HH:mm:ss") + "'");
                continue;
            }
            if (value instanceof LocalDate) {
                result.append("'" + DateUtil.formatDate(value, "yyyy-MM-dd") + "'");
                continue;
            }
            if (value instanceof LocalTime) {
                result.append("'" + DateUtil.formatDate(value, "HH:mm:ss") + "'");
                continue;
            }
            result.append("" + value);
        }
        return result.toString();
    }

    public static Map<String, String[]> parseParams(String template) {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        Matcher m = paramPattern.matcher(template.concat(BLANK));
        while (m.find()) {
            String group = m.group();
            int dotIndex = (group = group.substring(0, group.length() - 1)).indexOf(".");
            if (dotIndex != -1) {
                String key = group.substring(0, dotIndex);
                String[] items = (String[])paramsMap.get(key);
                if (items == null) {
                    paramsMap.put(key, new String[]{group.substring(dotIndex + 1)});
                    continue;
                }
                String[] newItems = new String[items.length + 1];
                newItems[items.length] = group.substring(dotIndex + 1);
                System.arraycopy(items, 0, newItems, 0, items.length);
                paramsMap.put(key, newItems);
                continue;
            }
            paramsMap.put(group, new String[0]);
        }
        return paramsMap;
    }
}

