/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.calculator;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.config.model.SummaryColMeta;
import org.sagacity.sqltoy.config.model.SummaryGroupMeta;
import org.sagacity.sqltoy.config.model.SummaryModel;
import org.sagacity.sqltoy.plugins.utils.CalculateUtils;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class GroupSummary {
    public static void process(SummaryModel summaryModel, LabelIndexModel labelIndexMap, List result) {
        if (result == null || result.size() < 2) {
            return;
        }
        int dataWidth = ((List)result.get(0)).size();
        List<Integer> sumColList = CalculateUtils.parseColumns(labelIndexMap, summaryModel.getSumColumns(), dataWidth);
        List<Integer> aveColList = CalculateUtils.parseColumns(labelIndexMap, summaryModel.getAveColumns(), dataWidth);
        LinkedHashSet<Integer> summaryColsSet = new LinkedHashSet<Integer>();
        for (Integer index : sumColList) {
            summaryColsSet.add(index);
        }
        for (Integer index : aveColList) {
            summaryColsSet.add(index);
        }
        if (summaryModel.getGroupMeta() == null || summaryModel.getGroupMeta().length == 0 || summaryColsSet.size() == 0) {
            throw new IllegalArgumentException("summary\u8ba1\u7b97\u672a\u6b63\u786e\u914d\u7f6esum-columns\u6216average-columns\u6216group\u5206\u7ec4\u4fe1\u606f!");
        }
        Integer[] summaryCols = new Integer[summaryColsSet.size()];
        summaryColsSet.toArray(summaryCols);
        boolean bothSumAverage = !sumColList.isEmpty() && !aveColList.isEmpty();
        SummaryGroupMeta[] sumMetas = new SummaryGroupMeta[summaryModel.getGroupMeta().length];
        int i = 0;
        int dataSize = result.size();
        ArrayList<Integer> preAllGroups = new ArrayList<Integer>();
        int lastGroupOrderIndex = 0;
        for (SummaryGroupMeta meta : summaryModel.getGroupMeta()) {
            if (meta.getOrderColumn() == null) continue;
            ++lastGroupOrderIndex;
        }
        int meter = 0;
        for (SummaryGroupMeta meta : summaryModel.getGroupMeta()) {
            SummaryGroupMeta groupMeta = meta.clone();
            String sumSite = summaryModel.getSumSite() == null ? "top" : summaryModel.getSumSite().toLowerCase();
            List<Integer> groupColsList = CalculateUtils.parseColumns(labelIndexMap, groupMeta.getGroupColumn(), dataWidth);
            Integer[] groupCols = new Integer[groupColsList.size()];
            groupColsList.toArray(groupCols);
            groupMeta.setGroupCols(groupCols);
            preAllGroups.addAll(groupColsList);
            if (groupMeta.getOrderColumn() != null) {
                ++meter;
                Integer sortIndex = labelIndexMap.get(groupMeta.getOrderColumn());
                boolean isSum = true;
                if (groupMeta.getOrderWithSum() != null) {
                    isSum = groupMeta.getOrderWithSum();
                } else if (sumColList.contains(sortIndex)) {
                    isSum = true;
                } else if (aveColList.contains(sortIndex)) {
                    isSum = false;
                }
                boolean desc = groupMeta.getOrderWay().equalsIgnoreCase("desc");
                Integer[] groupIndexes = new Integer[preAllGroups.size()];
                preAllGroups.toArray(groupIndexes);
                if (groupIndexes.length == 1) {
                    if (!summaryModel.isHasGrouped()) {
                        int dataType = CollectionUtil.getSortDataType(result, groupIndexes[0]);
                        CollectionUtil.sortList(result, groupIndexes[0], dataType, 0, dataSize - 1, !desc);
                    }
                    CollectionUtil.groupCalculate(result, groupIndexes, sortIndex, isSum);
                    CollectionUtil.sortList(result, dataWidth, 2, 0, dataSize - 1, !desc);
                } else {
                    Integer[] sortGroupIndexes = new Integer[groupIndexes.length - 1];
                    System.arraycopy(groupIndexes, 0, sortGroupIndexes, 0, groupIndexes.length - 1);
                    if (!summaryModel.isHasGrouped()) {
                        CollectionUtil.groupSort(result, sortGroupIndexes, groupIndexes[groupIndexes.length - 1], desc);
                    }
                    CollectionUtil.groupCalculate(result, groupIndexes, sortIndex, isSum);
                    CollectionUtil.groupSort(result, sortGroupIndexes, dataWidth, desc);
                    if (meter == lastGroupOrderIndex && !summaryModel.isHasGrouped()) {
                        CollectionUtil.groupSort(result, groupIndexes, sortIndex, desc);
                    }
                }
                for (int k = 0; k < dataSize; ++k) {
                    ((List)result.get(k)).remove(dataWidth);
                }
            }
            if (bothSumAverage) {
                if (StringUtil.isNotBlank(groupMeta.getSumTitle()) && StringUtil.isNotBlank(groupMeta.getAverageTitle())) {
                    groupMeta.setSummaryType(3);
                } else if (StringUtil.isNotBlank(groupMeta.getAverageTitle())) {
                    groupMeta.setSummaryType(2);
                } else {
                    groupMeta.setSummaryType(1);
                }
            } else if (!sumColList.isEmpty()) {
                groupMeta.setSummaryType(1);
            } else if (!aveColList.isEmpty()) {
                groupMeta.setSummaryType(2);
            }
            groupMeta.setSumSite(sumSite);
            if (groupMeta.getLabelColumn() == null) {
                groupMeta.setLabelIndex(0);
            } else {
                groupMeta.setLabelIndex(NumberUtil.isInteger(groupMeta.getLabelColumn()) ? Integer.parseInt(groupMeta.getLabelColumn()) : labelIndexMap.get(groupMeta.getLabelColumn().toLowerCase()));
            }
            if (groupMeta.getSummaryType() == 3 && ("top".equals(sumSite) || "bottom".equals(sumSite))) {
                groupMeta.setRowSize(2);
            }
            groupMeta.setSummaryCols(GroupSummary.createColMeta(summaryCols, summaryModel, sumColList, aveColList));
            sumMetas[i] = groupMeta;
            ++i;
        }
        CollectionUtil.groupSummary(result, sumMetas, summaryModel.isReverse(), summaryModel.getLinkSign(), summaryModel.isSkipSingleRow());
    }

    private static SummaryColMeta[] createColMeta(Integer[] summaryCols, SummaryModel summaryModel, List<Integer> sumColList, List<Integer> aveColList) {
        SummaryColMeta[] colMetas = new SummaryColMeta[summaryCols.length];
        RoundingMode[] roundingModes = summaryModel.getRoundingModes();
        int roundingSize = roundingModes == null ? 0 : roundingModes.length;
        int aveIndex = 0;
        Integer[] radixSizes = summaryModel.getRadixSize();
        int radixSizeLen = radixSizes == null ? 0 : radixSizes.length;
        for (int i = 0; i < summaryCols.length; ++i) {
            SummaryColMeta colMeta = new SummaryColMeta();
            colMeta.setAveSkipNull(summaryModel.isAveSkipNull());
            colMeta.setSummaryType(0);
            colMeta.setColIndex(summaryCols[i]);
            if (radixSizeLen == 1) {
                colMeta.setRadixSize(radixSizes[0]);
            }
            if (roundingSize == 1) {
                colMeta.setRoundingMode(roundingModes[0]);
            }
            if (sumColList.contains(summaryCols[i])) {
                colMeta.setSummaryType(colMeta.getSummaryType() + 1);
            }
            if (aveColList.contains(summaryCols[i])) {
                colMeta.setSummaryType(colMeta.getSummaryType() + 2);
                if (roundingSize > 1 && aveIndex < roundingSize && roundingModes[aveIndex] != null) {
                    colMeta.setRoundingMode(roundingModes[aveIndex]);
                }
                if (radixSizeLen > 1 && aveIndex < radixSizeLen && radixSizes[aveIndex] != null) {
                    colMeta.setRadixSize(radixSizes[aveIndex]);
                }
                ++aveIndex;
            }
            colMetas[i] = colMeta;
        }
        return colMetas;
    }
}

