/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.PreparedStatementResultHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.SqlWithAnalysis;
import org.sagacity.sqltoy.config.model.TableCascadeModel;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.IgnoreCaseSet;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDialectUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SqlServerDialectUtils.class);

    public static QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String innerSql;
        StringBuilder sql = new StringBuilder();
        String string = innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        String partSql = " select top " + randomCount + " ";
        if (sqlToyConfig.isHasWith()) {
            SqlWithAnalysis sqlWith = new SqlWithAnalysis(innerSql);
            sql.append(sqlWith.getWithSql());
            innerSql = sqlWith.getRejectWithSql();
        }
        boolean hasOrderOrUnion = DialectUtils.hasOrderByOrUnion(innerSql);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (hasOrderOrUnion) {
            sql.append(partSql);
            sql.append(" " + SqlToyConstants.INTERMEDIATE_TABLE + ".* from (");
            sql.append(innerSql);
            sql.append(") ");
            sql.append(SqlToyConstants.INTERMEDIATE_TABLE);
            sql.append(" ");
        } else {
            sql.append(innerSql.replaceFirst("(?i)select ", partSql));
        }
        sql.append(" order by NEWID() ");
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        SqlToyResult queryParam = SqlConfigParseUtils.processSql(sql.toString(), extend.getParamsName(), extend.getParamsValue(sqlToyContext, sqlToyConfig), dialect);
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.random : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static Long saveOrUpdateAll(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, entityMeta, forceUpdateFields, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                String sql = SqlServerDialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), forceUpdateFields, tableName, "isnull", "@mySeqVariable", false);
                if (entityMeta.getIdStrategy() != null && entityMeta.getIdStrategy().equals((Object)PKStrategy.SEQUENCE)) {
                    sql = "DECLARE @mySeqVariable as numeric(20)=NEXT VALUE FOR " + entityMeta.getSequence() + " " + sql;
                }
                return sql.concat(";");
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    public static String getSaveOrUpdateSql(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String[] forceUpdateFields, String tableName, String isNullFunction, String sequence, boolean isAssignPK) {
        boolean allIds;
        String columnName;
        if (entityMeta.getIdArray() == null) {
            return SqlServerDialectUtils.generateInsertSql(unifyFieldsHandler, dbType, entityMeta, tableName, pkStrategy, isNullFunction, sequence, isAssignPK);
        }
        IgnoreKeyCaseMap<String, Object> createUnifyFields = null;
        if (unifyFieldsHandler != null && unifyFieldsHandler.createUnifyFields() != null && !unifyFieldsHandler.createUnifyFields().isEmpty()) {
            createUnifyFields = new IgnoreKeyCaseMap<String, Object>();
            createUnifyFields.putAll(unifyFieldsHandler.createUnifyFields());
        }
        IgnoreCaseSet createSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.createSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.createSqlTimeFields();
        IgnoreCaseSet updateSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.updateSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.updateSqlTimeFields();
        IgnoreCaseSet forceUpdateSqlTimeFields = new IgnoreCaseSet();
        if (unifyFieldsHandler != null && unifyFieldsHandler.forceUpdateFields() != null) {
            forceUpdateSqlTimeFields = unifyFieldsHandler.forceUpdateFields();
        }
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 30 + 100);
        sql.append("merge into ");
        sql.append(realTable);
        sql.append(" ta ");
        sql.append(" using (select ");
        for (int i = 0; i < columnSize; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getFieldsArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(",");
            }
            sql.append("? as ");
            sql.append(columnName);
        }
        sql.append(") tv on (");
        StringBuilder idColumns = new StringBuilder();
        int n = entityMeta.getIdArray().length;
        for (int i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
                idColumns.append(",");
            }
            sql.append(" ta.").append(columnName).append("=tv.").append(columnName);
            idColumns.append("ta.").append(columnName);
        }
        sql.append(" ) ");
        StringBuilder insertRejIdCols = new StringBuilder();
        StringBuilder insertRejIdColValues = new StringBuilder();
        boolean bl = allIds = entityMeta.getRejectIdFieldArray() == null;
        if (!allIds) {
            sql.append(" when matched then update set ");
            int rejectIdColumnSize = entityMeta.getRejectIdFieldArray().length;
            HashSet<String> fupc = new HashSet<String>();
            if (forceUpdateFields != null) {
                for (String field : forceUpdateFields) {
                    fupc.add(ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType));
                }
            }
            boolean isStart = true;
            int meter = 0;
            for (int i = 0; i < rejectIdColumnSize; ++i) {
                FieldMeta fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
                if (fieldMeta.getType() == 93) continue;
                columnName = fieldMeta.getColumnName();
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, updateSqlTimeFields);
                if (meter > 0) {
                    sql.append(",");
                }
                sql.append(" ta.").append(columnName).append("=");
                if (null != currentTimeStr && forceUpdateSqlTimeFields.contains(fieldMeta.getFieldName())) {
                    sql.append(currentTimeStr);
                } else if (fupc.contains(columnName)) {
                    sql.append("tv.").append(columnName);
                } else {
                    sql.append(isNullFunction);
                    if (fieldMeta.getType() == 3) {
                        int decimalLength = fieldMeta.getLength() > 35 ? fieldMeta.getLength() : 35;
                        int decimalScale = fieldMeta.getScale() > 5 ? fieldMeta.getScale() : 5;
                        sql.append("(cast(tv.").append(columnName).append(" as decimal(" + decimalLength + "," + decimalScale + "))");
                    } else {
                        sql.append("(tv.").append(columnName);
                    }
                    sql.append(",");
                    if (null != currentTimeStr) {
                        sql.append(currentTimeStr);
                    } else {
                        sql.append("ta.").append(columnName);
                    }
                    sql.append(")");
                }
                if (!isStart) {
                    insertRejIdCols.append(",");
                    insertRejIdColValues.append(",");
                }
                insertRejIdCols.append(columnName);
                isStart = false;
                currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, createSqlTimeFields);
                if (null != currentTimeStr && forceUpdateSqlTimeFields.contains(fieldMeta.getFieldName())) {
                    insertRejIdColValues.append(currentTimeStr);
                } else {
                    String defaultValue = DialectExtUtils.getInsertDefaultValue(createUnifyFields, dbType, fieldMeta);
                    if (null != defaultValue) {
                        insertRejIdColValues.append(isNullFunction);
                        insertRejIdColValues.append("(tv.").append(columnName).append(",");
                        DialectExtUtils.processDefaultValue(insertRejIdColValues, dbType, fieldMeta, defaultValue);
                        insertRejIdColValues.append(")");
                    } else if (null != currentTimeStr) {
                        insertRejIdColValues.append(isNullFunction);
                        insertRejIdColValues.append("(tv.").append(columnName).append(",");
                        insertRejIdColValues.append(currentTimeStr);
                        insertRejIdColValues.append(")");
                    } else {
                        insertRejIdColValues.append("tv.").append(columnName);
                    }
                }
                ++meter;
            }
        }
        sql.append(" when not matched then insert ");
        sql.append(" (");
        String idsColumnStr = idColumns.toString();
        if (allIds) {
            sql.append(idsColumnStr.replace("ta.", ""));
            sql.append(") values (");
            sql.append(idsColumnStr.replace("ta.", "tv."));
        } else {
            sql.append(insertRejIdCols.toString());
            if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                sql.append(",");
                sql.append(columnName);
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                if (isAssignPK) {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName).append(",");
                    sql.append(sequence).append(") ");
                } else {
                    sql.append(sequence);
                }
            } else if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (isAssignPK) {
                    sql.append(",");
                    sql.append(columnName);
                }
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
                if (isAssignPK) {
                    sql.append(",").append("tv.").append(columnName);
                }
            } else {
                sql.append(",");
                sql.append(idsColumnStr.replace("ta.", ""));
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                sql.append(idsColumnStr.replace("ta.", "tv."));
            }
        }
        sql.append(")");
        return sql.toString();
    }

    public static String getSaveIgnoreExistSql(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String tableName, String isNullFunction, String sequence, boolean isAssignPK) {
        boolean allIds;
        String columnName;
        if (entityMeta.getIdArray() == null) {
            return SqlServerDialectUtils.generateInsertSql(unifyFieldsHandler, dbType, entityMeta, tableName, pkStrategy, isNullFunction, sequence, isAssignPK);
        }
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 30 + 100);
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        IgnoreCaseSet createSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.createSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.createSqlTimeFields();
        IgnoreCaseSet forceUpdateSqlTimeFields = new IgnoreCaseSet();
        if (unifyFieldsHandler != null && unifyFieldsHandler.forceUpdateFields() != null) {
            forceUpdateSqlTimeFields = unifyFieldsHandler.forceUpdateFields();
        }
        sql.append("merge into ");
        sql.append(realTable);
        sql.append(" ta ");
        sql.append(" using (select ");
        for (int i = 0; i < columnSize; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getFieldsArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(",");
            }
            sql.append("? as ");
            sql.append(columnName);
        }
        sql.append(") tv on (");
        StringBuilder idColumns = new StringBuilder();
        int n = entityMeta.getIdArray().length;
        for (int i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
                idColumns.append(",");
            }
            sql.append(" ta.").append(columnName).append("=tv.").append(columnName);
            idColumns.append("ta.").append(columnName);
        }
        sql.append(" ) ");
        StringBuilder insertRejIdCols = new StringBuilder();
        StringBuilder insertRejIdColValues = new StringBuilder();
        boolean bl = allIds = entityMeta.getRejectIdFieldArray() == null;
        if (!allIds) {
            int rejectIdColumnSize = entityMeta.getRejectIdFieldArray().length;
            int meter = 0;
            for (int i = 0; i < rejectIdColumnSize; ++i) {
                FieldMeta fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
                columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
                if (fieldMeta.getType() != 93) {
                    if (meter > 0) {
                        insertRejIdCols.append(",");
                        insertRejIdColValues.append(",");
                    }
                    insertRejIdCols.append(columnName);
                    String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, createSqlTimeFields);
                    if (null != currentTimeStr) {
                        if (forceUpdateSqlTimeFields.contains(fieldMeta.getFieldName())) {
                            insertRejIdColValues.append(currentTimeStr);
                        } else {
                            insertRejIdColValues.append(isNullFunction);
                            insertRejIdColValues.append("(tv.").append(columnName);
                            insertRejIdColValues.append(",").append(currentTimeStr);
                            insertRejIdColValues.append(")");
                        }
                    } else {
                        insertRejIdColValues.append("tv.").append(columnName);
                    }
                }
                ++meter;
            }
        }
        sql.append(" when not matched then insert ");
        sql.append(" (");
        String idsColumnStr = idColumns.toString();
        if (allIds) {
            sql.append(idsColumnStr.replace("ta.", ""));
            sql.append(") values (");
            sql.append(idsColumnStr.replace("ta.", "tv."));
        } else {
            sql.append(insertRejIdCols.toString());
            if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                sql.append(",");
                sql.append(columnName);
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                if (isAssignPK) {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName).append(",");
                    sql.append(sequence).append(") ");
                } else {
                    sql.append(sequence);
                }
            } else if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (isAssignPK) {
                    sql.append(",");
                    sql.append(columnName);
                }
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
                if (isAssignPK) {
                    sql.append(",").append("tv.").append(columnName);
                }
            } else {
                sql.append(",");
                sql.append(idsColumnStr.replace("ta.", ""));
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                sql.append(idsColumnStr.replace("ta.", "tv."));
            }
        }
        sql.append(")");
        return sql.toString();
    }

    public static String generateInsertSql(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, String tableName, PKStrategy pkStrategy, String isNullFunction, String sequence, boolean isAssignPK) {
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 20 + 30);
        StringBuilder values = new StringBuilder(columnSize * 2 - 1);
        sql.append(" insert into ");
        sql.append(entityMeta.getSchemaTable(tableName, dbType));
        sql.append(" (");
        boolean isStart = true;
        IgnoreCaseSet createSqlTimeFields = unifyFieldsHandler == null || unifyFieldsHandler.createSqlTimeFields() == null ? new IgnoreCaseSet() : unifyFieldsHandler.createSqlTimeFields();
        for (int i = 0; i < columnSize; ++i) {
            String field = entityMeta.getFieldsArray()[i];
            FieldMeta fieldMeta = entityMeta.getFieldMeta(field);
            String columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (fieldMeta.isPK()) {
                if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    if (!isAssignPK) continue;
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    values.append("?");
                    isStart = false;
                    continue;
                }
                if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    if (isAssignPK) {
                        values.append(isNullFunction);
                        values.append("(?,").append(sequence).append(")");
                    } else {
                        values.append(sequence);
                    }
                    isStart = false;
                    continue;
                }
                if (fieldMeta.getType() == 93) continue;
                if (!isStart) {
                    sql.append(",");
                    values.append(",");
                }
                sql.append(columnName);
                values.append("?");
                isStart = false;
                continue;
            }
            if (fieldMeta.getType() == 93) continue;
            if (!isStart) {
                sql.append(",");
                values.append(",");
            }
            sql.append(fieldMeta.getColumnName());
            String currentTimeStr = SqlUtil.getDBTime(dbType, fieldMeta, createSqlTimeFields);
            if (null != currentTimeStr) {
                values.append(isNullFunction).append("(?,").append(currentTimeStr).append(")");
            } else {
                values.append("?");
            }
            isStart = false;
        }
        sql.append(") values (");
        sql.append((CharSequence)values);
        sql.append(")");
        return sql.toString();
    }

    public static Object save(final SqlToyContext sqlToyContext, Serializable entity, final Connection conn, final Integer dbType, String tableName) throws Exception {
        final EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        final boolean isIdentity = entityMeta.getIdStrategy() != null && entityMeta.getIdStrategy().equals((Object)PKStrategy.IDENTITY);
        final boolean isSequence = entityMeta.getIdStrategy() != null && entityMeta.getIdStrategy().equals((Object)PKStrategy.SEQUENCE);
        String insertSql = SqlServerDialectUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, tableName, entityMeta.getIdStrategy(), "isnull", "@mySeqVariable", !isIdentity);
        if (isSequence) {
            insertSql = "set nocount on DECLARE @mySeqVariable as numeric(20)=NEXT VALUE FOR " + entityMeta.getSequence() + " " + insertSql + " select @mySeqVariable ";
        }
        int pkIndex = entityMeta.getIdIndex();
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, null, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        String[] reflectColumns = isIdentity ? entityMeta.getRejectIdFieldArray() : entityMeta.getFieldsArray();
        Object[] fullParamValues = BeanUtil.reflectBeanToAry(entity, reflectColumns, SqlUtilsExt.getDefaultValues(entityMeta), handler);
        boolean needUpdatePk = false;
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        String signature = entityMeta.getBizIdSignature();
        Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
        if (entityMeta.getIdStrategy() != null && null != entityMeta.getIdGenerator()) {
            String businessIdType;
            int idLength = entityMeta.getIdLength();
            int bizIdLength = entityMeta.getBizIdLength();
            Object[] relatedColValue = null;
            String string = businessIdType = hasBizId ? entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()) : "";
            if (relatedColumn != null) {
                relatedColValue = new Object[relatedColumn.length];
                for (int meter = 0; meter < relatedColumn.length; ++meter) {
                    relatedColValue[meter] = fullParamValues[relatedColumn[meter]];
                    if (relatedColValue[meter] != null) continue;
                    throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + relatedColumn[meter] + " \u503c\u4e3anull!");
                }
            }
            if (StringUtil.isBlank(fullParamValues[pkIndex])) {
                fullParamValues[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), signature, entityMeta.getBizIdRelatedColumns(), relatedColValue, null, entityMeta.getIdType(), idLength, entityMeta.getBizIdSequenceSize());
                needUpdatePk = true;
            }
            if (hasBizId && StringUtil.isBlank(fullParamValues[bizIdColIndex])) {
                fullParamValues[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), signature, entityMeta.getBizIdRelatedColumns(), relatedColValue, null, businessIdType, bizIdLength, entityMeta.getBizIdSequenceSize());
                BeanUtil.setProperty(entity, entityMeta.getBusinessIdField(), fullParamValues[bizIdColIndex]);
            }
        }
        SqlToyConfig sqlToyConfig = new SqlToyConfig("sqlserver");
        sqlToyConfig.setSqlType(SqlType.insert);
        sqlToyConfig.setSql(insertSql);
        sqlToyConfig.setParamsName(reflectColumns);
        SqlToyResult sqlToyResult = new SqlToyResult(insertSql, fullParamValues);
        sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.insert, sqlToyResult, entity.getClass(), dbType);
        final Object[] paramValues = sqlToyResult.getParamsValue();
        final Integer[] paramsType = entityMeta.getFieldsTypeArray();
        final String realInsertSql = sqlToyResult.getSql();
        SqlExecuteStat.showSql("mssql\u5355\u6761\u8bb0\u5f55\u63d2\u5165", realInsertSql, null);
        PreparedStatement pst = null;
        Object result = SqlUtil.preparedStatementProcess(null, pst, null, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object obj, PreparedStatement pst, ResultSet rs) throws SQLException, IOException {
                pst = isIdentity ? conn.prepareStatement(realInsertSql, new String[]{entityMeta.getColumnName(entityMeta.getIdArray()[0])}) : conn.prepareStatement(realInsertSql);
                if (null != paramValues && paramValues.length > 0) {
                    int index = 0;
                    int n = paramValues.length;
                    for (int i = 0; i < n; ++i) {
                        if (paramsType[i].equals(93)) continue;
                        SqlUtil.setParamValue(sqlToyContext.getTypeHandler(), conn, dbType, pst, paramValues[i], paramsType[i], index + 1);
                        ++index;
                    }
                }
                ResultSet keyResult = null;
                if (isSequence) {
                    keyResult = pst.executeQuery();
                } else {
                    pst.execute();
                }
                if (isIdentity) {
                    keyResult = pst.getGeneratedKeys();
                }
                if ((isSequence || isIdentity) && keyResult != null) {
                    while (keyResult.next()) {
                        this.setResult(keyResult.getObject(1));
                    }
                }
            }
        });
        if (entityMeta.getIdArray() == null) {
            return null;
        }
        if (result == null) {
            result = fullParamValues[pkIndex];
        }
        if (needUpdatePk || isIdentity || isSequence) {
            BeanUtil.setProperty(entity, entityMeta.getIdArray()[0], result);
        }
        if (!entityMeta.getCascadeModels().isEmpty()) {
            List<Object> subTableData = null;
            for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
                final Object[] mainFieldValues = BeanUtil.reflectBeanToAry(entity, cascadeModel.getFields());
                final String[] mappedFields = cascadeModel.getMappedFields();
                EntityMeta subTableEntityMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
                if (cascadeModel.getCascadeType() == 1) {
                    subTableData = (List)BeanUtil.getProperty(entity, cascadeModel.getProperty());
                } else {
                    subTableData = new ArrayList();
                    Object item = BeanUtil.getProperty(entity, cascadeModel.getProperty());
                    if (item != null) {
                        subTableData.add(item);
                    }
                }
                if (subTableData != null && !subTableData.isEmpty()) {
                    logger.info("\u6267\u884csave\u64cd\u4f5c\u7684\u7ea7\u8054\u5b50\u8868{}\u6279\u91cf\u4fdd\u5b58!", (Object)subTableEntityMeta.getTableName());
                    SqlExecuteStat.debug("\u6267\u884c\u5b50\u8868\u7ea7\u8054\u4fdd\u5b58\u64cd\u4f5c", null, new Object[0]);
                    SqlServerDialectUtils.saveAll(sqlToyContext, subTableData, new ReflectPropsHandler(){

                        @Override
                        public void process() {
                            for (int i = 0; i < mappedFields.length; ++i) {
                                this.setValue(mappedFields[i], mainFieldValues[i]);
                            }
                        }
                    }, conn, dbType, null, null);
                    continue;
                }
                logger.info("\u672a\u6267\u884csave\u64cd\u4f5c\u7684\u7ea7\u8054\u5b50\u8868{}\u6279\u91cf\u4fdd\u5b58,\u5b50\u8868\u6570\u636e\u4e3a\u7a7a!", (Object)subTableEntityMeta.getTableName());
            }
        }
        return result;
    }

    public static Long saveAll(SqlToyContext sqlToyContext, List<?> entities, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        boolean isAssignPK = SqlServerDialectUtils.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = SqlServerDialectUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, tableName, entityMeta.getIdStrategy(), "isnull", "@mySeqVariable", isAssignPK);
        if (entityMeta.getIdStrategy() != null && entityMeta.getIdStrategy().equals((Object)PKStrategy.SEQUENCE)) {
            insertSql = "DECLARE @mySeqVariable as numeric(20)=NEXT VALUE FOR " + entityMeta.getSequence() + " " + insertSql;
        }
        return SqlServerDialectUtils.saveAll(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), isAssignPK, insertSql, entities, reflectPropsHandler, conn, dbType, autoCommit);
    }

    private static Long saveAll(SqlToyContext sqlToyContext, EntityMeta entityMeta, PKStrategy pkStrategy, boolean isAssignPK, String insertSql, List<?> entities, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit) throws Exception {
        boolean isIdentity = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY);
        boolean isSequence = pkStrategy != null && pkStrategy.equals((Object)PKStrategy.SEQUENCE);
        String[] reflectColumns = isIdentity && !isAssignPK || isSequence && !isAssignPK ? entityMeta.getRejectIdFieldArray() : entityMeta.getFieldsArray();
        ReflectPropsHandler handler = DialectUtils.getAddReflectHandler(entityMeta, reflectPropsHandler, sqlToyContext.getUnifyFieldsHandler());
        handler = DialectUtils.getSecureReflectHandler(handler, sqlToyContext.getFieldsSecureProvider(), sqlToyContext.getDesensitizeProvider(), entityMeta.getSecureFields());
        List paramValues = BeanUtil.reflectBeansToInnerAry(entities, reflectColumns, SqlUtilsExt.getDefaultValues(entityMeta), handler);
        int pkIndex = entityMeta.getIdIndex();
        boolean hasBizId = entityMeta.getBusinessIdGenerator() != null;
        int bizIdColIndex = hasBizId ? entityMeta.getFieldIndex(entityMeta.getBusinessIdField()) : 0;
        String signature = entityMeta.getBizIdSignature();
        Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
        if (pkStrategy != null && null != entityMeta.getIdGenerator()) {
            int idLength = entityMeta.getIdLength();
            int bizIdLength = entityMeta.getBizIdLength();
            boolean isAssigned = true;
            ArrayList<Object[]> idSet = new ArrayList<Object[]>();
            String idJdbcType = entityMeta.getIdType();
            Object[] relatedColValue = null;
            String businessIdType = hasBizId ? entityMeta.getColumnJavaType(entityMeta.getBusinessIdField()) : "";
            int s = paramValues.size();
            for (int i = 0; i < s; ++i) {
                Object[] rowData = paramValues.get(i);
                if (relatedColumn != null) {
                    relatedColValue = new Object[relatedColumn.length];
                    for (int meter = 0; meter < relatedColumn.length; ++meter) {
                        relatedColValue[meter] = rowData[relatedColumn[meter]];
                        if (relatedColValue[meter] != null) continue;
                        throw new IllegalArgumentException("\u5bf9\u8c61:" + entityMeta.getEntityClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + relatedColumn[meter] + " \u503c\u4e3anull!");
                    }
                }
                if (StringUtil.isBlank(rowData[pkIndex])) {
                    isAssigned = false;
                    rowData[pkIndex] = entityMeta.getIdGenerator().getId(entityMeta.getTableName(), signature, entityMeta.getBizIdRelatedColumns(), relatedColValue, null, idJdbcType, idLength, entityMeta.getBizIdSequenceSize());
                }
                if (hasBizId && StringUtil.isBlank(rowData[bizIdColIndex])) {
                    rowData[bizIdColIndex] = entityMeta.getBusinessIdGenerator().getId(entityMeta.getTableName(), signature, entityMeta.getBizIdRelatedColumns(), relatedColValue, null, businessIdType, bizIdLength, entityMeta.getBizIdSequenceSize());
                    BeanUtil.setProperty(entities.get(i), entityMeta.getBusinessIdField(), rowData[bizIdColIndex]);
                }
                idSet.add(new Object[]{rowData[pkIndex]});
            }
            if (!isAssigned) {
                BeanUtil.mappingSetProperties(entities, entityMeta.getIdArray(), idSet, new int[]{0}, true);
            }
        }
        List realParams = paramValues;
        String realSql = insertSql;
        if (sqlToyContext.hasSqlInterceptors()) {
            SqlToyConfig sqlToyConfig = new SqlToyConfig("sqlserver");
            sqlToyConfig.setSqlType(SqlType.insert);
            sqlToyConfig.setSql(insertSql);
            sqlToyConfig.setParamsName(reflectColumns);
            SqlToyResult sqlToyResult = new SqlToyResult(insertSql, paramValues.toArray());
            sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.insertAll, sqlToyResult, entities.get(0).getClass(), dbType);
            realSql = sqlToyResult.getSql();
            realParams = CollectionUtil.arrayToList(sqlToyResult.getParamsValue());
        }
        SqlExecuteStat.showSql("mssql\u6279\u91cf\u4fdd\u5b58", realSql, null);
        return SqlUtilsExt.batchUpdateForPOJO(sqlToyContext.getTypeHandler(), realSql, realParams, entityMeta.getFieldsTypeArray(), entityMeta.getFieldsDefaultValue(), entityMeta.getFieldsNullable(), sqlToyContext.getBatchSize(), autoCommit, conn, dbType);
    }

    public static Long update(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, boolean cascade, Class[] emptyCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, Integer dbType, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        Long updateCount = DialectUtils.update(sqlToyContext, entity, entityMeta, "isnull", forceUpdateFields, conn, dbType, realTable);
        if (cascade && !entityMeta.getCascadeModels().isEmpty()) {
            HashMap<Class, String> typeMap = new HashMap<Class, String>();
            if (emptyCascadeClasses != null) {
                for (Class type : emptyCascadeClasses) {
                    typeMap.put(type, "");
                }
            }
            List<Object> subTableData = null;
            String[] forceUpdateProps = null;
            for (TableCascadeModel cascadeModel : entityMeta.getCascadeModels()) {
                final Object[] mainFieldValues = BeanUtil.reflectBeanToAry(entity, cascadeModel.getFields());
                EntityMeta subTableEntityMeta = sqlToyContext.getEntityMeta(cascadeModel.getMappedType());
                String[] stringArray = forceUpdateProps = subTableForceUpdateProps == null ? null : subTableForceUpdateProps.get(cascadeModel.getMappedType());
                if (cascadeModel.getCascadeType() == 1) {
                    subTableData = (List)BeanUtil.getProperty(entity, cascadeModel.getProperty());
                } else {
                    subTableData = new ArrayList();
                    Object item = BeanUtil.getProperty(entity, cascadeModel.getProperty());
                    if (item != null) {
                        subTableData.add(item);
                    }
                }
                final String[] mappedFields = cascadeModel.getMappedFields();
                if (cascadeModel.getCascadeUpdateSql() != null && (subTableData != null && !subTableData.isEmpty() || typeMap.containsKey(cascadeModel.getMappedType()))) {
                    SqlExecuteStat.debug("\u6267\u884c\u5b50\u8868\u7ea7\u8054\u66f4\u65b0\u524d\u7684\u5b58\u91cf\u6570\u636e\u66f4\u65b0", null, new Object[0]);
                    SqlToyResult sqlToyResult = SqlConfigParseUtils.processSql(cascadeModel.getCascadeUpdateSql(), mappedFields, mainFieldValues, null);
                    SqlToyConfig sqlToyConfig = new SqlToyConfig("sqlserver");
                    sqlToyConfig.setSqlType(SqlType.update);
                    sqlToyConfig.setSql(cascadeModel.getCascadeUpdateSql());
                    sqlToyConfig.setParamsName(mappedFields);
                    sqlToyResult = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, OperateType.execute, sqlToyResult, cascadeModel.getMappedType(), dbType);
                    SqlUtil.executeSql(sqlToyContext.getTypeHandler(), sqlToyResult.getSql(), sqlToyResult.getParamsValue(), null, conn, dbType, null, true);
                }
                if (subTableData != null && !subTableData.isEmpty()) {
                    logger.info("\u6267\u884cupdate\u4e3b\u8868:{} \u5bf9\u5e94\u7ea7\u8054\u5b50\u8868: {} \u66f4\u65b0\u64cd\u4f5c!", (Object)tableName, (Object)subTableEntityMeta.getTableName());
                    SqlExecuteStat.debug("\u6267\u884c\u5b50\u8868\u7ea7\u8054\u66f4\u65b0\u64cd\u4f5c", null, new Object[0]);
                    SqlServerDialectUtils.saveOrUpdateAll(sqlToyContext, subTableData, sqlToyContext.getBatchSize(), new ReflectPropsHandler(){

                        @Override
                        public void process() {
                            for (int i = 0; i < mappedFields.length; ++i) {
                                this.setValue(mappedFields[i], mainFieldValues[i]);
                            }
                        }
                    }, forceUpdateProps, conn, dbType, null, null);
                    continue;
                }
                logger.info("\u672a\u6267\u884cupdate\u4e3b\u8868:{} \u5bf9\u5e94\u7ea7\u8054\u5b50\u8868: {} \u66f4\u65b0\u64cd\u4f5c,\u5b50\u8868\u6570\u636e\u4e3a\u7a7a!", (Object)tableName, (Object)subTableEntityMeta.getTableName());
            }
        }
        return updateCount;
    }

    public static String lockSql(String loadSql, String tableName, LockMode lockMode) {
        String realTableName;
        if (lockMode == null || SqlUtil.hasLock(loadSql, 30)) {
            return loadSql;
        }
        int fromIndex = StringUtil.getSymMarkMatchIndex("(?i)select\\s+", "(?i)\\s+from[\\(\\s+]", loadSql, 0);
        String selectPart = loadSql.substring(0, fromIndex);
        String fromPart = loadSql.substring(fromIndex);
        String[] sqlChips = fromPart.trim().split("\\s+");
        String string = realTableName = tableName == null ? sqlChips[1] : tableName;
        if (realTableName.indexOf(",") != -1) {
            realTableName = realTableName.substring(0, realTableName.indexOf(","));
        }
        int chipSize = sqlChips.length;
        String replaceStr = realTableName;
        String regex = realTableName;
        for (int i = 0; i < chipSize; ++i) {
            String tmp = sqlChips[i];
            if (tmp.toLowerCase().indexOf(realTableName.toLowerCase()) == -1) continue;
            if ("as".equals(sqlChips[i + 1].toLowerCase())) {
                regex = realTableName.concat("\\s+as\\s+").concat(sqlChips[i + 2]);
                replaceStr = realTableName.concat(" as ").concat(sqlChips[i + 2]);
                break;
            }
            if ("where".equals(sqlChips[i + 2].toLowerCase())) {
                regex = realTableName.concat("\\s+").concat(sqlChips[i + 1]);
                replaceStr = realTableName.concat(" ").concat(sqlChips[i + 1]);
                break;
            }
            if (",".equals(sqlChips[i + 2])) {
                regex = realTableName.concat("\\s+").concat(sqlChips[i + 1]).concat(",");
                replaceStr = realTableName.concat(" ").concat(sqlChips[i + 1]);
                break;
            }
            if (i + 3 >= chipSize || !"join".equals(sqlChips[i + 3].toLowerCase())) continue;
            regex = realTableName.concat("\\s+").concat(sqlChips[i + 1]);
            replaceStr = realTableName.concat(" ").concat(sqlChips[i + 1]);
            break;
        }
        switch (lockMode) {
            case UPGRADE: {
                loadSql = selectPart.concat(fromPart.replaceFirst("(?i)".concat(regex), replaceStr.replace(",", "").concat(" with (rowlock xlock) ").concat(regex.endsWith(",") ? "," : "")));
                break;
            }
            case UPGRADE_NOWAIT: 
            case UPGRADE_SKIPLOCK: {
                loadSql = selectPart.concat(fromPart.replaceFirst("(?i)".concat(regex), replaceStr.replace(",", "").concat(" with (rowlock readpast) ").concat(regex.endsWith(",") ? "," : "")));
            }
        }
        return loadSql;
    }

    public static List<TableMeta> getTables(String catalog, String schema, final String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        String sql = "select d.name TABLE_NAME, cast(isnull(f.value,'') as varchar(1000)) COMMENTS,d.xtype TABLE_TYPE from syscolumns a \t\t inner join sysobjects d on a.id=d.id and d.xtype in ('U','V') and d.name<>'dtproperties' \t\t left join sys.extended_properties f on d.id=f.major_id and f.minor_id=0 \t\t where a.colorder=1 ";
        if (StringUtil.isNotBlank(tableName)) {
            sql = sql.concat(" and d.name like ?");
        }
        PreparedStatement pst = conn.prepareStatement(sql);
        ResultSet rs = null;
        return (List)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                if (StringUtil.isNotBlank(tableName)) {
                    if (tableName.contains("%")) {
                        pst.setString(1, tableName);
                    } else {
                        pst.setString(1, "%" + tableName + "%");
                    }
                }
                rs = pst.executeQuery();
                ArrayList<TableMeta> tables = new ArrayList<TableMeta>();
                while (rs.next()) {
                    TableMeta tableMeta = new TableMeta();
                    tableMeta.setTableName(rs.getString("TABLE_NAME"));
                    tableMeta.setType(rs.getString("TABLE_TYPE"));
                    if ("V".equals(tableMeta.getType())) {
                        tableMeta.setType("VIEW");
                    } else {
                        tableMeta.setType("TABLE");
                    }
                    tableMeta.setRemarks(rs.getString("COMMENTS"));
                    tables.add(tableMeta);
                }
                this.setResult(tables);
            }
        });
    }

    public static List<ColumnMeta> getTableColumns(String catalog, String schema, final String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        List<ColumnMeta> tableColumns = DefaultDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
        String sql = "SELECT a.name COLUMN_NAME,\t\t\t\t cast(isnull(g.[value],'') as varchar(1000)) as COMMENTS \t\t\t\t FROM syscolumns a  inner join sysobjects d on a.id=d.id \t\t\t\t and d.xtype='U' and d.name<>'dtproperties' \t\t\t\t left join syscomments e on a.cdefault=e.id\t\t\t\t left join sys.extended_properties g \t\t\t\t on a.id=g.major_id AND a.colid = g.minor_id   where d.name=?    order by a.id,a.colorder";
        PreparedStatement pst = conn.prepareStatement(sql);
        ResultSet rs = null;
        Map colMap = (Map)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                pst.setString(1, tableName);
                rs = pst.executeQuery();
                HashMap<String, String> colComments = new HashMap<String, String>();
                while (rs.next()) {
                    String comment = rs.getString("COMMENTS");
                    if (comment == null) continue;
                    colComments.put(rs.getString("COLUMN_NAME").toUpperCase(), comment);
                }
                this.setResult(colComments);
            }
        });
        for (ColumnMeta col : tableColumns) {
            col.setComments((String)colMap.get(col.getColName().toUpperCase()));
        }
        return tableColumns;
    }

    private static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
            return true;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }
}

