/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.sagacity.sqltoy.config.annotation.Entity;
import org.sagacity.sqltoy.config.annotation.SqlToyEntity;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanEntityAndSqlResource {
    protected static final Logger logger = LoggerFactory.getLogger(ScanEntityAndSqlResource.class);
    private static final String SQLTOY_SQL_FILE_SUFFIX = ".sql.xml";
    private static final String CLASSPATH = "classpath:";
    private static final String JAR = "jar";

    @Deprecated
    public static Set<Class<?>> getPackageEntities(String pack, boolean recursive, String charset) {
        LinkedHashSet entities = new LinkedHashSet();
        String packageName = pack.trim();
        if (packageName.length() > 0 && packageName.charAt(0) == '/') {
            packageName = packageName.substring(1);
        }
        if (packageName.endsWith("/")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        packageName = packageName.replace("/", ".");
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), charset == null ? "UTF-8" : charset);
                    ScanEntityAndSqlResource.addEntitiesInPackage(packageName, filePath, recursive, entities);
                    continue;
                }
                if (!JAR.equals(protocol)) continue;
                logger.debug("jar\u7c7b\u578b\u7684\u626b\u63cf,\u52a0\u8f7dPOJO\u5b9e\u4f53bean");
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith(packageDirName) || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String loadClass = name.substring(0, name.length() - 6).replace("/", ".");
                        try {
                            Class<?> entityClass = Thread.currentThread().getContextClassLoader().loadClass(loadClass);
                            if (!ScanEntityAndSqlResource.isSqlToyEntity(entityClass)) continue;
                            entities.add(entityClass);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return entities;
    }

    @Deprecated
    public static void addEntitiesInPackage(String packageName, String packagePath, final boolean recursive, Set<Class<?>> entities) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ScanEntityAndSqlResource.addEntitiesInPackage(packageName.concat(".").concat(file.getName()), file.getAbsolutePath(), recursive, entities);
                continue;
            }
            String className = file.getName();
            className = className.substring(0, className.length() - 6);
            try {
                Class<?> entityClass = Thread.currentThread().getContextClassLoader().loadClass(packageName.concat(".").concat(className));
                if (!ScanEntityAndSqlResource.isSqlToyEntity(entityClass)) continue;
                entities.add(entityClass);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isSqlToyEntity(Class entityClass) {
        if (entityClass.isAnnotationPresent(SqlToyEntity.class)) {
            return true;
        }
        return entityClass.isAnnotationPresent(Entity.class) && !Modifier.isAbstract(entityClass.getModifiers());
    }

    public static List getSqlResources(String resourceDir, List<String> mappingResources) throws Exception {
        URL url;
        Enumeration<URL> urls;
        String realRes;
        ArrayList<Object> result = new ArrayList<Object>();
        boolean startClasspath = false;
        if (StringUtil.isNotBlank(resourceDir)) {
            String[] dirSet;
            for (String dir : dirSet = resourceDir.replaceAll("\\\uff1b", ",").replaceAll("\\\uff0c", ",").replaceAll("\\;", ",").split("\\,")) {
                realRes = dir.trim();
                startClasspath = false;
                if (realRes.toLowerCase().startsWith(CLASSPATH)) {
                    realRes = realRes.substring(10).trim();
                    startClasspath = true;
                }
                if ((urls = ScanEntityAndSqlResource.getResourceUrls(realRes, startClasspath)) == null) continue;
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    if (url.getProtocol().equals(JAR)) {
                        if (realRes.length() > 0 && realRes.charAt(0) == '/') {
                            realRes = realRes.substring(1);
                        }
                        JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String sqlFile = entry.getName();
                            if (!sqlFile.startsWith(realRes) || !sqlFile.toLowerCase().endsWith(SQLTOY_SQL_FILE_SUFFIX) || entry.isDirectory()) continue;
                            result.add(0, sqlFile);
                        }
                        continue;
                    }
                    ScanEntityAndSqlResource.getPathFiles(new File(url.toURI()), result);
                }
            }
        }
        if (mappingResources != null && !mappingResources.isEmpty()) {
            for (int i = 0; i < mappingResources.size(); ++i) {
                realRes = mappingResources.get(i).trim();
                if (!realRes.toLowerCase().endsWith(SQLTOY_SQL_FILE_SUFFIX)) continue;
                startClasspath = false;
                if (realRes.toLowerCase().startsWith(CLASSPATH)) {
                    realRes = realRes.substring(10).trim();
                    startClasspath = true;
                }
                if (null == (urls = ScanEntityAndSqlResource.getResourceUrls(realRes, startClasspath))) continue;
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    if (realRes.length() > 0 && realRes.charAt(0) == '/') {
                        realRes = realRes.substring(1);
                    }
                    if (url.getProtocol().equals(JAR)) {
                        if (result.contains(realRes)) continue;
                        result.add(0, realRes);
                        continue;
                    }
                    File file = new File(url.toURI());
                    if (result.contains(file)) continue;
                    result.add(file);
                }
            }
        }
        return result;
    }

    public static Enumeration<URL> getResourceUrls(String resource, boolean startClasspath) throws Exception {
        Enumeration<URL> urls = null;
        if (null == resource) {
            return urls;
        }
        if (!startClasspath) {
            File file = new File(resource);
            if (file.exists()) {
                Vector<URL> v = new Vector<URL>();
                v.add(file.toURI().toURL());
                urls = v.elements();
            } else {
                if (resource.length() > 0 && resource.charAt(0) == '/') {
                    resource = resource.substring(1);
                }
                urls = Thread.currentThread().getContextClassLoader().getResources(resource);
            }
        } else {
            if (resource.length() > 0 && resource.charAt(0) == '/') {
                resource = resource.substring(1);
            }
            urls = Thread.currentThread().getContextClassLoader().getResources(resource);
        }
        return urls;
    }

    private static void getPathFiles(File parentFile, List fileList) {
        if (null == parentFile) {
            return;
        }
        String fileName = parentFile.getName();
        if (parentFile.isDirectory()) {
            File[] files = parentFile.listFiles();
            for (int loop = 0; loop < files.length; ++loop) {
                File file = files[loop];
                fileName = file.getName();
                if (!file.isDirectory() && fileName.toLowerCase().endsWith(SQLTOY_SQL_FILE_SUFFIX)) {
                    fileList.add(file);
                    continue;
                }
                ScanEntityAndSqlResource.getPathFiles(files[loop], fileList);
            }
        } else if (fileName.toLowerCase().endsWith(SQLTOY_SQL_FILE_SUFFIX)) {
            fileList.add(parentFile);
        }
    }
}

