/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OSBTreeBonsaiRemote;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerRemote
extends OSBTreeCollectionManagerAbstract
implements OOrientStartupListener,
OOrientShutdownListener {
    private final OCollectionNetworkSerializer networkSerializer;
    private boolean remoteCreationAllowed = false;
    private volatile ThreadLocal<Map<UUID, WeakReference<ORidBag>>> pendingCollections = new PendingCollectionsThreadLocal();

    public OSBTreeCollectionManagerRemote() {
        this.networkSerializer = new OCollectionNetworkSerializer();
        Orient.instance().registerWeakOrientStartupListener((OOrientStartupListener)this);
        Orient.instance().registerWeakOrientShutdownListener((OOrientShutdownListener)this);
    }

    public OSBTreeCollectionManagerRemote(OCollectionNetworkSerializer networkSerializer) {
        this.networkSerializer = networkSerializer;
        Orient.instance().registerWeakOrientStartupListener((OOrientStartupListener)this);
        Orient.instance().registerWeakOrientShutdownListener((OOrientShutdownListener)this);
    }

    public void onShutdown() {
        this.pendingCollections = null;
    }

    public void onStartup() {
        if (this.pendingCollections == null) {
            this.pendingCollections = new PendingCollectionsThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OSBTreeBonsaiRemote<OIdentifiable, Integer> createTree(int clusterId) {
        if (this.remoteCreationAllowed) {
            OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
            OChannelBinaryAsynchClient client = null;
            while (true) {
                try {
                    OBonsaiCollectionPointer pointer;
                    client = storage.beginRequest((byte)110);
                    client.writeInt(clusterId);
                    storage.endRequest(client);
                    try {
                        storage.beginResponse(client);
                        pointer = this.networkSerializer.readCollectionPointer((OChannelBinary)client);
                    }
                    finally {
                        storage.endResponse(client);
                    }
                    OLinkSerializer keySerializer = OLinkSerializer.INSTANCE;
                    OIntegerSerializer valueSerializer = OIntegerSerializer.INSTANCE;
                    return new OSBTreeBonsaiRemote<OIdentifiable, Integer>(pointer, (OBinarySerializer<OIdentifiable>)keySerializer, (OBinarySerializer<Integer>)valueSerializer);
                }
                catch (Exception e2) {
                    storage.handleException(client, "Can't create sb-tree bonsai.", e2);
                    continue;
                }
                break;
            }
        }
        throw new UnsupportedOperationException("Creation of SB-Tree from remote storage is not allowed");
    }

    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        OLinkSerializer keySerializer = OLinkSerializer.INSTANCE;
        OIntegerSerializer valueSerializer = OIntegerSerializer.INSTANCE;
        return new OSBTreeBonsaiRemote<OIdentifiable, Integer>(collectionPointer, (OBinarySerializer<OIdentifiable>)keySerializer, (OBinarySerializer<Integer>)valueSerializer);
    }

    public UUID listenForChanges(ORidBag collection) {
        UUID id = collection.getTemporaryId();
        if (id == null) {
            id = UUID.randomUUID();
        }
        this.pendingCollections.get().put(id, new WeakReference<ORidBag>(collection));
        return id;
    }

    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
        WeakReference<ORidBag> reference = this.pendingCollections.get().get(uuid);
        if (reference == null) {
            OLogManager.instance().warn((Object)this, "Update of collection pointer is received but collection is not registered", new Object[0]);
            return;
        }
        ORidBag collection = (ORidBag)reference.get();
        if (collection != null) {
            collection.notifySaved(pointer);
        }
    }

    public void clearPendingCollections() {
        this.pendingCollections.get().clear();
    }

    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        throw new UnsupportedOperationException();
    }

    public void clearChangedIds() {
        throw new UnsupportedOperationException();
    }

    private static class PendingCollectionsThreadLocal
    extends ThreadLocal<Map<UUID, WeakReference<ORidBag>>> {
        private PendingCollectionsThreadLocal() {
        }

        @Override
        protected Map<UUID, WeakReference<ORidBag>> initialValue() {
            return new HashMap<UUID, WeakReference<ORidBag>>();
        }
    }
}

