/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import oracle.net.aso.AESEncryption;
import oracle.net.aso.AsoException;
import oracle.net.ns.NetException;

public interface EncryptionAlgorithm {
    public static final int NAE_40_KEY_SIZE_BITS = 40;
    public static final int NAE_56_KEY_SIZE_BITS = 56;
    public static final int NAE_128_KEY_SIZE_BITS = 128;
    public static final int NAE_256_KEY_SIZE_BITS = 256;
    public static final int NAE_CBC_0 = 1;
    public static final int NAE_CBC_8 = 2;
    public static final int NAE_RAW_0 = 3;
    public static final int NAE_RAW_8 = 4;
    public static final int ENC_NULL_ALG = 0;
    public static final int RC4_40 = 140;
    public static final int RC4_56 = 141;
    public static final int RC4_128 = 142;
    public static final int RC4_256 = 143;
    public static final int DES_40_RAW_0 = 210;
    public static final int DES_56_RAW_0 = 211;
    public static final int DES_40_RAW_8 = 212;
    public static final int DES_56_RAW_8 = 213;
    public static final int DES_40_CBC_0 = 220;
    public static final int DES_56_CBC_0 = 221;
    public static final int DES_40_CBC_8 = 222;
    public static final int DES_56_CBC_8 = 223;
    public static final int BYTE_OPER_AND = 1;
    public static final int BYTE_OPER_XOR = 2;
    public static final int BYTE_OPER_MOV = 3;
    public static final int STRONG_KEY_SIZE = 32;
    public static final int STRONG_KEY_DH_OFFSET = 0;
    public static final int STRONG_IV_SIZE = 32;
    public static final int STRONG_IV_DH_OFFSET = 32;

    public static EncryptionAlgorithm newInstance(String algorithmName, byte[] key, byte[] iv, boolean allowWeakCrypto) throws AsoException, NetException {
        AESEncryption algortihmInstance = switch (algorithmName) {
            case "AES128" -> new AESEncryption(1, 1, 1, allowWeakCrypto);
            case "AES192" -> new AESEncryption(1, 2, 1, allowWeakCrypto);
            case "AES256" -> new AESEncryption(1, 3, 1, allowWeakCrypto);
            default -> throw new NetException(18917);
        };
        algortihmInstance.init(key, iv);
        return algortihmInstance;
    }

    public static void byteOperation(byte[] dest, byte[] oper1, byte[] oper2, int opertype, int length) {
        if (opertype == 1) {
            for (int i = 0; i < length; ++i) {
                dest[i] = (byte)(oper1[i] & oper2[i]);
            }
        } else if (opertype == 2) {
            for (int i = 0; i < length; ++i) {
                dest[i] = (byte)(oper1[i] ^ oper2[i]);
            }
        } else if (opertype == 3) {
            System.arraycopy(oper1, 0, dest, 0, length);
        }
    }

    public void init(byte[] var1, byte[] var2) throws AsoException;

    public byte[] decrypt(byte[] var1) throws AsoException;

    public byte[] encrypt(byte[] var1) throws AsoException;

    public int maxDelta();

    public void setSessionKey(byte[] var1, byte[] var2) throws AsoException;

    public String getProviderName();

    default public void renewKey() throws AsoException {
        throw new RuntimeException("Unsupported Operation");
    }
}

