/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.testing.drivers;

import com.google.common.base.Supplier;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.testing.drivers.TestDriver;
import com.opera.core.systems.testing.drivers.TestDriverSupplier;
import com.opera.core.systems.testing.drivers.TestOperaDesktopDriverSupplier;
import com.opera.core.systems.testing.drivers.TestOperaDriverSupplier;
import com.opera.core.systems.testing.drivers.TestOperaMobileDriverSupplier;
import java.util.logging.Level;
import org.openqa.selenium.Capabilities;

public class TestDriverBuilder
implements Supplier<TestDriver> {
    public static final String TEST_PRODUCT_OPTION_KEY = "selenium.browser.product";
    private Class<? extends TestDriver> driverClass = null;
    private TestDriverSupplier driverSupplier;
    private OperaSettings settings = new OperaSettings();
    private Level loggingLevel = null;

    public TestDriverBuilder() {
        this(TestDriverBuilder.detect());
    }

    public TestDriverBuilder(TestDriverSupplier supplier) {
        this.driverSupplier = supplier;
    }

    public TestDriverBuilder using(OperaSettings settings) {
        this.settings = settings;
        return this;
    }

    public TestDriverBuilder using(Capabilities capabilities) {
        this.settings = new OperaSettings().merge(capabilities);
        return this;
    }

    public TestDriverBuilder modifyLogLevel(Level level) {
        this.loggingLevel = level;
        return this;
    }

    public TestDriver get() {
        if (this.loggingLevel != null) {
            this.settings.logging().setLevel(this.loggingLevel);
        }
        this.driverSupplier.setSettings(this.settings);
        TestDriver driver = (TestDriver)this.driverSupplier.get();
        return driver;
    }

    public static TestDriverSupplier detect() {
        OperaProduct product = OperaProduct.get(System.getProperty(TEST_PRODUCT_OPTION_KEY));
        switch (product) {
            case DESKTOP: {
                return new TestOperaDesktopDriverSupplier();
            }
            case MOBILE: {
                return new TestOperaMobileDriverSupplier();
            }
        }
        return new TestOperaDriverSupplier();
    }
}

