/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.protos.CookieMngProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.CookieManager;
import com.opera.core.systems.scope.stp.services.messages.CookieManagerMessage;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Cookie;

public class ScopeCookieManager
extends AbstractService
implements CookieManager {
    private int maxCookies;
    private int maxCookiesPerDomain;
    private int maxCookieLength;

    public ScopeCookieManager(ScopeServices services) {
        super(services, "cookie-manager");
        services.setCookieManager(this);
    }

    @Override
    public void init() {
        CookieMngProtos.CookieSettings settings = this.getCookieSettings();
        this.maxCookies = settings.getMaxCookies();
        this.maxCookiesPerDomain = settings.getMaxCookiesPerDomain();
        this.maxCookieLength = settings.getMaxCookieLength();
    }

    @Override
    public int getMaxCookies() {
        return this.maxCookies;
    }

    @Override
    public int getMaxCookiesPerDomain() {
        return this.maxCookiesPerDomain;
    }

    @Override
    public int getMaxCookieLength() {
        return this.maxCookieLength;
    }

    @Override
    public Set<Cookie> getCookie(String domain, String path) {
        Preconditions.checkNotNull((Object)domain, (Object)"Domain cannot be null");
        CookieMngProtos.GetCookieArg.Builder arg = CookieMngProtos.GetCookieArg.newBuilder();
        arg.setDomain(domain);
        if (path != null) {
            arg.setPath(path);
        }
        UmsProtos.Response response = this.executeMessage(CookieManagerMessage.GET_COOKIE, (AbstractMessage.Builder<?>)arg);
        CookieMngProtos.CookieList.Builder builder = CookieMngProtos.CookieList.newBuilder();
        ScopeCookieManager.buildPayload(response, builder);
        CookieMngProtos.CookieList list = builder.build();
        List<CookieMngProtos.Cookie> cookies = list.getCookieListList();
        HashSet result = Sets.newHashSet();
        for (CookieMngProtos.Cookie cookie : cookies) {
            result.add(new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), new Date(cookie.getExpires()), cookie.getIsSecure()));
        }
        return result;
    }

    @Override
    public void removeCookie(String domain, String path, String name) {
        if (domain == null) {
            throw new NullPointerException("Domain can not be null");
        }
        CookieMngProtos.RemoveCookieArg.Builder arg = CookieMngProtos.RemoveCookieArg.newBuilder();
        arg.setDomain(domain);
        if (path != null) {
            arg.setPath(path);
        }
        if (name != null) {
            arg.setName(name);
        }
        this.executeMessage(CookieManagerMessage.REMOVE_COOKIE, (AbstractMessage.Builder<?>)arg);
    }

    @Override
    public void removeAllCookies() {
        this.executeMessage(CookieManagerMessage.REMOVE_ALL_COOKIES, null);
    }

    private CookieMngProtos.CookieSettings getCookieSettings() {
        UmsProtos.Response response = this.executeMessage(CookieManagerMessage.GET_COOKIE_SETTINGS, null);
        CookieMngProtos.CookieSettings.Builder builder = CookieMngProtos.CookieSettings.newBuilder();
        ScopeCookieManager.buildPayload(response, builder);
        return builder.build();
    }
}

