/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.pdfboxout.BookmarkElement;
import com.openhtmltopdf.pdfboxout.PdfBoxImageElement;
import com.openhtmltopdf.pdfboxout.PdfBoxObjectDrawerReplacedElement;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxPDFReplacedElement;
import com.openhtmltopdf.pdfboxout.PdfBoxSVGReplacedElement;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.util.ImageUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Element;

public class PdfBoxReplacedElementFactory
implements ReplacedElementFactory {
    private final SVGDrawer _svgImpl;
    private final SVGDrawer _mathmlImpl;
    private final FSObjectDrawerFactory _objectDrawerFactory;
    private final PdfBoxOutputDevice _outputDevice;

    public PdfBoxReplacedElementFactory(PdfBoxOutputDevice outputDevice, SVGDrawer svgImpl, FSObjectDrawerFactory objectDrawerFactory, SVGDrawer mathmlImpl) {
        this._outputDevice = outputDevice;
        this._svgImpl = svgImpl;
        this._objectDrawerFactory = objectDrawerFactory;
        this._mathmlImpl = mathmlImpl;
    }

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("math") && this._mathmlImpl != null) {
            return new PdfBoxSVGReplacedElement(e, this._mathmlImpl, cssWidth, cssHeight, (Box)box, (CssContext)c, c.getSharedContext());
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return new PdfBoxSVGReplacedElement(e, this._svgImpl, cssWidth, cssHeight, (Box)box, (CssContext)c, c.getSharedContext());
        }
        if (nodeName.equals("img")) {
            String srcAttr = e.getAttribute("src");
            if (srcAttr != null && srcAttr.length() > 0) {
                boolean isDataImageSvg = false;
                if (this._svgImpl != null && (srcAttr.endsWith(".svg") || (isDataImageSvg = srcAttr.startsWith("data:image/svg+xml;base64,")))) {
                    XMLResource xml;
                    XMLResource xMLResource = xml = isDataImageSvg ? XMLResource.load((InputStream)new ByteArrayInputStream(ImageUtil.getEmbeddedBase64Image((String)srcAttr))) : uac.getXMLResource(srcAttr);
                    if (xml != null) {
                        return new PdfBoxSVGReplacedElement(xml.getDocument().getDocumentElement(), this._svgImpl, cssWidth, cssHeight, (Box)box, (CssContext)c, c.getSharedContext());
                    }
                    return null;
                }
                if (srcAttr.endsWith(".pdf")) {
                    byte[] pdfBytes = uac.getBinaryResource(srcAttr);
                    if (pdfBytes != null) {
                        return PdfBoxPDFReplacedElement.create(this._outputDevice.getWriter(), pdfBytes, e, (Box)box, (CssContext)c, c.getSharedContext());
                    }
                    return null;
                }
                FSImage fsImage = uac.getImageResource(srcAttr).getImage();
                if (fsImage != null) {
                    return new PdfBoxImageElement(e, fsImage, c.getSharedContext(), box.getStyle().isImageRenderingInterpolate());
                }
            }
        } else if (!nodeName.equals("input")) {
            FSObjectDrawer drawer;
            if (nodeName.equals("bookmark")) {
                BookmarkElement result = new BookmarkElement();
                if (e.hasAttribute("name")) {
                    String name = e.getAttribute("name");
                    c.addBoxId(name, (Box)box);
                    result.setAnchorName(name);
                }
                return result;
            }
            if (nodeName.equals("object") && this._objectDrawerFactory != null && (drawer = this._objectDrawerFactory.createDrawer(e)) != null) {
                return new PdfBoxObjectDrawerReplacedElement(e, drawer, cssWidth, cssHeight, c.getSharedContext());
            }
        }
        return null;
    }

    public boolean isReplacedElement(Element e) {
        if (e == null) {
            return false;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("img")) {
            return true;
        }
        if (nodeName.equals("math") && this._mathmlImpl != null) {
            return true;
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return true;
        }
        if (nodeName.equals("bookmark")) {
            return true;
        }
        if (nodeName.equals("object") && this._objectDrawerFactory != null) {
            return this._objectDrawerFactory.isReplacedObject(e);
        }
        return false;
    }
}

