/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.FSFunction;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentPropertyBuilder
extends AbstractPropertyBuilder {
    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        if (values.size() == 1) {
            IdentValue ident;
            PropertyValue value = values.get(0);
            if (value.getCssValueType() == 0) {
                return Collections.emptyList();
            }
            if (value.getPrimitiveType() == 21 && ((ident = this.checkIdent(CSSName.CONTENT, value)) == IdentValue.NONE || ident == IdentValue.NORMAL)) {
                return Collections.singletonList(new PropertyDeclaration(CSSName.CONTENT, value, important, origin));
            }
        }
        ArrayList<PropertyValue> resultValues = new ArrayList<PropertyValue>();
        for (PropertyValue value : values) {
            if (value.getOperator() != null) {
                throw new CSSParseException("Found unexpected operator, " + value.getOperator().getExternalName(), -1);
            }
            short type = value.getPrimitiveType();
            if (type == 20) continue;
            if (type == 19) {
                resultValues.add(value);
                continue;
            }
            if (value.getPropertyValueType() == 7) {
                if (!this.isFunctionAllowed(value.getFunction())) {
                    throw new CSSParseException("Function " + value.getFunction().getName() + " is not allowed here", -1);
                }
                resultValues.add(value);
                continue;
            }
            if (type == 21) {
                IdentValue ident = this.checkIdent(CSSName.CONTENT, value);
                if (ident == IdentValue.OPEN_QUOTE || ident == IdentValue.CLOSE_QUOTE || ident == IdentValue.NO_CLOSE_QUOTE || ident == IdentValue.NO_OPEN_QUOTE) {
                    resultValues.add(value);
                    continue;
                }
                throw new CSSParseException("Identifier " + ident + " is not a valid value for the content property", -1);
            }
            throw new CSSParseException(value.getCssText() + " is not a value value for the content property", -1);
        }
        if (resultValues.size() > 0) {
            return Collections.singletonList(new PropertyDeclaration(CSSName.CONTENT, new PropertyValue(resultValues), important, origin));
        }
        return Collections.emptyList();
    }

    private boolean isFunctionAllowed(FSFunction function) {
        String name = function.getName();
        return name.equals("attr") || name.equals("counter") || name.equals("counters") || name.equals("element") || name.startsWith("-fs") || name.equals("target-counter") || name.equals("leader");
    }
}

