/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.asn1.ASN1Structured;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeTypeAndValues;
import com.novell.ldap.rfc2251.RfcAttributeValue;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcModifyRequest;
import java.io.IOException;

public class LDAPModifyRequest
extends LDAPMessage {
    public LDAPModifyRequest() {
        super(6);
    }

    public LDAPModifyRequest(String string, LDAPModification[] lDAPModificationArray, LDAPControl[] lDAPControlArray) throws LDAPException {
        super(6, new RfcModifyRequest(new RfcLDAPDN(string), LDAPModifyRequest.encodeModifications(lDAPModificationArray)), lDAPControlArray);
    }

    private static final ASN1SequenceOf encodeModifications(LDAPModification[] lDAPModificationArray) {
        ASN1SequenceOf aSN1SequenceOf = new ASN1SequenceOf(lDAPModificationArray.length);
        for (int i = 0; i < lDAPModificationArray.length; ++i) {
            Object object;
            LDAPAttribute lDAPAttribute = lDAPModificationArray[i].getAttribute();
            ASN1SetOf aSN1SetOf = new ASN1SetOf(lDAPAttribute.size());
            if (lDAPAttribute.size() > 0) {
                object = lDAPAttribute.getByteValues();
                while (object.hasMoreElements()) {
                    aSN1SetOf.add(new RfcAttributeValue((byte[])object.nextElement()));
                }
            }
            object = new ASN1Sequence(2);
            ((ASN1Structured)object).add(new ASN1Enumerated(lDAPModificationArray[i].getOp()));
            ((ASN1Structured)object).add(new RfcAttributeTypeAndValues(new RfcAttributeDescription(lDAPAttribute.getName()), aSN1SetOf));
            aSN1SequenceOf.add((ASN1Object)object);
        }
        return aSN1SequenceOf;
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    public LDAPModification[] getModifications() {
        RfcModifyRequest rfcModifyRequest = (RfcModifyRequest)this.getASN1Object().getRequest();
        ASN1SequenceOf aSN1SequenceOf = rfcModifyRequest.getModifications();
        ASN1Object[] aSN1ObjectArray = aSN1SequenceOf.toArray();
        LDAPModification[] lDAPModificationArray = new LDAPModification[aSN1ObjectArray.length];
        for (int i = 0; i < aSN1ObjectArray.length; ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1ObjectArray[i];
            if (aSN1Sequence.size() != 2) {
                throw new RuntimeException("LDAPModifyRequest: modification " + i + " is wrong size: " + aSN1Sequence.size());
            }
            ASN1Object[] aSN1ObjectArray2 = aSN1Sequence.toArray();
            ASN1Enumerated aSN1Enumerated = (ASN1Enumerated)aSN1ObjectArray2[0];
            int n = aSN1Enumerated.intValue();
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1ObjectArray2[1];
            ASN1Object[] aSN1ObjectArray3 = aSN1Sequence2.toArray();
            RfcAttributeDescription rfcAttributeDescription = (RfcAttributeDescription)aSN1ObjectArray3[0];
            String string = rfcAttributeDescription.stringValue();
            ASN1SetOf aSN1SetOf = (ASN1SetOf)aSN1ObjectArray3[1];
            ASN1Object[] aSN1ObjectArray4 = aSN1SetOf.toArray();
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string);
            for (int j = 0; j < aSN1ObjectArray4.length; ++j) {
                RfcAttributeValue rfcAttributeValue = (RfcAttributeValue)aSN1ObjectArray4[j];
                lDAPAttribute.addValue(rfcAttributeValue.byteValue());
            }
            lDAPModificationArray[i] = new LDAPModification(n, lDAPAttribute);
        }
        return lDAPModificationArray;
    }

    public String toString() {
        return this.getASN1Object().toString();
    }

    protected void setDeserializedValues(LDAPMessage lDAPMessage, RfcControls rfcControls) throws IOException, ClassNotFoundException {
        if (!(lDAPMessage instanceof LDAPModifyRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPModifyRequest object");
        }
        LDAPModifyRequest lDAPModifyRequest = (LDAPModifyRequest)lDAPMessage;
        String string = lDAPModifyRequest.getDN();
        LDAPModification[] lDAPModificationArray = lDAPModifyRequest.getModifications();
        lDAPModifyRequest = null;
        RfcModifyRequest rfcModifyRequest = new RfcModifyRequest(new RfcLDAPDN(string), LDAPModifyRequest.encodeModifications(lDAPModificationArray));
        this.message = new RfcLDAPMessage(rfcModifyRequest, rfcControls);
        lDAPMessage = null;
    }
}

