/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaJerseyClient {
    public static JerseyClient createJerseyClient(int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, int connectionIdleTimeout) {
        try {
            CustomApacheHttpClientConfig jerseyClientConfig = new CustomApacheHttpClientConfig(maxConnectionsPerHost, maxTotalConnections);
            return new JerseyClient(connectionTimeout, readTimeout, maxConnectionsPerHost, maxTotalConnections, connectionIdleTimeout, (ClientConfig)jerseyClientConfig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create Jersey client ", e);
        }
    }

    public static JerseyClient createSSLJerseyClient(int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, int connectionIdleTimeout, String trustStoreFileName, String trustStorePassword) {
        try {
            SSLCustomApacheHttpClientConfig jerseyClientConfig = new SSLCustomApacheHttpClientConfig(maxConnectionsPerHost, maxTotalConnections, trustStoreFileName, trustStorePassword);
            return new JerseyClient(connectionTimeout, readTimeout, maxConnectionsPerHost, maxTotalConnections, connectionIdleTimeout, (ClientConfig)jerseyClientConfig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create SSL Jersey client ", e);
        }
    }

    private static TrustManager[] createTrustManagers(KeyStore trustStore) {
        TrustManagerFactory factory = null;
        try {
            factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(trustStore);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        TrustManager[] managers = factory.getTrustManagers();
        return managers;
    }

    public static class JerseyClient {
        private static final int HTTP_CONNECTION_CLEANER_INTERVAL_MS = 30000;
        private ApacheHttpClient4 apacheHttpClient;
        ClientConfig jerseyClientConfig;
        private Timer eurekaConnCleaner = new Timer("Eureka-connectionCleaner", true);
        private static final Logger s_logger = LoggerFactory.getLogger(JerseyClient.class);

        public ApacheHttpClient4 getClient() {
            return this.apacheHttpClient;
        }

        public ClientConfig getClientconfig() {
            return this.jerseyClientConfig;
        }

        public JerseyClient(int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, final int connectionIdleTimeout, ClientConfig clientConfig) {
            try {
                this.jerseyClientConfig = clientConfig;
                this.jerseyClientConfig.getClasses().add(DiscoveryJerseyProvider.class);
                this.apacheHttpClient = ApacheHttpClient4.create((ClientConfig)this.jerseyClientConfig);
                HttpParams params = this.apacheHttpClient.getClientHandler().getHttpClient().getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
                this.eurekaConnCleaner.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            JerseyClient.this.apacheHttpClient.getClientHandler().getHttpClient().getConnectionManager().closeIdleConnections((long)connectionIdleTimeout, TimeUnit.SECONDS);
                        }
                        catch (Throwable e) {
                            s_logger.error("Cannot clean connections", e);
                        }
                    }
                }, 30000L, 30000L);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot create Jersey client", e);
            }
        }

        public void destroyResources() {
            if (this.eurekaConnCleaner != null) {
                this.eurekaConnCleaner.cancel();
            }
            if (this.apacheHttpClient != null) {
                this.apacheHttpClient.destroy();
            }
        }
    }

    private static class SSLCustomApacheHttpClientConfig
    extends DefaultApacheHttpClient4Config {
        private static final String PROTOCOL_SCHEME = "SSL";
        private static final int HTTPS_PORT = 443;
        private static final String PROTOCOL = "https";
        private static final String KEYSTORE_TYPE = "JKS";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SSLCustomApacheHttpClientConfig(int maxConnectionsPerHost, int maxTotalConnections, String trustStoreFileName, String trustStorePassword) throws Throwable {
            SSLContext sslContext = SSLContext.getInstance(PROTOCOL_SCHEME);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore sslKeyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(trustStoreFileName);
                sslKeyStore.load(fin, trustStorePassword.toCharArray());
                tmf.init(sslKeyStore);
                sslContext.init(null, EurekaJerseyClient.createTrustManagers(sslKeyStore), null);
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext);
                sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
                sslSchemeRegistry.register(new Scheme(PROTOCOL, 443, (SchemeSocketFactory)sslSocketFactory));
                ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(sslSchemeRegistry);
                cm.setDefaultMaxPerRoute(maxConnectionsPerHost);
                cm.setMaxTotal(maxTotalConnections);
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
            }
        }
    }

    private static class CustomApacheHttpClientConfig
    extends DefaultApacheHttpClient4Config {
        public CustomApacheHttpClientConfig(int maxConnectionsPerHost, int maxTotalConnections) throws Throwable {
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager();
            cm.setDefaultMaxPerRoute(maxConnectionsPerHost);
            cm.setMaxTotal(maxTotalConnections);
            this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
        }
    }
}

