/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.WebAppBasic;
import com.azure.resourcemanager.appservice.models.WebApps;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDraft;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppModule
extends AbstractAzResourceModule<WebApp, AppServiceServiceSubscription, WebSiteBase> {
    private static final Logger log;
    public static final String NAME = "sites";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public WebAppModule(@Nonnull AppServiceServiceSubscription parent) {
        super(NAME, (AbstractAzResource)parent);
    }

    public WebApps getClient() {
        return Optional.ofNullable((AppServiceManager)((AppServiceServiceSubscription)this.parent).getRemote(new boolean[0])).map(AppServiceManager::webApps).orElse(null);
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_create.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected WebAppDraft newDraftForCreate(@Nonnull String name, String resourceGroupName) {
        String string = name;
        String string2 = resourceGroupName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebAppDraft webAppDraft = new WebAppDraft(name, resourceGroupName, this);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_update.resource|type", params={"origin.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected WebAppDraft newDraftForUpdate(@Nonnull WebApp origin) {
        WebApp webApp = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)webApp);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebAppDraft webAppDraft = new WebAppDraft(origin);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected WebApp newResource(@Nonnull WebSiteBase remote) {
        return new WebApp((WebAppBasic)remote, this);
    }

    @Nonnull
    protected WebApp newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new WebApp(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Web app";
    }

    @NotNull
    public WebApp update(@NotNull AzResource.Draft<WebApp, WebSiteBase> draft) {
        log.debug("[{}]:update(draft:{})", (Object)this.getName(), draft);
        WebApp resource = (WebApp)this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.nonNull(resource) && Objects.nonNull(resource.getRemote(new boolean[0]))) {
            log.debug("[{}]:update->doModify(draft.updateResourceInAzure({}))", (Object)this.getName(), resource.getRemote(new boolean[0]));
            resource.doModify(() -> (WebSiteBase)draft.updateResourceInAzure((Object)((WebSiteBase)Objects.requireNonNull((com.azure.resourcemanager.appservice.models.WebApp)resource.getFullRemote()))), "Updating");
            return resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", draft.getName()));
    }

    static {
        WebAppModule.ajc$preClinit();
        log = LoggerFactory.getLogger(WebAppModule.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebAppModule.java", WebAppModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForCreate", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule", "java.lang.String:java.lang.String", "name:resourceGroupName", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDraft"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForUpdate", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppModule", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp", "origin", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppDraft"), 54);
    }
}

