/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

class RewriteTreeFilter
extends RevFilter {
    private static final int PARSED = 1;
    private static final int UNINTERESTING = 4;
    private static final int REWRITE = 8;
    private final TreeWalk pathFilter;
    private final Repository repository;

    RewriteTreeFilter(RevWalk walker, TreeFilter t) {
        this.repository = walker.repository;
        this.pathFilter = new TreeWalk(walker.reader);
        this.pathFilter.setFilter(t);
        this.pathFilter.setRecursive(t.shouldBeRecursive());
    }

    public RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    public boolean include(RevWalk walker, RevCommit c) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit[] pList = c.parents;
        int nParents = pList.length;
        TreeWalk tw = this.pathFilter;
        AnyObjectId[] trees = new ObjectId[nParents + 1];
        for (int i = 0; i < nParents; ++i) {
            RevCommit p = c.parents[i];
            if ((p.flags & 1) == 0) {
                p.parseHeaders(walker);
            }
            trees[i] = p.getTree();
        }
        trees[nParents] = c.getTree();
        tw.reset(trees);
        if (nParents == 1) {
            int chgs = 0;
            int adds = 0;
            while (tw.next()) {
                ++chgs;
                if (tw.getRawMode(0) != 0 || tw.getRawMode(1) == 0) break;
                ++adds;
            }
            if (chgs == 0) {
                c.flags |= 8;
                return false;
            }
            if (adds > 0 && tw.getFilter() instanceof FollowFilter) {
                this.updateFollowFilter((ObjectId[])trees);
            }
            return true;
        }
        if (nParents == 0) {
            if (tw.next()) {
                return true;
            }
            c.flags |= 8;
            return false;
        }
        int[] chgs = new int[nParents];
        int[] adds = new int[nParents];
        while (tw.next()) {
            int myMode = tw.getRawMode(nParents);
            for (int i = 0; i < nParents; ++i) {
                int pMode = tw.getRawMode(i);
                if (myMode == pMode && tw.idEqual(i, nParents)) continue;
                int n = i;
                chgs[n] = chgs[n] + 1;
                if (pMode != 0 || myMode == 0) continue;
                int n2 = i;
                adds[n2] = adds[n2] + 1;
            }
        }
        boolean same = false;
        boolean diff = false;
        for (int i = 0; i < nParents; ++i) {
            if (chgs[i] == 0) {
                RevCommit p = pList[i];
                if ((p.flags & 4) != 0) {
                    same = true;
                    continue;
                }
                c.flags |= 8;
                c.parents = new RevCommit[]{p};
                return false;
            }
            if (chgs[i] == adds[i]) {
                pList[i].parents = RevCommit.NO_PARENTS;
            }
            diff = true;
        }
        if (diff && !same) {
            return true;
        }
        c.flags |= 8;
        return false;
    }

    private void updateFollowFilter(ObjectId[] trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk tw = this.pathFilter;
        FollowFilter oldFilter = (FollowFilter)tw.getFilter();
        tw.setFilter(TreeFilter.ANY_DIFF);
        tw.reset(trees);
        List<DiffEntry> files = DiffEntry.scan(tw);
        RenameDetector rd = new RenameDetector(this.repository);
        rd.addAll(files);
        files = rd.compute();
        FollowFilter newFilter = oldFilter;
        for (DiffEntry ent : files) {
            if (!RewriteTreeFilter.isRename(ent) || !ent.getNewPath().equals(oldFilter.getPath())) continue;
            newFilter = FollowFilter.create(ent.getOldPath());
            break;
        }
        tw.setFilter(newFilter);
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }
}

