/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.FtpPlugin;
import org.webharvest.runtime.processors.plugins.FtpPluginException;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class FtpGetPlugin
extends WebHarvestPlugin {
    @Override
    public String getName() {
        return "ftp-get";
    }

    @Override
    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        FtpPlugin ftpPlugin = (FtpPlugin)scraper.getRunningProcessorOfType(FtpPlugin.class);
        if (ftpPlugin != null) {
            FTPClient ftpClient = ftpPlugin.getFtpClient();
            String path = CommonUtil.nvl(this.evaluateAttribute("path", scraper), "");
            this.setProperty("Path", path);
            try {
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                boolean succ = ftpClient.retrieveFile(path, (OutputStream)byteOutputStream);
                byteOutputStream.close();
                if (!succ) {
                    throw new FtpPluginException("Cannot retrieve file \"" + path + "\" from FTP server!");
                }
                byte[] bytes = byteOutputStream.toByteArray();
                return new NodeVariable(bytes);
            }
            catch (IOException e) {
                throw new FtpPluginException(e);
            }
        }
        throw new FtpPluginException("Cannot use ftp get plugin out of ftp plugin context!");
    }

    @Override
    public String[] getValidAttributes() {
        return new String[]{"path"};
    }

    @Override
    public String[] getRequiredAttributes() {
        return new String[]{"path"};
    }

    @Override
    public boolean hasBody() {
        return false;
    }
}

