/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.definition;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.webharvest.gui.ResourceManager;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.utils.CommonUtil;

public class ElementInfo {
    private static final Properties attrValuesProperties = ResourceManager.getAttrValuesProperties();
    private String name;
    private Class pluginClass;
    private boolean isInternalPlugin;
    private Class definitionClass;
    private String validTags;
    private String validAtts;
    private Set tagsSet = new TreeSet();
    private Set requiredTagsSet = new TreeSet();
    private Set attsSet = new TreeSet();
    private Set requiredAttsSet = new TreeSet();
    private boolean allTagsAllowed;
    private WebHarvestPlugin plugin = null;

    public ElementInfo(String name, Class definitionClass, String validTags, String validAtts) {
        this(name, null, true, definitionClass, validTags, validAtts);
    }

    public ElementInfo(String name, Class pluginClass, boolean isInternalPlugin, Class definitionClass, String validTags, String validAtts) {
        String token;
        StringTokenizer tokenizer;
        this.name = name;
        this.pluginClass = pluginClass;
        this.isInternalPlugin = isInternalPlugin;
        this.definitionClass = definitionClass;
        this.validTags = validTags;
        this.validAtts = validAtts;
        boolean bl = this.allTagsAllowed = validTags == null;
        if (validTags != null) {
            tokenizer = new StringTokenizer(validTags, ",");
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().toLowerCase();
                if (token.startsWith("!")) {
                    token = token.substring(1);
                    this.requiredTagsSet.add(token);
                }
                this.tagsSet.add(token);
            }
        }
        if (validAtts != null) {
            tokenizer = new StringTokenizer(validAtts, ",");
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().toLowerCase();
                if (token.startsWith("!")) {
                    token = token.substring(1);
                    this.requiredAttsSet.add(token);
                }
                this.attsSet.add(token);
            }
        }
    }

    public String getTemplate(boolean onlyRequiredAtts) {
        StringBuffer result = new StringBuffer("<" + this.name);
        Set atts = onlyRequiredAtts ? this.requiredAttsSet : this.attsSet;
        for (String att : atts) {
            result.append(" " + att + "=\"\"");
        }
        if (this.validTags != null && "".equals(this.validTags.trim())) {
            result.append("/>");
        } else {
            result.append("></" + this.name + ">");
        }
        return result.toString();
    }

    public Class getPluginClass() {
        return this.pluginClass;
    }

    public boolean isInternalPlugin() {
        return this.isInternalPlugin;
    }

    public Class getDefinitionClass() {
        return this.definitionClass;
    }

    public String getName() {
        return this.name;
    }

    public Set getTagsSet() {
        return this.tagsSet;
    }

    public Set getAttsSet() {
        return this.attsSet;
    }

    public Set getRequiredAttsSet() {
        return this.requiredAttsSet;
    }

    public Set getRequiredTagsSet() {
        return this.requiredTagsSet;
    }

    public boolean areAllTagsAllowed() {
        return this.allTagsAllowed;
    }

    public String[] getAttributeValueSuggestions(String attributeName) {
        if (this.plugin != null) {
            return this.plugin.getAttributeValueSuggestions(attributeName);
        }
        if (attrValuesProperties != null && attributeName != null) {
            String key = this.name.toLowerCase() + "." + attributeName.toLowerCase();
            String values = attrValuesProperties.getProperty(key);
            if ("*charset".equalsIgnoreCase(values)) {
                Set<String> charsetKeys = Charset.availableCharsets().keySet();
                return new ArrayList<String>(charsetKeys).toArray(new String[charsetKeys.size()]);
            }
            if ("*mime".equalsIgnoreCase(values)) {
                return ResourceManager.MIME_TYPES;
            }
            return CommonUtil.tokenize(values, ",");
        }
        return null;
    }

    public void setPlugin(WebHarvestPlugin plugin) {
        this.plugin = plugin;
    }
}

