/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

class XMLInputStream
extends InputStream {
    private Segment segment = new Segment();
    private Document document = null;
    private int end = 0;
    private int pos = 0;
    private int index = 0;

    public XMLInputStream(Document doc) {
        this.document = doc;
        this.end = this.document.getLength();
        this.pos = 0;
        try {
            this.loadSegment();
        }
        catch (IOException ioe) {
            throw new Error("unexpected: " + ioe);
        }
    }

    public void setRange(int start, int end) {
        this.end = end;
        this.pos = start;
        try {
            this.loadSegment();
        }
        catch (IOException ioe) {
            throw new Error("unexpected: " + ioe);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.segment.offset + this.segment.count) {
            if (this.pos >= this.end) {
                return -1;
            }
            this.loadSegment();
        }
        return this.segment.array[this.index++];
    }

    private void loadSegment() throws IOException {
        try {
            int n = Math.min(1024, this.end - this.pos);
            this.document.getText(this.pos, n, this.segment);
            this.pos += n;
            this.index = this.segment.offset;
        }
        catch (BadLocationException e) {
            throw new IOException("Bad location");
        }
    }
}

