/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.beans;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;

public final class QueryBean
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected final String queryLine;
    protected final String[] queryArray;
    protected final String id;

    public QueryBean() {
        this.id = null;
        this.queryLine = "";
        this.queryArray = new String[3];
    }

    public QueryBean(String queryLine) throws IOException {
        this(queryLine, null);
    }

    public QueryBean(String queryLine, String id) throws IOException {
        this.id = id;
        this.queryLine = queryLine;
        this.queryArray = QueryBean.decode(queryLine, 3);
    }

    private QueryBean(String[] queryArray, String id) {
        if (queryArray.length < 3) {
            throw new IllegalArgumentException("queryArray length is less than 3");
        }
        this.id = id;
        this.queryArray = (String[])queryArray.clone();
        this.queryLine = QueryBean.encode(queryArray);
    }

    public String getQueryLine() {
        return this.queryLine;
    }

    public String getQuery() {
        return this.queryArray[0];
    }

    public String getName() {
        return this.queryArray[1];
    }

    public String getDescription() {
        return this.queryArray[2];
    }

    public String getCSVQuery() {
        return this.queryLine;
    }

    public String[] toArray() {
        return this.queryArray;
    }

    public QueryBean setQuery(String value) {
        return this.create(value, 0);
    }

    public QueryBean setName(String value) {
        return this.create(value, 1);
    }

    public QueryBean setDescription(String value) {
        return this.create(value, 2);
    }

    private QueryBean create(String value, int pos) {
        String[] newArray = (String[])this.queryArray.clone();
        newArray[pos] = value;
        return new QueryBean(newArray, this.id);
    }

    static String[] decode(String line, int size) throws IOException {
        CSVParser csvParser = new CSVParser();
        String[] parseLine = csvParser.parseLine(line);
        String[] result = new String[size];
        for (int i = 0; i < parseLine.length; ++i) {
            result[i] = parseLine[i];
        }
        return result;
    }

    static String encode(String[] columns) {
        StringWriter writer = new StringWriter();
        CSVWriter csvwriter = new CSVWriter((Writer)writer, ',', '\"', '\"', "");
        csvwriter.writeNext(columns);
        return writer.toString();
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.queryLine == null ? 0 : this.queryLine.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryBean other = (QueryBean)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.queryLine == null ? other.queryLine != null : !this.queryLine.equals(other.queryLine));
    }
}

