/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr.treewalker;

import java.io.PrintStream;
import java.util.Stack;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;

public class SourcePrinter
extends VisitorAdapter {
    private String[] tokenNames;
    private int tabLevel;
    private int lastLinePrinted;
    private boolean newLines;
    protected PrintStream out;
    private String className;
    private Stack stack;
    private int stringConstructorCounter;

    public SourcePrinter(PrintStream out, String[] tokenNames) {
        this(out, tokenNames, true);
    }

    public SourcePrinter(PrintStream out, String[] tokenNames, boolean newLines) {
        this.tokenNames = tokenNames;
        this.tabLevel = 0;
        this.lastLinePrinted = 0;
        this.out = out;
        this.newLines = newLines;
        this.stack = new Stack();
    }

    public void visitAnnotation(GroovySourceAST t, int visit) {
        this.print(t, visit, "@", null, " ");
    }

    public void visitAnnotations(GroovySourceAST t, int visit) {
        if (t.getNumberOfChildren() > 0) {
            this.visitDefault(t, visit);
        }
    }

    public void visitAssign(GroovySourceAST t, int visit) {
        this.print(t, visit, " = ", null, null);
    }

    public void visitCaseGroup(GroovySourceAST t, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
        }
        if (visit == 2) {
            --this.tabLevel;
        }
    }

    public void visitClassDef(GroovySourceAST t, int visit) {
        this.print(t, visit, "class ", null, null);
        if (visit == 1) {
            this.className = t.childOfType(83).getText();
        }
    }

    public void visitClosedBlock(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "{", " -> ", "}");
    }

    public void visitCtorIdent(GroovySourceAST t, int visit) {
        this.print(t, visit, this.className, null, null);
    }

    public void visitDot(GroovySourceAST t, int visit) {
        this.print(t, visit, ".", null, null);
    }

    public void visitElist(GroovySourceAST t, int visit) {
        this.print(t, visit, null, ", ", null);
    }

    public void visitEqual(GroovySourceAST t, int visit) {
        this.print(t, visit, " == ", null, null);
    }

    public void visitExpr(GroovySourceAST t, int visit) {
    }

    public void visitExtendsClause(GroovySourceAST t, int visit) {
        if (visit == 1 && t.getNumberOfChildren() != 0) {
            this.print(t, visit, " extends ");
        }
    }

    public void visitForInIterable(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "(", " in ", ") ");
    }

    public void visitGt(GroovySourceAST t, int visit) {
        this.print(t, visit, " > ", null, null);
    }

    public void visitIdent(GroovySourceAST t, int visit) {
        this.print(t, visit, t.getText(), null, null);
    }

    public void visitImplementsClause(GroovySourceAST t, int visit) {
        if (visit == 1 && t.getNumberOfChildren() != 0) {
            this.print(t, visit, " implements ");
        }
        if (visit == 2) {
            this.print(t, visit, " ");
        }
    }

    public void visitImplicitParameters(GroovySourceAST t, int visit) {
    }

    public void visitImport(GroovySourceAST t, int visit) {
        this.print(t, visit, "import ", null, null);
    }

    public void visitIndexOp(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "[", null, "]");
    }

    public void visitLabeledArg(GroovySourceAST t, int visit) {
        this.print(t, visit, ":", null, null);
    }

    public void visitLand(GroovySourceAST t, int visit) {
        this.print(t, visit, " && ", null, null);
    }

    public void visitListConstructor(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "[", null, "]");
    }

    public void visitLiteralAssert(GroovySourceAST t, int visit) {
        this.print(t, visit, "assert ", null, null);
    }

    public void visitLiteralBoolean(GroovySourceAST t, int visit) {
        this.print(t, visit, "boolean", null, null);
    }

    public void visitLiteralBreak(GroovySourceAST t, int visit) {
        this.print(t, visit, "break", null, null);
    }

    public void visitLiteralCase(GroovySourceAST t, int visit) {
        this.print(t, visit, "case ", null, ":");
    }

    public void visitLiteralCatch(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, " catch (", null, ") ");
    }

    public void visitLiteralFalse(GroovySourceAST t, int visit) {
        this.print(t, visit, "false", null, null);
    }

    public void visitLiteralFloat(GroovySourceAST t, int visit) {
        this.print(t, visit, "float", null, null);
    }

    public void visitLiteralFor(GroovySourceAST t, int visit) {
        this.print(t, visit, "for ", null, null);
    }

    public void visitLiteralIf(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "if (", " else ", ") ");
    }

    public void visitLiteralInstanceof(GroovySourceAST t, int visit) {
        this.print(t, visit, " instanceof ", null, null);
    }

    public void visitLiteralInt(GroovySourceAST t, int visit) {
        this.print(t, visit, "int", null, null);
    }

    public void visitLiteralNew(GroovySourceAST t, int visit) {
        this.print(t, visit, "new ", "(", ")");
    }

    public void visitLiteralNull(GroovySourceAST t, int visit) {
        this.print(t, visit, "null", null, null);
    }

    public void visitLiteralPrivate(GroovySourceAST t, int visit) {
        this.print(t, visit, "private ", null, null);
    }

    public void visitLiteralProtected(GroovySourceAST t, int visit) {
        this.print(t, visit, "protected ", null, null);
    }

    public void visitLiteralPublic(GroovySourceAST t, int visit) {
        this.print(t, visit, "public ", null, null);
    }

    public void visitLiteralReturn(GroovySourceAST t, int visit) {
        this.print(t, visit, "return ", null, null);
    }

    public void visitLiteralStatic(GroovySourceAST t, int visit) {
        this.print(t, visit, "static ", null, null);
    }

    public void visitLiteralSwitch(GroovySourceAST t, int visit) {
        if (visit == 1) {
            this.print(t, visit, "switch (");
            ++this.tabLevel;
        }
        if (visit == 3) {
            this.print(t, visit, ") {");
        }
        if (visit == 2) {
            --this.tabLevel;
            this.print(t, visit, "}");
        }
    }

    public void visitLiteralThis(GroovySourceAST t, int visit) {
        this.print(t, visit, "this", null, null);
    }

    public void visitLiteralThrow(GroovySourceAST t, int visit) {
        this.print(t, visit, "throw ", null, null);
    }

    public void visitLiteralTrue(GroovySourceAST t, int visit) {
        this.print(t, visit, "true", null, null);
    }

    public void visitLiteralTry(GroovySourceAST t, int visit) {
        this.print(t, visit, "try ", null, null);
    }

    public void visitLiteralVoid(GroovySourceAST t, int visit) {
        this.print(t, visit, "void", null, " ");
    }

    public void visitLiteralWhile(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "while (", null, ") ");
    }

    public void visitLnot(GroovySourceAST t, int visit) {
        this.print(t, visit, "!", null, null);
    }

    public void visitLt(GroovySourceAST t, int visit) {
        this.print(t, visit, " < ", null, null);
    }

    public void visitMapConstructor(GroovySourceAST t, int visit) {
        if (t.getNumberOfChildren() == 0) {
            this.print(t, visit, "[:]", null, null);
        } else {
            this.printUpdatingTabLevel(t, visit, "[", null, "]");
        }
    }

    public void visitMemberPointer(GroovySourceAST t, int visit) {
        this.print(t, visit, ".&", null, null);
    }

    public void visitMethodCall(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "(", " ", ")");
    }

    public void visitMinus(GroovySourceAST t, int visit) {
        this.print(t, visit, " - ", null, null);
    }

    public void visitMethodDef(GroovySourceAST t, int visit) {
    }

    public void visitModifiers(GroovySourceAST t, int visit) {
    }

    public void visitNotEqual(GroovySourceAST t, int visit) {
        this.print(t, visit, " != ", null, null);
    }

    public void visitNumInt(GroovySourceAST t, int visit) {
        this.print(t, visit, t.getText(), null, null);
    }

    public void visitNumFloat(GroovySourceAST t, int visit) {
        this.print(t, visit, t.getText(), null, null);
    }

    public void visitObjblock(GroovySourceAST t, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
            this.print(t, visit, "{");
        } else {
            --this.tabLevel;
            this.print(t, visit, "}");
        }
    }

    public void visitPackageDef(GroovySourceAST t, int visit) {
        this.print(t, visit, "package ", null, null);
    }

    public void visitParameterDef(GroovySourceAST t, int visit) {
    }

    public void visitParameters(GroovySourceAST t, int visit) {
        this.printUpdatingTabLevel(t, visit, "(", ", ", ") ");
    }

    public void visitPlus(GroovySourceAST t, int visit) {
        this.print(t, visit, " + ", null, null);
    }

    public void visitQuestion(GroovySourceAST t, int visit) {
        this.print(t, visit, "?", ":", null);
    }

    public void visitRangeExclusive(GroovySourceAST t, int visit) {
        this.print(t, visit, "..<", null, null);
    }

    public void visitRangeInclusive(GroovySourceAST t, int visit) {
        this.print(t, visit, "..", null, null);
    }

    public void visitSlist(GroovySourceAST t, int visit) {
        if (visit == 1) {
            ++this.tabLevel;
            this.print(t, visit, "{");
        } else {
            --this.tabLevel;
            this.print(t, visit, "}");
        }
    }

    public void visitStar(GroovySourceAST t, int visit) {
        this.print(t, visit, "*", null, null);
    }

    public void visitStringConstructor(GroovySourceAST t, int visit) {
        if (visit == 1) {
            this.stringConstructorCounter = 0;
            this.print(t, visit, "\"");
        }
        if (visit == 3) {
            if (this.stringConstructorCounter % 2 == 0) {
                this.print(t, visit, "$");
            }
            ++this.stringConstructorCounter;
        }
        if (visit == 2) {
            this.print(t, visit, "\"");
        }
    }

    public void visitStringLiteral(GroovySourceAST t, int visit) {
        if (visit == 1) {
            String theString = this.escape(t.getText());
            if (this.getParentNode().getType() != 53 && this.getParentNode().getType() != 47) {
                theString = "\"" + theString + "\"";
            }
            this.print(t, visit, theString);
        }
    }

    private String escape(String literal) {
        literal = literal.replaceAll("\n", "\\\\<<REMOVE>>n");
        literal = literal.replaceAll("<<REMOVE>>", "");
        return literal;
    }

    public void visitType(GroovySourceAST t, int visit) {
        GroovySourceAST parent = this.getParentNode();
        GroovySourceAST modifiers = parent.childOfType(5);
        if (modifiers == null || modifiers.getNumberOfChildren() == 0) {
            if (visit == 1 && t.getNumberOfChildren() == 0) {
                this.print(t, visit, "def");
            }
            if (visit == 2) {
                this.print(t, visit, " ");
            }
        }
    }

    public void visitTypecast(GroovySourceAST t, int visit) {
        this.print(t, visit, "(", null, ")");
    }

    public void visitVariableDef(GroovySourceAST t, int visit) {
    }

    public void visitDefault(GroovySourceAST t, int visit) {
        if (visit == 1) {
            this.print(t, visit, "<" + this.tokenNames[t.getType()] + ">");
        } else {
            this.print(t, visit, "</" + this.tokenNames[t.getType()] + ">");
        }
    }

    protected void printUpdatingTabLevel(GroovySourceAST t, int visit, String opening, String subsequent, String closing) {
        if (visit == 1 && opening != null) {
            this.print(t, visit, opening);
            ++this.tabLevel;
        }
        if (visit == 3 && subsequent != null) {
            this.print(t, visit, subsequent);
        }
        if (visit == 2 && closing != null) {
            --this.tabLevel;
            this.print(t, visit, closing);
        }
    }

    protected void print(GroovySourceAST t, int visit, String opening, String subsequent, String closing) {
        if (visit == 1 && opening != null) {
            this.print(t, visit, opening);
        }
        if (visit == 3 && subsequent != null) {
            this.print(t, visit, subsequent);
        }
        if (visit == 2 && closing != null) {
            this.print(t, visit, closing);
        }
    }

    protected void print(GroovySourceAST t, int visit, String value) {
        if (visit == 1) {
            this.printNewlineAndIndent(t, visit);
        }
        if (visit == 2) {
            this.printNewlineAndIndent(t, visit);
        }
        this.out.print(value);
    }

    protected void printNewlineAndIndent(GroovySourceAST t, int visit) {
        int currentLine = t.getLine();
        if (this.lastLinePrinted == 0) {
            this.lastLinePrinted = currentLine;
        }
        if (this.lastLinePrinted != currentLine) {
            if (this.newLines && (visit != 1 || t.getType() != 7)) {
                int i;
                for (i = this.lastLinePrinted; i < currentLine; ++i) {
                    this.out.println();
                }
                if (this.lastLinePrinted > currentLine) {
                    this.out.println();
                }
                if (visit == 1 || visit == 2 && this.lastLinePrinted > currentLine) {
                    for (i = 0; i < this.tabLevel; ++i) {
                        this.out.print("    ");
                    }
                }
            }
            this.lastLinePrinted = Math.max(currentLine, this.lastLinePrinted);
        }
    }

    public void push(GroovySourceAST t) {
        this.stack.push(t);
    }

    public GroovySourceAST pop() {
        if (!this.stack.empty()) {
            return (GroovySourceAST)this.stack.pop();
        }
        return null;
    }

    private GroovySourceAST getParentNode() {
        Object currentNode = this.stack.pop();
        Object parentNode = this.stack.peek();
        this.stack.push(currentNode);
        return (GroovySourceAST)parentNode;
    }
}

