/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;

public class ObjectRange
extends AbstractList
implements Range {
    private Comparable from;
    private Comparable to;
    private int size = -1;
    private final boolean reverse;

    public ObjectRange(Comparable from, Comparable to) {
        this.reverse = InvokerHelper.compareGreaterThan(from, to);
        if (this.reverse) {
            this.constructorHelper(to, from);
        } else {
            this.constructorHelper(from, to);
        }
    }

    public ObjectRange(Comparable from, Comparable to, boolean reverse) {
        this.constructorHelper(from, to);
        this.reverse = reverse;
    }

    private void constructorHelper(Comparable from, Comparable to) {
        if (from == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'from' index in a Range");
        }
        if (to == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'to' index in a Range");
        }
        if (from.getClass() == to.getClass()) {
            this.from = from;
            this.to = to;
        } else {
            this.from = ObjectRange.normaliseType(from);
            this.to = ObjectRange.normaliseType(to);
        }
        if (from instanceof String || to instanceof String) {
            String start = from.toString();
            String end = to.toString();
            if (start.length() > end.length()) {
                throw new IllegalArgumentException("Incompatible Strings for Range: starting String is longer than ending string");
            }
            int length = Math.min(start.length(), end.length());
            int i = 0;
            for (i = 0; i < length && start.charAt(i) == end.charAt(i); ++i) {
            }
            if (i < length - 1) {
                throw new IllegalArgumentException("Incompatible Strings for Range: String#next() will not reach the expected value");
            }
        }
    }

    public int hashCode() {
        return this.from.hashCode() ^ this.to.hashCode() + (this.reverse ? 1 : 0);
    }

    public boolean equals(Object that) {
        if (that instanceof ObjectRange) {
            return this.equals((ObjectRange)that);
        }
        if (that instanceof List) {
            return this.equals((List)that);
        }
        return false;
    }

    public boolean equals(ObjectRange that) {
        return this.reverse == that.reverse && InvokerHelper.compareEqual(this.from, that.from) && InvokerHelper.compareEqual(this.to, that.to);
    }

    public boolean equals(List that) {
        int size = this.size();
        if (that.size() == size) {
            for (int i = 0; i < size; ++i) {
                if (InvokerHelper.compareEqual(this.get(i), that.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Comparable getFrom() {
        return this.from;
    }

    public Comparable getTo() {
        return this.to;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public Object get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " should not be negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " is too big for range: " + this);
        }
        Object value = null;
        if (this.reverse) {
            value = this.to;
            for (int i = 0; i < index; ++i) {
                value = this.decrement(value);
            }
        } else {
            value = this.from;
            for (int i = 0; i < index; ++i) {
                value = this.increment(value);
            }
        }
        return value;
    }

    public Iterator iterator() {
        return new Iterator(){
            int index = 0;
            Object value = ObjectRange.access$000(ObjectRange.this) ? ObjectRange.access$100(ObjectRange.this) : ObjectRange.access$200(ObjectRange.this);

            public boolean hasNext() {
                return this.index < ObjectRange.this.size();
            }

            public Object next() {
                if (this.index++ > 0) {
                    this.value = this.index > ObjectRange.this.size() ? null : (ObjectRange.this.reverse ? ObjectRange.this.decrement(this.value) : ObjectRange.this.increment(this.value));
                }
                return this.value;
            }

            public void remove() {
                ObjectRange.this.remove(this.index);
            }
        };
    }

    public int size() {
        if (this.size == -1) {
            if (this.from instanceof Integer && this.to instanceof Integer) {
                this.size = 0;
                int fromNum = (Integer)this.from;
                int toNum = (Integer)this.to;
                this.size = toNum - fromNum + 1;
            } else if (this.from instanceof BigDecimal || this.to instanceof BigDecimal) {
                this.size = 0;
                BigDecimal fromNum = new BigDecimal("" + this.from);
                BigDecimal toNum = new BigDecimal("" + this.to);
                BigInteger sizeNum = toNum.subtract(fromNum).add(new BigDecimal(1.0)).toBigInteger();
                this.size = sizeNum.intValue();
            } else {
                this.size = 0;
                Object value = this.from;
                while (this.to.compareTo(value) >= 0) {
                    value = this.increment(value);
                    ++this.size;
                }
            }
        }
        return this.size;
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        int size = this.size();
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (--toIndex >= size) {
            return new ObjectRange((Comparable)this.get(fromIndex), this.getTo(), this.reverse);
        }
        return new ObjectRange((Comparable)this.get(fromIndex), (Comparable)this.get(toIndex), this.reverse);
    }

    public String toString() {
        return this.reverse ? "" + this.to + ".." + this.from : "" + this.from + ".." + this.to;
    }

    public String inspect() {
        String toText = InvokerHelper.inspect(this.to);
        String fromText = InvokerHelper.inspect(this.from);
        return this.reverse ? "" + toText + ".." + fromText : "" + fromText + ".." + toText;
    }

    public boolean contains(Comparable value) {
        if (this.from instanceof BigDecimal || this.to instanceof BigDecimal) {
            int result = new BigDecimal("" + this.from).compareTo(new BigDecimal("" + value));
            if (result == 0) {
                return true;
            }
            return result < 0 && new BigDecimal("" + this.to).compareTo(new BigDecimal("" + value)) >= 0;
        }
        int result = this.from.compareTo(value);
        if (result == 0) {
            return true;
        }
        return result < 0 && this.to.compareTo(value) >= 0;
    }

    public void step(int step, Closure closure) {
        if (this.reverse) {
            step = -step;
        }
        if (step >= 0) {
            Comparable value = this.from;
            while (value.compareTo(this.to) <= 0) {
                closure.call(value);
                for (int i = 0; i < step; ++i) {
                    value = (Comparable)this.increment(value);
                }
            }
        } else {
            step = -step;
            Comparable value = this.to;
            while (value.compareTo(this.from) >= 0) {
                closure.call(value);
                for (int i = 0; i < step; ++i) {
                    value = (Comparable)this.decrement(value);
                }
            }
        }
    }

    public List step(int step) {
        IteratorClosureAdapter adapter = new IteratorClosureAdapter(this);
        this.step(step, adapter);
        return adapter.asList();
    }

    protected Object increment(Object value) {
        return InvokerHelper.invokeMethod(value, "next", null);
    }

    protected Object decrement(Object value) {
        return InvokerHelper.invokeMethod(value, "previous", null);
    }

    private static Comparable normaliseType(Comparable operand) {
        if (operand instanceof Character) {
            return new Integer(((Character)operand).charValue());
        }
        if (operand instanceof String) {
            String string = (String)((Object)operand);
            if (string.length() == 1) {
                return new Integer(string.charAt(0));
            }
            return string;
        }
        return operand;
    }

    static /* synthetic */ Comparable access$100(ObjectRange x0) {
        return x0.to;
    }

    static /* synthetic */ Comparable access$200(ObjectRange x0) {
        return x0.from;
    }
}

