/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaMimeKeys;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.SAXException;

public class ParseUtils
implements TikaMimeKeys {
    public static Parser getParser(String mimeType, TikaConfig config) throws TikaException {
        return config.getParser(MediaType.parse(mimeType));
    }

    public static Parser getParser(URL documentUrl, TikaConfig config) throws TikaException {
        String mimetype = config.getMimeRepository().getMimeType(documentUrl).getName();
        return ParseUtils.getParser(mimetype, config);
    }

    public static Parser getParser(File documentFile, TikaConfig config) throws TikaException {
        String mimetype = config.getMimeRepository().getMimeType(documentFile).getName();
        return ParseUtils.getParser(mimetype, config);
    }

    public static String getStringContent(InputStream stream, TikaConfig config, String mimeType) throws TikaException, IOException {
        try {
            Parser parser = config.getParser(MediaType.parse(mimeType));
            BodyContentHandler handler = new BodyContentHandler();
            parser.parse(stream, handler, new Metadata());
            return ((Object)handler).toString();
        }
        catch (SAXException e) {
            throw new TikaException("Unexpected SAX error", e);
        }
    }

    public static String getStringContent(URL documentUrl, TikaConfig config) throws TikaException, IOException {
        String mime = config.getMimeRepository().getMimeType(documentUrl).getName();
        return ParseUtils.getStringContent(documentUrl, config, mime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringContent(URL documentUrl, TikaConfig config, String mimeType) throws TikaException, IOException {
        InputStream stream = documentUrl.openStream();
        try {
            String string = ParseUtils.getStringContent(stream, config, mimeType);
            return string;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringContent(File documentFile, TikaConfig config, String mimeType) throws TikaException, IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(documentFile));
        try {
            String string = ParseUtils.getStringContent(stream, config, mimeType);
            return string;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public static String getStringContent(File documentFile, TikaConfig config) throws TikaException, IOException {
        String mime = config.getMimeRepository().getMimeType(documentFile).getName();
        return ParseUtils.getStringContent(documentFile, config, mime);
    }
}

