/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;

public class WrappedSyntaxView
extends BoxView
implements TabExpander,
RSTAView {
    boolean widthChanging;
    int tabBase;
    int tabSize;
    private Segment s = new Segment();
    private Segment drawSeg = new Segment();
    private Rectangle tempRect = new Rectangle();
    private RSyntaxTextArea host;
    private FontMetrics metrics;
    private static final int MIN_WIDTH = 20;

    public WrappedSyntaxView(Element elem) {
        super(elem, 1);
    }

    protected int calculateBreakPosition(int p0, Token tokenList, float x0) {
        int p = p0;
        RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
        float currentWidth = this.getWidth();
        if (currentWidth == 2.1474836E9f) {
            currentWidth = this.getPreferredSpan(0);
        }
        currentWidth = Math.max(currentWidth, 20.0f);
        for (Token t = tokenList; t != null && t.isPaintable(); t = t.getNextToken()) {
            float tokenWidth = t.getWidth(textArea, this, x0);
            if (tokenWidth > currentWidth) {
                if (p == p0) {
                    return t.getOffsetBeforeX(textArea, this, 0.0f, currentWidth);
                }
                return t.type == 16 ? p + t.textCount : p;
            }
            currentWidth -= tokenWidth;
            x0 += tokenWidth;
            p += t.textCount;
        }
        return p + 1;
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateChildren(e, a);
    }

    protected void drawView(Graphics2D g, Rectangle r, View view, int fontHeight, int y) {
        float x = r.x;
        LayeredHighlighter h = (LayeredHighlighter)this.host.getHighlighter();
        RSyntaxDocument document = (RSyntaxDocument)this.getDocument();
        Element map = this.getElement();
        int p0 = view.getStartOffset();
        int lineNumber = map.getElementIndex(p0);
        int p1 = view.getEndOffset();
        this.setSegment(p0, p1 - 1, document, this.drawSeg);
        int start = p0 - this.drawSeg.offset;
        Token token = document.getTokenListForLine(lineNumber);
        if (token != null && token.type == 0) {
            h.paintLayeredHighlights(g, p0, p1, r, this.host, this);
            return;
        }
        while (token != null && token.isPaintable()) {
            int p = this.calculateBreakPosition(p0, token, x);
            x = r.x;
            h.paintLayeredHighlights(g, p0, p, r, this.host, this);
            while (token != null && token.isPaintable() && token.offset + token.textCount - 1 < p) {
                x = token.paint(g, x, y, this.host, this);
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.offset < p) {
                int tokenOffset = token.offset;
                DefaultToken temp = new DefaultToken(this.drawSeg, tokenOffset - start, p - 1 - start, tokenOffset, token.type);
                temp.paint(g, x, y, this.host, this);
                temp = null;
                token.makeStartAt(p);
            }
            p0 = p == p0 ? p1 : p;
            y += fontHeight;
        }
        if (this.host.getEOLMarkersVisible()) {
            g.setColor(this.host.getForegroundForTokenType(16));
            g.setFont(this.host.getFontForTokenType(16));
            g.drawString("\u00b6", x, (float)(y - fontHeight));
        }
    }

    public float getMaximumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)this.metrics.charWidth('\u00b6');
        }
        return span;
    }

    public float getMinimumSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)this.metrics.charWidth('\u00b6');
        }
        return span;
    }

    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        float span = super.getPreferredSpan(axis);
        if (axis == 0) {
            span += (float)this.metrics.charWidth('\u00b6');
        }
        return span;
    }

    protected int getTabSize() {
        Integer i = (Integer)this.getDocument().getProperty("tabSize");
        int size = i != null ? i : 5;
        return size;
    }

    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateChildren(changes, a);
        Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        int pos = changes.getOffset();
        View v = this.getViewAtPosition(pos, alloc);
        if (v != null) {
            v.insertUpdate(changes, alloc, f);
        }
    }

    protected void loadChildren(ViewFactory f) {
        Element e = this.getElement();
        int n = e.getElementCount();
        if (n > 0) {
            View[] added = new View[n];
            for (int i = 0; i < n; ++i) {
                added[i] = new WrappedLine(e.getElement(i));
            }
            this.replace(0, 0, added);
        }
    }

    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle r1;
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        Rectangle r0 = s0.getBounds();
        Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        if (r0.y != r1.y) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        if (p1 > p0) {
            r0.width -= r1.width;
        }
        return r0;
    }

    public float nextTabStop(float x, int tabOffset) {
        if (this.tabSize == 0) {
            return x;
        }
        int ntabs = ((int)x - this.tabBase) / this.tabSize;
        return this.tabBase + (ntabs + 1) * this.tabSize;
    }

    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.tabBase = alloc.x;
        Graphics2D g2d = (Graphics2D)g;
        this.host = (RSyntaxTextArea)this.getContainer();
        int ascent = this.host.getMaxAscent();
        int fontHeight = this.host.getLineHeight();
        int n = this.getViewCount();
        int x = alloc.x + this.getLeftInset();
        int y = alloc.y + this.getTopInset();
        Rectangle clip = g.getClipBounds();
        for (int i = 0; i < n; ++i) {
            this.tempRect.x = x + this.getOffset(0, i);
            this.tempRect.y = y + this.getOffset(1, i);
            this.tempRect.width = this.getSpan(0, i);
            this.tempRect.height = this.getSpan(1, i);
            if (!this.tempRect.intersects(clip)) continue;
            View view = this.getView(i);
            this.drawView(g2d, alloc, view, fontHeight, this.tempRect.y + ascent);
        }
    }

    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateChildren(changes, a);
        Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        int pos = changes.getOffset();
        View v = this.getViewAtPosition(pos, alloc);
        if (v != null) {
            v.removeUpdate(changes, alloc, f);
        }
    }

    private void setSegment(int p0, int p1, Document document, Segment seg) {
        try {
            document.getText(p0, p1 - p0, seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void setSize(float width, float height) {
        this.updateMetrics();
        if ((int)width != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(width, height);
        this.widthChanging = false;
    }

    void updateChildren(DocumentEvent e, Shape a) {
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = e.getChange(elem);
        if (e.getType() == DocumentEvent.EventType.CHANGE) {
            this.getContainer().repaint();
        } else if (ec != null) {
            Element[] removedElems = ec.getChildrenRemoved();
            Element[] addedElems = ec.getChildrenAdded();
            View[] added = new View[addedElems.length];
            for (int i = 0; i < addedElems.length; ++i) {
                added[i] = new WrappedLine(addedElems[i]);
            }
            this.replace(ec.getIndex(), removedElems.length, added);
            if (a != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void updateMetrics() {
        Container host = this.getContainer();
        Font f = host.getFont();
        this.metrics = host.getFontMetrics(f);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    public int yForLineContaining(Rectangle alloc, int offs) throws BadLocationException {
        Element map = this.getElement();
        int line = map.getElementIndex(offs);
        if (this.isAllocationValid()) {
            return alloc.y + this.getOffset(1, line);
        }
        return -1;
    }

    class WrappedLine
    extends View {
        int nlines;

        WrappedLine(Element elem) {
            super(elem);
        }

        final int calculateLineCount() {
            int nlines = 0;
            int startOffset = this.getStartOffset();
            int p1 = this.getEndOffset();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(startOffset);
            Token tokenList = doc.getTokenListForLine(line);
            float x0 = 0.0f;
            int p0 = startOffset;
            while (p0 < p1) {
                ++nlines;
                int p = WrappedSyntaxView.this.calculateBreakPosition(p0, tokenList, x0 = RSyntaxUtilities.makeTokenListStartAt(tokenList, p0, WrappedSyntaxView.this, textArea, x0));
                p0 = p == p0 ? ++p : p;
            }
            return nlines;
        }

        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    float width = WrappedSyntaxView.this.getWidth();
                    if (width == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return width;
                }
                case 1: {
                    if (this.nlines == 0 || WrappedSyntaxView.this.widthChanging) {
                        this.nlines = this.calculateLineCount();
                    }
                    int h = this.nlines * ((RSyntaxTextArea)this.getContainer()).getLineHeight();
                    return h;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        public void paint(Graphics g, Shape a) {
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle alloc = a.getBounds();
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            alloc.width = 1;
            int p0 = this.getStartOffset();
            int p1 = this.getEndOffset();
            int testP = b == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            Element map = doc.getDefaultRootElement();
            int line = map.getElementIndex(p0);
            Token tokenList = doc.getTokenListForLine(line);
            float x0 = alloc.x;
            while (p0 < p1) {
                x0 = RSyntaxUtilities.makeTokenListStartAt(tokenList, p0, WrappedSyntaxView.this, textArea, x0);
                int p = WrappedSyntaxView.this.calculateBreakPosition(p0, tokenList, x0);
                if (pos >= p0 && testP < p) {
                    alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p0, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    return alloc;
                }
                if (p == p1 - 1 && pos == p1 - 1) {
                    if (pos > p0) {
                        alloc = RSyntaxUtilities.getLineWidthUpTo(textArea, WrappedSyntaxView.this.s, p0, pos, WrappedSyntaxView.this, alloc, alloc.x);
                    }
                    return alloc;
                }
                p0 = p == p0 ? p1 : p;
                alloc.y += alloc.height;
            }
            throw new BadLocationException(null, pos);
        }

        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a;
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            int x = (int)fx;
            int y = (int)fy;
            if (y < alloc.y) {
                return this.getStartOffset();
            }
            if (y > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            RSyntaxTextArea textArea = (RSyntaxTextArea)this.getContainer();
            alloc.height = textArea.getLineHeight();
            int p1 = this.getEndOffset();
            Element map = doc.getDefaultRootElement();
            int p0 = this.getStartOffset();
            int line = map.getElementIndex(p0);
            Token tlist = doc.getTokenListForLine(line);
            while (p0 < p1) {
                RSyntaxUtilities.makeTokenListStartAt(tlist, p0, WrappedSyntaxView.this, textArea, alloc.x);
                int p = WrappedSyntaxView.this.calculateBreakPosition(p0, tlist, alloc.x);
                if (y >= alloc.y && y < alloc.y + alloc.height) {
                    if (x < alloc.x) {
                        return p0;
                    }
                    if (x > alloc.x + alloc.width) {
                        return p - 1;
                    }
                    int n = tlist.getListOffset(textArea, WrappedSyntaxView.this, alloc.x, x);
                    return Math.max(Math.min(n, p1 - 1), p0);
                }
                p0 = p == p0 ? p1 : p;
                alloc.y += alloc.height;
            }
            return this.getEndOffset() - 1;
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (a != null) {
                Container c = this.getContainer();
                Rectangle alloc = (Rectangle)a;
                c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (a != null) {
                Container c = this.getContainer();
                Rectangle alloc = (Rectangle)a;
                c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }
    }
}

