/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.renderers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import com.jurismarches.vradi.ui.renderers.ColorsMap;
import com.jurismarches.vradi.ui.thesaurus.ThesaurusDataProvider;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.renderer.StringValue;

public class ThesaurusHighlighter
extends AbstractHighlighter
implements TreeCellRenderer,
ListCellRenderer {
    private static final Log log = LogFactory.getLog(ThesaurusHighlighter.class);
    protected DefaultListCellRenderer delegate = null;
    protected HighlighterType type;
    protected ThesaurusDataProvider dataProvider;
    protected Map<Thesaurus, String> toolTipCache;

    public ThesaurusHighlighter() {
        this(HighlighterType.DEFAULTS);
    }

    public ThesaurusHighlighter(HighlighterType type) {
        super(HighlightPredicate.ALWAYS);
        this.type = type;
        this.delegate = new DefaultListCellRenderer();
    }

    public ThesaurusHighlighter(ThesaurusDataProvider dataProvider) {
        super(HighlightPredicate.ALWAYS);
        this.delegate = new DefaultListCellRenderer();
        this.type = HighlighterType.CARTOGRAHY;
        this.dataProvider = dataProvider;
        this.toolTipCache = new HashMap<Thesaurus, String>();
    }

    protected boolean isDefault() {
        return this.type.equals((Object)HighlighterType.DEFAULTS);
    }

    protected boolean isEdit() {
        return this.type.equals((Object)HighlighterType.EDIT);
    }

    protected boolean isMove() {
        return this.type.equals((Object)HighlighterType.MOVE);
    }

    protected boolean isProposition() {
        return this.type.equals((Object)HighlighterType.PROPOSITION);
    }

    protected boolean isCartography() {
        return this.type.equals((Object)HighlighterType.CARTOGRAHY);
    }

    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        int depth = adapter.getDepth();
        Color color = this.getDepthColor(depth);
        if (color != null) {
            component.setForeground(color);
        }
        return component;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        RootThesaurus rootThesaurus;
        Object node;
        int depth = 0;
        String text = null;
        Thesaurus thesaurus = null;
        if (value instanceof VradiTreeNode) {
            node = (VradiTreeNode)((Object)value);
            rootThesaurus = ThesaurusTreeHelper.getRootThesaurus(node);
            if (rootThesaurus == null) {
                thesaurus = ThesaurusTreeHelper.getThesaurus(node);
            }
        } else if (value instanceof VradiTreeTableNode) {
            node = (VradiTreeTableNode)((Object)value);
            rootThesaurus = ThesaurusTreeTableHelper.getRootThesaurus((VradiTreeTableNode)((Object)node));
            if (rootThesaurus == null) {
                thesaurus = ThesaurusTreeTableHelper.getThesaurus((VradiTreeTableNode)((Object)node));
            }
        } else {
            return new JLabel(value.toString());
        }
        JLabel jLabel = null;
        if (rootThesaurus != null) {
            text = rootThesaurus.getName();
            jLabel = new JLabel(text);
        } else if (thesaurus != null) {
            depth = ThesaurusDataHelper.getDepth(thesaurus);
            text = ThesaurusDataHelper.concateOrderName(thesaurus);
            jLabel = new ToolTipLbl(text, thesaurus);
        }
        if (text == null) {
            return new JLabel(value.toString());
        }
        Color color = this.getDepthColor(depth);
        if (color != null) {
            jLabel.setForeground(color);
        }
        return jLabel;
    }

    protected String getThesaurusToolTipText(Thesaurus thesaurus) {
        String tooltip;
        if (this.isMove() || this.isEdit()) {
            tooltip = ToolTipHelper.getThesaurusDescriptionToolTip(thesaurus);
        } else if (this.isCartography()) {
            tooltip = this.toolTipCache.get(thesaurus);
            if (tooltip == null) {
                tooltip = this.dataProvider.getCartographyToolTip(thesaurus);
                this.toolTipCache.put(thesaurus, tooltip);
            }
        } else {
            tooltip = ToolTipHelper.getThesaurusToolTip(thesaurus);
        }
        if (tooltip != null && !tooltip.trim().isEmpty()) {
            return tooltip;
        }
        return null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        int depth = 0;
        String namePath = null;
        Thesaurus thesaurus = null;
        if (value instanceof VradiTreeNode) {
            VradiTreeNode node = (VradiTreeNode)((Object)value);
            RootThesaurus rootThesaurus = ThesaurusTreeHelper.getRootThesaurus(node);
            if (rootThesaurus != null) {
                text = rootThesaurus.getName();
            } else {
                thesaurus = ThesaurusTreeHelper.getThesaurus(node);
                if (thesaurus == null) {
                    return new JLabel(value.toString());
                }
                depth = ThesaurusDataHelper.getDepth(thesaurus);
                text = ThesaurusDataHelper.concateOrderName(thesaurus);
            }
        } else if (value instanceof Thesaurus) {
            thesaurus = (Thesaurus)value;
            depth = ThesaurusDataHelper.getDepth(thesaurus);
            text = ThesaurusDataHelper.concateOrderName(thesaurus);
            namePath = ThesaurusDataHelper.getNamePath(thesaurus, "/");
        } else {
            return new JLabel(value.toString());
        }
        if (text == null) {
            return new JLabel(value.toString());
        }
        Color color = this.getDepthColor(depth);
        if (this.isProposition()) {
            text = namePath;
        }
        JLabel jLabel = (JLabel)this.delegate.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        if (color != null) {
            jLabel.setForeground(color);
        }
        if (thesaurus != null) {
            jLabel.setToolTipText(ToolTipHelper.getThesaurusToolTip(thesaurus));
        }
        return jLabel;
    }

    public Color getDepthColor(int depth) {
        Color color = ColorsMap.getInstance().get(depth);
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    protected class ToolTipStringValue
    implements StringValue {
        protected ToolTipStringValue() {
        }

        public String getString(Object value) {
            if (value instanceof Thesaurus) {
                Thesaurus thesaurus = (Thesaurus)value;
                String toolTipText = ThesaurusHighlighter.this.getThesaurusToolTipText(thesaurus);
                return toolTipText;
            }
            return null;
        }
    }

    protected class ToolTipLbl
    extends JLabel {
        protected Thesaurus thesaurus;

        public ToolTipLbl(String text, Thesaurus thesaurus) {
            super(text);
            this.thesaurus = thesaurus;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return ThesaurusHighlighter.this.getThesaurusToolTipText(this.thesaurus);
        }
    }

    public static enum HighlighterType {
        DEFAULTS,
        EDIT,
        PROPOSITION,
        CARTOGRAHY,
        MOVE;

    }
}

